/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.builders.lodBuilding.bufferBuilding;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.logging.SpamReducedLogger;
import com.seibel.lod.core.objects.Pos2D;
import com.seibel.lod.core.objects.lod.LodDimension;
import com.seibel.lod.core.objects.lod.RegionPos;
import com.seibel.lod.core.objects.opengl.RenderRegion;
import com.seibel.lod.core.render.LodRenderer;
import com.seibel.lod.core.render.objects.GLBuffer;
import com.seibel.lod.core.util.LevelPosUtil;
import com.seibel.lod.core.util.LodThreadFactory;
import com.seibel.lod.core.util.LodUtil;
import com.seibel.lod.core.util.StatsMap;
import com.seibel.lod.core.util.gridList.MovableGridRingList;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.ReentrantLock;

public class LodBufferBuilderFactory {
    public static final boolean ENABLE_BUFFER_PERF_LOGGING = false;
    public static final boolean ENABLE_EVENT_LOGGING = false;
    public static final boolean ENABLE_LAG_SPIKE_LOGGING = false;
    public static final long LAG_SPIKE_THRESOLD_NS = TimeUnit.NANOSECONDS.convert(16L, TimeUnit.MILLISECONDS);
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    private static final IMinecraftClientWrapper MC = SingletonHandler.get(IMinecraftClientWrapper.class);
    private static LodThreadFactory mainGenThreadFactory = new LodThreadFactory(LodBufferBuilderFactory.class.getSimpleName() + " - main", 3);
    public static ExecutorService mainGenThread = Executors.newSingleThreadExecutor(mainGenThreadFactory);
    private static LodThreadFactory bufferBuilderThreadFactory = new LodThreadFactory("BufferBuilder", 3);
    private static int previousBufferBuilderThreads = CONFIG.client().advanced().threading().getNumberOfBufferBuilderThreads();
    public static ExecutorService bufferBuilderThreads = Executors.newFixedThreadPool(previousBufferBuilderThreads, bufferBuilderThreadFactory);
    private static LodThreadFactory bufferUploadThreadFactory = new LodThreadFactory(LodBufferBuilderFactory.class.getSimpleName() + " - upload", 4);
    public static ExecutorService bufferUploadThread = Executors.newSingleThreadExecutor(bufferUploadThreadFactory);
    public static final int DEFAULT_MEMORY_ALLOCATION = LodUtil.LOD_VERTEX_FORMAT.getByteSize() * 3 * 8;
    public static final int QUADS_BYTE_SIZE = LodUtil.LOD_VERTEX_FORMAT.getByteSize() * 4;
    public static final int MAX_TRIANGLES_PER_BUFFER = 0x100000 / (LodUtil.LOD_VERTEX_FORMAT.getByteSize() * 3);
    public static final int MAX_QUADS_PER_BUFFER = 0x100000 / QUADS_BYTE_SIZE;
    public static final int FULL_SIZED_BUFFER = MAX_QUADS_PER_BUFFER * QUADS_BYTE_SIZE;
    public static int skyLightPlayer = 15;
    public MovableGridRingList<RenderRegion> renderRegions = null;
    public int previousBufferSize = 0;
    public int previousRegionWidth = 0;
    private boolean builderThreadRunning = false;
    public ReentrantLock regionsListLock = new ReentrantLock();
    private final SpamReducedLogger ramLogger = new SpamReducedLogger(1);

    public void setRegionNeedRegen(int regionX, int regionZ) {
        MovableGridRingList<RenderRegion> r = this.renderRegions;
        if (r == null) {
            return;
        }
        RenderRegion rr = r.get(regionX, regionZ);
        if (rr == null) {
            return;
        }
        rr.setNeedRegen();
    }

    public boolean updateAndSwapLodBuffersAsync(LodRenderer renderer, LodDimension lodDim, int playerX, int playerY, int playerZ, boolean fullRegen) {
        if (this.builderThreadRunning) {
            return false;
        }
        this.builderThreadRunning = true;
        Runnable thread = () -> this.generateLodBuffersThread(renderer, lodDim, playerX, playerY, playerZ, fullRegen);
        mainGenThread.execute(thread);
        return true;
    }

    private void updateRingList(int playerX, int playerZ, int regionWidth) throws InterruptedException {
        if (this.renderRegions != null && regionWidth != this.renderRegions.getSize()) {
            this.renderRegions.clear(RenderRegion::close);
            this.renderRegions = null;
        }
        LodUtil.checkInterrupts();
        if (this.renderRegions == null) {
            this.renderRegions = new MovableGridRingList(regionWidth / 2, LevelPosUtil.getRegion((byte)0, playerX), LevelPosUtil.getRegion((byte)0, playerZ));
            ApiShared.LOGGER.info("============Render Regions rebuilt============");
        } else {
            this.renderRegions.move(LevelPosUtil.getRegion((byte)0, playerX), LevelPosUtil.getRegion((byte)0, playerZ), RenderRegion::close);
        }
    }

    private void resetThreadPools(boolean dumpThread) {
        if (dumpThread) {
            bufferBuilderThreadFactory.dumpAllThreadStacks();
            bufferUploadThreadFactory.dumpAllThreadStacks();
        }
        bufferBuilderThreads.shutdownNow();
        bufferUploadThread.shutdownNow();
        previousBufferBuilderThreads = CONFIG.client().advanced().threading().getNumberOfBufferBuilderThreads();
        bufferBuilderThreadFactory = new LodThreadFactory("BufferBuilder", 3);
        bufferBuilderThreads = Executors.newFixedThreadPool(previousBufferBuilderThreads, bufferBuilderThreadFactory);
        bufferUploadThreadFactory = new LodThreadFactory(LodBufferBuilderFactory.class.getSimpleName() + " - upload", 4);
        bufferUploadThread = Executors.newSingleThreadExecutor(bufferUploadThreadFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateLodBuffersThread(LodRenderer renderer, LodDimension lodDim, int playerX, int playerY, int playerZ, boolean fullRegen) {
        try {
            if (previousBufferBuilderThreads != CONFIG.client().advanced().threading().getNumberOfBufferBuilderThreads()) {
                this.resetThreadPools(false);
            }
            this.regionsListLock.lockInterruptibly();
            long startTime = System.currentTimeMillis();
            boolean doCaveCulling = CONFIG.client().graphics().advancedGraphics().getEnableCaveCulling();
            doCaveCulling &= !lodDim.dimension.hasCeiling();
            doCaveCulling &= lodDim.dimension.hasSkyLight();
            doCaveCulling &= playerY > CONFIG.client().graphics().advancedGraphics().getCaveCullingHeight() + 5;
            int playerSkylight = MC.getPlayerSkylight();
            doCaveCulling &= playerSkylight > 7;
            try {
                this.updateRingList(playerX, playerZ, lodDim.getWidth());
                skyLightPlayer = MC.getWrappedClientWorld().getSkyLight(playerX, playerY, playerZ);
                Pos2D minPos = this.renderRegions.getMinInRange();
                Pos2D maxPos = this.renderRegions.getMaxInRange();
                CompletableFuture<Object> future = CompletableFuture.completedFuture(null);
                try {
                    int numOfJobs = 0;
                    for (int regX = minPos.x; regX < maxPos.x; ++regX) {
                        for (int regZ = minPos.y; regZ < maxPos.y; ++regZ) {
                            CompletableFuture newFuture;
                            RenderRegion r = this.renderRegions.get(regX, regZ);
                            RegionPos regPos = new RegionPos(regX, regZ);
                            if (r != null && !r.canRender(lodDim, regPos)) {
                                this.renderRegions.set(regX, regZ, null);
                                r.close();
                                r = null;
                            }
                            if (r == null) {
                                r = new RenderRegion(regPos, lodDim);
                                this.renderRegions.set(regX, regZ, r);
                            }
                            if ((newFuture = (CompletableFuture)r.updateStatus(bufferUploadThread, bufferBuilderThreads, fullRegen, playerX, playerZ, doCaveCulling).orElse(null)) == null) continue;
                            future = CompletableFuture.allOf(future, newFuture);
                            ++numOfJobs;
                        }
                    }
                    long executeStart = System.currentTimeMillis();
                    try {
                        future.get(1L, TimeUnit.MINUTES);
                    }
                    catch (CancellationException ce) {
                        throw new InterruptedException("Future interrupted");
                    }
                    catch (ExecutionException ee) {
                        ApiShared.LOGGER.error("LodBufferBuilder ran into trouble: ", ee.getCause());
                    }
                    long executeEnd = System.currentTimeMillis();
                    long endTime = System.currentTimeMillis();
                    long buildTime = endTime - startTime;
                    long l = executeEnd - executeStart;
                }
                catch (InterruptedException ie) {
                    this.resetThreadPools(false);
                    try {
                        future.get();
                    }
                    catch (Throwable throwable) {}
                }
                catch (TimeoutException te) {
                    ApiShared.LOGGER.error("LodBufferBuilder timed out: ", (Throwable)te);
                    this.resetThreadPools(true);
                }
            }
            catch (RuntimeException e) {
                ApiShared.LOGGER.error("\"LodNodeBufferBuilder.generateLodBuffersAsync\" ran into trouble: ", (Throwable)e);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.regionsListLock.unlock();
            this.builderThreadRunning = false;
        }
    }

    public void dumpBufferMemoryUsage() {
        if (!this.ramLogger.canMaybeLog()) {
            return;
        }
        this.ramLogger.info("Dumping Ram Usage for buffer usage...", new Object[0]);
        StatsMap statsMap = new StatsMap();
        if (this.renderRegions == null) {
            this.ramLogger.info("Buildable VBOs are null!", new Object[0]);
        } else {
            for (RenderRegion buffers : this.renderRegions) {
                if (buffers == null) continue;
                buffers.debugDumpStats(statsMap);
            }
        }
        statsMap.incStat("Total Buffers", GLBuffer.count.get());
        this.ramLogger.info("================================================", new Object[0]);
        this.ramLogger.info("Stats: {}", statsMap);
        this.ramLogger.info("================================================", new Object[0]);
        this.ramLogger.incLogTries();
    }

    public void destroyBuffers() {
        ApiShared.LOGGER.info("Destroying LodBufferBuilder...");
        mainGenThread.shutdownNow();
        mainGenThread = Executors.newSingleThreadExecutor(mainGenThreadFactory);
        boolean locked = false;
        try {
            locked = this.regionsListLock.tryLock(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            if (this.renderRegions != null) {
                this.renderRegions.clear(RenderRegion::close);
            }
            this.renderRegions = null;
        }
        finally {
            if (locked) {
                this.regionsListLock.unlock();
            }
        }
        ApiShared.LOGGER.info("LodBufferBuilder destroyed.");
    }

    public MovableGridRingList<RenderRegion> getRenderRegions() {
        return this.renderRegions;
    }

    @Deprecated
    public void triggerReset() {
    }

    public static class LagSpikeCatcher {
        long timer = System.nanoTime();

        public void end(String source) {
        }
    }
}

