/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.handlers;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.builders.lodBuilding.LodBuilder;
import com.seibel.lod.core.builders.lodBuilding.LodBuilderConfig;
import com.seibel.lod.core.enums.config.DistanceGenerationMode;
import com.seibel.lod.core.enums.config.VerticalQuality;
import com.seibel.lod.core.handlers.LodDimensionFileHandler;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.handlers.dimensionFinder.PlayerData;
import com.seibel.lod.core.handlers.dimensionFinder.SubDimCompare;
import com.seibel.lod.core.logging.ConfigBasedLogger;
import com.seibel.lod.core.objects.lod.LodDimension;
import com.seibel.lod.core.objects.lod.LodRegion;
import com.seibel.lod.core.objects.lod.RegionPos;
import com.seibel.lod.core.util.DataPointUtil;
import com.seibel.lod.core.util.LodUtil;
import com.seibel.lod.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.lod.core.wrapperInterfaces.chunk.AbstractChunkPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IWorldWrapper;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.logging.log4j.LogManager;
import shaded.electronwill.nightconfig.core.file.CommentedFileConfig;

public class LodDimensionFinder {
    private static final IMinecraftClientWrapper MC = SingletonHandler.get(IMinecraftClientWrapper.class);
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    private static final IWrapperFactory FACTORY = SingletonHandler.get(IWrapperFactory.class);
    public static final ConfigBasedLogger LOGGER = new ConfigBasedLogger(LogManager.getLogger(LodDimensionFinder.class), () -> CONFIG.client().advanced().debugging().debugSwitch().getLogFileSubDimEvent());
    private static final VerticalQuality VERTICAL_QUALITY_TO_TEST_WITH = VerticalQuality.LOW;
    public static final String THREAD_NAME = "Sub-Dimension-Finder";
    public static final String DEFAULT_SAVE_DIMENSION_FOLDER = "_Default-Sub-Dimension";
    private PlayerData playerData = new PlayerData(MC);
    private PlayerData firstSeenPlayerData = null;
    private volatile LodDimension foundLodDimension = null;
    private AtomicBoolean determiningWorldFolder = new AtomicBoolean(false);

    public boolean isDone() {
        return this.foundLodDimension != null;
    }

    public LodDimension getAndClearFoundLodDimension() {
        LodDimension returnDim = this.foundLodDimension;
        this.foundLodDimension = null;
        return returnDim;
    }

    public void AttemptToDetermineSubDimensionAsync(IDimensionTypeWrapper dimensionTypeWrapper) {
        if (this.determiningWorldFolder.getAndSet(true)) {
            return;
        }
        Thread thread = new Thread(() -> {
            try {
                File saveDir = CONFIG.client().multiplayer().getMultiDimensionRequiredSimilarity() == 0.0 ? this.getDefaultSubDimensionFolder(dimensionTypeWrapper) : this.attemptToDetermineSubDimensionFolder();
                if (saveDir == null) {
                    return;
                }
                this.foundLodDimension = new LodDimension(dimensionTypeWrapper, ApiShared.lodBuilder.defaultDimensionWidthInRegions, saveDir);
            }
            catch (IOException e) {
                ApiShared.LOGGER.error("Unable to set the dimension file handler for dimension type [" + dimensionTypeWrapper.getDimensionName() + "]. Error: " + e.getMessage(), (Throwable)e);
            }
            finally {
                this.determiningWorldFolder.set(false);
            }
        });
        thread.setName(THREAD_NAME);
        thread.start();
    }

    public File getDefaultSubDimensionFolder(IDimensionTypeWrapper dimensionTypeWrapper) throws IOException {
        Object subDimFolder = null;
        LOGGER.info("Attempting to determine default sub-dimension for [" + MC.getCurrentDimension().getDimensionName() + "]", new Object[0]);
        File dimensionFolder = LodDimensionFinder.GetDimensionFolder(MC.getCurrentDimension(), "");
        this.moveOldSaveFoldersIfNecessary(dimensionFolder, MC.getCurrentDimension(), DEFAULT_SAVE_DIMENSION_FOLDER);
        if (dimensionFolder.listFiles() != null) {
            LOGGER.info("Potential Sub Dimension folders: [" + dimensionFolder.listFiles(File::isDirectory).length + "]", new Object[0]);
            Object[] potentialSubDimFolders = dimensionFolder.listFiles();
            Arrays.sort(potentialSubDimFolders);
            for (Object potentialSubDim : potentialSubDimFolders) {
                if (!LodDimensionFinder.isValidSubDimensionDirectory((File)potentialSubDim)) continue;
                if (((File)potentialSubDim).getName().equals(DEFAULT_SAVE_DIMENSION_FOLDER)) {
                    subDimFolder = potentialSubDim;
                    break;
                }
                if (subDimFolder != null) continue;
                subDimFolder = potentialSubDim;
            }
        }
        if (subDimFolder == null) {
            subDimFolder = LodDimensionFinder.GetDimensionFolder(dimensionTypeWrapper, DEFAULT_SAVE_DIMENSION_FOLDER);
            LOGGER.info("Default Sub Dimension not found. Creating: [_Default-Sub-Dimension]", new Object[0]);
        } else {
            LOGGER.info("Default Sub Dimension set to: [" + LodUtil.shortenString(((File)subDimFolder).getName(), 8) + "...]", new Object[0]);
        }
        return subDimFolder;
    }

    public File attemptToDetermineSubDimensionFolder() throws IOException {
        boolean newChunkHasData;
        if (this.firstSeenPlayerData == null) {
            this.firstSeenPlayerData = this.playerData;
            this.playerData = new PlayerData(MC);
        }
        AbstractChunkPosWrapper playerChunkPos = FACTORY.createChunkPos(this.playerData.playerBlockPos);
        int startingBlockPosX = playerChunkPos.getMinBlockX();
        int startingBlockPosZ = playerChunkPos.getMinBlockZ();
        RegionPos playerRegionPos = new RegionPos(playerChunkPos);
        IChunkWrapper newlyLoadedChunk = MC.getWrappedClientWorld().tryGetChunk(playerChunkPos);
        if (!this.CanDetermineDimensionFolder(newlyLoadedChunk)) {
            return null;
        }
        LodDimension newlyLoadedDim = new LodDimension(MC.getCurrentDimension(), 1, null, false);
        newlyLoadedDim.move(playerRegionPos);
        newlyLoadedDim.regions.set(playerRegionPos.x, playerRegionPos.z, new LodRegion(0, playerRegionPos, VERTICAL_QUALITY_TO_TEST_WITH));
        boolean lodGenerated = ApiShared.lodBuilder.generateLodNodeFromChunk(newlyLoadedDim, newlyLoadedChunk, new LodBuilderConfig(DistanceGenerationMode.FULL), true, true);
        if (!lodGenerated) {
            return null;
        }
        LOGGER.info("Attempting to determine sub-dimension for [" + MC.getCurrentDimension().getDimensionName() + "]", new Object[0]);
        LOGGER.info("Player block pos in dimension: [" + this.playerData.playerBlockPos.getX() + "," + this.playerData.playerBlockPos.getY() + "," + this.playerData.playerBlockPos.getZ() + "]", new Object[0]);
        long[][][] newChunkData = new long[16][16][];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                long[] array = newlyLoadedDim.getRegion(playerRegionPos.x, playerRegionPos.z).getAllData((byte)0, x + startingBlockPosX, z + startingBlockPosZ);
                newChunkData[x][z] = array;
            }
        }
        boolean bl = newChunkHasData = !LodDimensionFinder.isDataEmpty(newChunkData);
        if (!newChunkHasData) {
            if (newlyLoadedChunk.getHeight() != 0) {
                String message = "Error: the chunk at (" + playerChunkPos.getX() + "," + playerChunkPos.getZ() + ") has a height of [" + newlyLoadedChunk.getHeight() + "] but the LOD generated is empty!";
                LOGGER.error(message, new Object[0]);
            } else {
                String message = "Warning: The chunk at (" + playerChunkPos.getX() + "," + playerChunkPos.getZ() + ") is empty.";
                LOGGER.warn(message, new Object[0]);
            }
            return null;
        }
        File dimensionFolder = LodDimensionFinder.GetDimensionFolder(newlyLoadedDim.dimension, "");
        if (dimensionFolder.listFiles() == null && !dimensionFolder.exists()) {
            dimensionFolder.mkdirs();
        }
        this.moveOldSaveFoldersIfNecessary(dimensionFolder, MC.getCurrentDimension(), UUID.randomUUID().toString());
        SubDimCompare mostSimilarSubDim = null;
        LOGGER.info("Potential Sub Dimension folders: [" + dimensionFolder.listFiles(File::isDirectory).length + "]", new Object[0]);
        for (File testDimFolder : dimensionFolder.listFiles()) {
            if (!testDimFolder.isDirectory()) continue;
            LOGGER.info("Testing sub dimension: [" + LodUtil.shortenString(testDimFolder.getName(), 8) + "]", new Object[0]);
            try {
                LodDimension tempLodDim = new LodDimension(null, 1, null, false);
                tempLodDim.move(playerRegionPos);
                LodDimensionFileHandler tempFileHandler = new LodDimensionFileHandler(testDimFolder, tempLodDim);
                LodRegion testRegion = tempFileHandler.loadRegionFromFile((byte)0, playerRegionPos, VERTICAL_QUALITY_TO_TEST_WITH);
                long[][][] testChunkData = new long[16][16][];
                for (int x = 0; x < 16; ++x) {
                    for (int z = 0; z < 16; ++z) {
                        long[] array = testRegion.getAllData((byte)0, x + startingBlockPosX, z + startingBlockPosZ);
                        testChunkData[x][z] = array;
                    }
                }
                PlayerData testPlayerData = new PlayerData(testDimFolder);
                LOGGER.info("Last known player pos: [" + testPlayerData.playerBlockPos.getX() + "," + testPlayerData.playerBlockPos.getY() + "," + testPlayerData.playerBlockPos.getZ() + "]", new Object[0]);
                int playerBlockDist = testPlayerData.playerBlockPos.getManhattanDistance(this.playerData.playerBlockPos);
                ApiShared.LOGGER.info("Player block position distance between saved sub dimension and first seen is [" + playerBlockDist + "]");
                if (LodDimensionFinder.isDataEmpty(testChunkData)) {
                    String message = "The test chunk for dimension folder [" + LodUtil.shortenString(testDimFolder.getName(), 8) + "] and chunk pos (" + playerChunkPos.getX() + "," + playerChunkPos.getZ() + ") is empty. This is expected if the position is outside the sub-dimension's generated area.";
                    LOGGER.info(message, new Object[0]);
                    continue;
                }
                int equalDataPoints = 0;
                int totalDataPointCount = 0;
                for (int x = 0; x < 16; ++x) {
                    block8: for (int z = 0; z < 16; ++z) {
                        for (int y = 0; y < newChunkData[x][z].length; ++y) {
                            if (newChunkData[x][z][y] == testChunkData[x][z][y]) {
                                ++equalDataPoints;
                            }
                            ++totalDataPointCount;
                            if (!DataPointUtil.doesItExist(newChunkData[x][z][y]) || !DataPointUtil.doesItExist(testChunkData[x][z][y])) continue block8;
                        }
                    }
                }
                SubDimCompare subDimCompare = new SubDimCompare(equalDataPoints, totalDataPointCount, playerBlockDist, testDimFolder);
                if (mostSimilarSubDim == null || subDimCompare.compareTo(mostSimilarSubDim) > 0) {
                    mostSimilarSubDim = subDimCompare;
                }
                LOGGER.info("Sub dimension [" + LodUtil.shortenString(testDimFolder.getName(), 8) + "...] is current dimension probability: " + LodUtil.shortenString(subDimCompare.getPercentEqual() + "", 5) + " (" + equalDataPoints + "/" + totalDataPointCount + ")", new Object[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.firstSeenPlayerData = null;
        if (mostSimilarSubDim != null && mostSimilarSubDim.isValidSubDim()) {
            LOGGER.info("Sub Dimension set to: [" + LodUtil.shortenString(mostSimilarSubDim.folder.getName(), 8) + "...] with an equality of [" + mostSimilarSubDim.getPercentEqual() + "]", new Object[0]);
            return mostSimilarSubDim.folder;
        }
        double highestEqualityPercent = mostSimilarSubDim != null ? mostSimilarSubDim.getPercentEqual() : 0.0;
        String newId = UUID.randomUUID().toString();
        String message = "No suitable sub dimension found. The highest equality was [" + LodUtil.shortenString(highestEqualityPercent + "", 5) + "]. Creating a new sub dimension with ID: " + LodUtil.shortenString(newId, 8) + "...";
        LOGGER.info(message, new Object[0]);
        return LodDimensionFinder.GetDimensionFolder(newlyLoadedDim.dimension, newId);
    }

    public static File GetDimensionFolder(IDimensionTypeWrapper newDimensionType, String worldId) {
        if (worldId == null) {
            worldId = "";
        }
        worldId = worldId.replaceAll("[\\\\/:*?\"<>|]", "");
        try {
            if (MC.hasSinglePlayerServer()) {
                IWorldWrapper serverWorld = LodUtil.getServerWorldFromDimension(newDimensionType);
                return new File(serverWorld.getSaveFolder().getCanonicalFile().getPath() + File.separatorChar + "lod" + File.separatorChar + worldId);
            }
            return new File(MC.getGameDirectory().getCanonicalFile().getPath() + File.separatorChar + "Distant_Horizons_server_data" + File.separatorChar + MC.getCurrentDimensionId() + File.separatorChar + worldId);
        }
        catch (IOException e) {
            LOGGER.error("Unable to get dimension folder for dimension [" + newDimensionType.getDimensionName() + "]", e);
            return null;
        }
    }

    public boolean CanDetermineDimensionFolder(IChunkWrapper chunk) {
        return LodBuilder.canGenerateLodFromChunk(chunk);
    }

    private static boolean isDataEmpty(long[][][] chunkData) {
        long[][][] lArray = chunkData;
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            long[][] xArray;
            long[][] lArray2 = xArray = lArray[i];
            int n2 = lArray2.length;
            for (int j = 0; j < n2; ++j) {
                long[] zArray;
                for (long dataPoint : zArray = lArray2[j]) {
                    if (dataPoint == 0L) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public static boolean isValidSubDimensionDirectory(File potentialFolder) {
        if (!potentialFolder.isDirectory()) {
            return false;
        }
        if (potentialFolder.listFiles() == null) {
            return false;
        }
        for (File internalFolder : potentialFolder.listFiles()) {
            if (VerticalQuality.getByName(internalFolder.getName()) == null) continue;
            return true;
        }
        return false;
    }

    private void moveOldSaveFoldersIfNecessary(File dimensionFolder, IDimensionTypeWrapper dimensionType, String subDimensionName) throws IOException {
        if (dimensionFolder.listFiles() == null) {
            return;
        }
        for (File folder : dimensionFolder.listFiles()) {
            if (VerticalQuality.getByName(folder.getName()) == null) continue;
            File newDimension = LodDimensionFinder.GetDimensionFolder(dimensionType, subDimensionName);
            newDimension.mkdirs();
            File oldDataNewPath = new File(newDimension.getPath() + File.separatorChar + folder.getName());
            Files.move(folder.toPath(), oldDataNewPath.toPath(), new CopyOption[0]);
        }
    }

    public void updatePlayerData() {
        this.playerData.updateData(MC);
    }

    public void saveDimensionPlayerData(File worldFolder) {
        File file = PlayerData.getFileForDimensionFolder(worldFolder);
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
            }
            catch (IOException e) {
                LOGGER.error("Unable to save player dimension data for world folder [" + worldFolder.getPath() + "].", e);
                return;
            }
        }
        IMinecraftClientWrapper mc = SingletonHandler.get(IMinecraftClientWrapper.class);
        PlayerData playerdata = new PlayerData(mc);
        CommentedFileConfig toml = (CommentedFileConfig)CommentedFileConfig.builder(file).build();
        playerdata.toTomlFile(toml);
    }
}

