/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.handlers.dimensionFinder;

import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.lod.core.wrapperInterfaces.block.AbstractBlockPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import java.io.File;
import shaded.electronwill.nightconfig.core.file.CommentedFileConfig;

public class PlayerData {
    public static final IWrapperFactory FACTORY = SingletonHandler.get(IWrapperFactory.class);
    private static final String playerDataFileName = "_playerData.toml";
    public static final String PLAYER_BLOCK_POS_X_PATH = "playerBlockPosX";
    public static final String PLAYER_BLOCK_POS_Y_PATH = "playerBlockPosY";
    public static final String PLAYER_BLOCK_POS_Z_PATH = "playerBlockPosZ";
    public AbstractBlockPosWrapper playerBlockPos;
    public static final String WORLD_SPAWN_POS_X_PATH = "worldSpawnBlockPosX";
    public static final String WORLD_SPAWN_POS_Y_PATH = "worldSpawnBlockPosY";
    public static final String WORLD_SPAWN_POS_Z_PATH = "worldSpawnBlockPosZ";
    public AbstractBlockPosWrapper worldSpawnPointBlockPos;

    public PlayerData(IMinecraftClientWrapper mc) {
        this.updateData(mc);
    }

    public PlayerData(File dimensionFolder) {
        File file = PlayerData.getFileForDimensionFolder(dimensionFolder);
        CommentedFileConfig toml = (CommentedFileConfig)CommentedFileConfig.builder(file).build();
        toml.load();
        if (toml.contains(PLAYER_BLOCK_POS_X_PATH) && toml.contains(PLAYER_BLOCK_POS_Y_PATH) && toml.contains(PLAYER_BLOCK_POS_Z_PATH)) {
            int x = toml.getIntOrElse(PLAYER_BLOCK_POS_X_PATH, 0);
            int y = toml.getIntOrElse(PLAYER_BLOCK_POS_Y_PATH, 0);
            int z = toml.getIntOrElse(PLAYER_BLOCK_POS_Z_PATH, 0);
            this.playerBlockPos = FACTORY.createBlockPos(x, y, z);
        } else {
            this.playerBlockPos = FACTORY.createBlockPos(0, 0, 0);
        }
    }

    public static File getFileForDimensionFolder(File file) {
        return new File(file.getPath() + File.separatorChar + playerDataFileName);
    }

    public void updateData(IMinecraftClientWrapper mc) {
        if (mc.playerExists()) {
            this.playerBlockPos = mc.getPlayerBlockPos();
        }
    }

    public void toTomlFile(CommentedFileConfig toml) {
        toml.add(PLAYER_BLOCK_POS_X_PATH, (Object)this.playerBlockPos.getX());
        toml.add(PLAYER_BLOCK_POS_Y_PATH, (Object)this.playerBlockPos.getY());
        toml.add(PLAYER_BLOCK_POS_Z_PATH, (Object)this.playerBlockPos.getZ());
        toml.save();
    }

    public String toString() {
        return "PlayerBlockPos: [" + this.playerBlockPos.getX() + "," + this.playerBlockPos.getY() + "," + this.playerBlockPos.getZ() + "]";
    }
}

