/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.handlers.dimensionFinder;

import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class SubDimCompare
implements Comparable<SubDimCompare> {
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    public int equalDataPoints = 0;
    public int totalDataPoints = 0;
    public int playerPosDist = 0;
    public File folder = null;

    public SubDimCompare(int newEqualDataPoints, int newTotalDataPoints, int newPlayerPosDistance, File newSubDimFolder) {
        this.equalDataPoints = newEqualDataPoints;
        this.totalDataPoints = newTotalDataPoints;
        this.playerPosDist = newPlayerPosDistance;
        this.folder = newSubDimFolder;
    }

    public double getPercentEqual() {
        return (double)this.equalDataPoints / (double)this.totalDataPoints;
    }

    @Override
    public int compareTo(@NotNull SubDimCompare other) {
        if (this.equalDataPoints != other.equalDataPoints) {
            return Integer.compare(this.equalDataPoints, other.equalDataPoints);
        }
        return Integer.compare(this.playerPosDist, other.playerPosDist);
    }

    public boolean isValidSubDim() {
        double minimumSimilarityRequired = CONFIG.client().multiplayer().getMultiDimensionRequiredSimilarity();
        return this.getPercentEqual() >= minimumSimilarityRequired || this.playerPosDist <= 3;
    }
}

