/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.objects.lod;

import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.lod.core.wrapperInterfaces.block.AbstractBlockPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.chunk.AbstractChunkPosWrapper;

public class RegionPos {
    private static final IWrapperFactory WRAPPER_FACTORY = SingletonHandler.get(IWrapperFactory.class);
    public int x;
    public int z;

    public RegionPos() {
        this.x = 0;
        this.z = 0;
    }

    public RegionPos(int newX, int newZ) {
        this.x = newX;
        this.z = newZ;
    }

    public RegionPos(AbstractBlockPosWrapper pos) {
        this(WRAPPER_FACTORY.createChunkPos(pos));
    }

    public RegionPos(AbstractChunkPosWrapper pos) {
        this.x = Math.floorDiv(pos.getX(), 32);
        this.z = Math.floorDiv(pos.getZ(), 32);
    }

    public AbstractChunkPosWrapper chunkPos() {
        return WRAPPER_FACTORY.createChunkPos(this.x * 32 + 16, this.z * 32 + 16);
    }

    public AbstractBlockPosWrapper blockPos() {
        return this.chunkPos().getWorldPosition().offset(8, 0, 8);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegionPos)) {
            return false;
        }
        RegionPos c = (RegionPos)o;
        return c.x == this.x && c.z == this.z;
    }

    public String toString() {
        return "(" + this.x + "," + this.z + ")";
    }

    public static long asLong(int i, int j) {
        return (long)i & 0xFFFFFFFFL | ((long)j & 0xFFFFFFFFL) << 32;
    }

    public static int getX(long l) {
        return (int)(l & 0xFFFFFFFFL);
    }

    public static int getZ(long l) {
        return (int)(l >>> 32 & 0xFFFFFFFFL);
    }

    public int hashCode() {
        return Long.hashCode(RegionPos.asLong(this.x, this.z));
    }
}

