/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.objects.math;

import com.seibel.lod.core.util.LodUtil;

public class Vec3f {
    public static Vec3f XNeg = new Vec3f(-1.0f, 0.0f, 0.0f);
    public static Vec3f XPos = new Vec3f(1.0f, 0.0f, 0.0f);
    public static Vec3f YNeg = new Vec3f(0.0f, -1.0f, 0.0f);
    public static Vec3f YPos = new Vec3f(0.0f, 1.0f, 0.0f);
    public static Vec3f ZNeg = new Vec3f(0.0f, 0.0f, -1.0f);
    public static Vec3f ZPos = new Vec3f(0.0f, 0.0f, 1.0f);
    public float x;
    public float y;
    public float z;

    public Vec3f() {
    }

    public Vec3f(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj != null && this.getClass() == obj.getClass()) {
            Vec3f Vec3f2 = (Vec3f)obj;
            if (Float.compare(Vec3f2.x, this.x) != 0) {
                return false;
            }
            if (Float.compare(Vec3f2.y, this.y) != 0) {
                return false;
            }
            return Float.compare(Vec3f2.z, this.z) == 0;
        }
        return false;
    }

    public int hashCode() {
        int i = Float.floatToIntBits(this.x);
        i = 31 * i + Float.floatToIntBits(this.y);
        return 31 * i + Float.floatToIntBits(this.z);
    }

    public void mul(float scalar) {
        this.x *= scalar;
        this.y *= scalar;
        this.z *= scalar;
    }

    public void mul(float x, float y, float z) {
        this.x *= x;
        this.y *= y;
        this.z *= z;
    }

    public void clamp(float min, float max) {
        this.x = LodUtil.clamp(min, this.x, max);
        this.y = LodUtil.clamp(min, this.y, max);
        this.z = LodUtil.clamp(min, this.z, max);
    }

    public void set(float x, float y, float z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void add(float x, float y, float z) {
        this.x += x;
        this.y += y;
        this.z += z;
    }

    public void add(Vec3f vector) {
        this.x += vector.x;
        this.y += vector.y;
        this.z += vector.z;
    }

    public void subtract(Vec3f vector) {
        this.x -= vector.x;
        this.y -= vector.y;
        this.z -= vector.z;
    }

    public float dotProduct(Vec3f vector) {
        return this.x * vector.x + this.y * vector.y + this.z * vector.z;
    }

    public boolean normalize() {
        float squaredSum = this.x * this.x + this.y * this.y + this.z * this.z;
        if ((double)squaredSum < 1.0E-5) {
            return false;
        }
        float f1 = LodUtil.fastInvSqrt(squaredSum);
        this.x *= f1;
        this.y *= f1;
        this.z *= f1;
        return true;
    }

    public void crossProduct(Vec3f vector) {
        float f = this.x;
        float f1 = this.y;
        float f2 = this.z;
        float f3 = vector.x;
        float f4 = vector.y;
        float f5 = vector.z;
        this.x = f1 * f5 - f2 * f4;
        this.y = f2 * f3 - f * f5;
        this.z = f * f4 - f1 * f3;
    }

    public Vec3f copy() {
        return new Vec3f(this.x, this.y, this.z);
    }

    public String toString() {
        return "[" + this.x + ", " + this.y + ", " + this.z + "]";
    }

    public Vec3f(float[] values) {
        this.set(values);
    }

    public void set(float[] values) {
        this.x = values[0];
        this.y = values[1];
        this.z = values[2];
    }
}

