/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.render;

import com.seibel.lod.core.enums.rendering.FogDistance;
import com.seibel.lod.core.enums.rendering.FogDrawMode;
import com.seibel.lod.core.enums.rendering.FogSetting;
import com.seibel.lod.core.enums.rendering.HeightFogMixMode;
import com.seibel.lod.core.enums.rendering.HeightFogMode;
import com.seibel.lod.core.handlers.IReflectionHandler;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.render.objects.Shader;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import java.util.Objects;

public class LodFogConfig {
    private static final IReflectionHandler REFLECTION_HANDLER = SingletonHandler.get(IReflectionHandler.class);
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    public static final boolean DEBUG_DUMP_GENERATED_CODE = false;
    public final FogSetting farFogSetting;
    public final FogSetting heightFogSetting;
    public final HeightFogMixMode heightFogMixMode;
    public final HeightFogMode heightFogMode;
    public final float heightFogHeight;
    final boolean drawNearFog;
    final int earthCurveRatio = CONFIG.client().graphics().advancedGraphics().getEarthCurveRatio();

    public static LodFogConfig generateFogConfig() {
        FogDrawMode fogMode = CONFIG.client().graphics().fogQuality().getFogDrawMode();
        if (fogMode == FogDrawMode.USE_OPTIFINE_SETTING) {
            fogMode = REFLECTION_HANDLER.getFogDrawMode();
        }
        return new LodFogConfig(fogMode);
    }

    private LodFogConfig(FogDrawMode fogDrawMode) {
        if (fogDrawMode != FogDrawMode.FOG_DISABLED) {
            ILodConfigWrapperSingleton.IClient.IGraphics.IFogQuality fogSettings = CONFIG.client().graphics().fogQuality();
            FogDistance fogDistance = fogSettings.getFogDistance();
            boolean bl = this.drawNearFog = fogDistance == FogDistance.NEAR || fogDistance == FogDistance.NEAR_AND_FAR;
            if (fogDistance == FogDistance.FAR || fogDistance == FogDistance.NEAR_AND_FAR) {
                this.farFogSetting = fogSettings.advancedFog().computeFarFogSetting();
                this.heightFogMixMode = fogSettings.advancedFog().heightFog().getHeightFogMixMode();
                if (this.heightFogMixMode == HeightFogMixMode.IGNORE_HEIGHT || this.heightFogMixMode == HeightFogMixMode.BASIC) {
                    this.heightFogSetting = null;
                    this.heightFogMode = null;
                    this.heightFogHeight = 0.0f;
                } else {
                    this.heightFogSetting = fogSettings.advancedFog().heightFog().computeHeightFogSetting();
                    this.heightFogMode = fogSettings.advancedFog().heightFog().getHeightFogMode();
                    this.heightFogHeight = this.heightFogMode.basedOnCamera ? 0.0f : (float)fogSettings.advancedFog().heightFog().getHeightFogHeight();
                }
            } else {
                this.farFogSetting = null;
                this.heightFogSetting = null;
                this.heightFogMode = null;
                this.heightFogMixMode = null;
                this.heightFogHeight = 0.0f;
            }
        } else {
            this.drawNearFog = false;
            this.farFogSetting = null;
            this.heightFogMixMode = null;
            this.heightFogMode = null;
            this.heightFogSetting = null;
            this.heightFogHeight = 0.0f;
        }
    }

    public StringBuilder loadAndProcessFragShader(String path, boolean absoluteFilePath) {
        StringBuilder str = this.makeRuntimeDefine();
        this.generateRuntimeShaderCode(Shader.loadFile(path, absoluteFilePath, str));
        return str;
    }

    private void generateRuntimeShaderCode(StringBuilder str) {
        str.append("// =======RUNTIME GENERATED CODE SECTION======== //\n");
        str.append("float getNearFogThickness(float dist) \n{ \n\treturn linearFog(dist, nearFogStart, nearFogLength, 0.0, 1.0); \n} \n");
        if (this.farFogSetting == null) {
            str.append("\nfloat getFarFogThickness(float dist) { return 0.0; } \nfloat getHeightFogThickness(float dist) { return 0.0; } \nfloat calculateFarFogDepth(float horizontal, float dist, float nearFogStart) { return 0.0; } \nfloat calculateHeightFogDepth(float vertical, float realY) { return 0.0; } \nfloat mixFogThickness(float near, float far, float height) \n{ \n" + (this.drawNearFog ? "return 1.0-near;" : "return 0.0;") + "} \n\n");
        } else {
            str.append("float getFarFogThickness(float dist) \n{ \n" + LodFogConfig.getFarFogMethod(this.farFogSetting.fogType) + "\n} \n");
            str.append("float getHeightFogThickness(float dist) \n{ \n" + (this.heightFogSetting != null ? LodFogConfig.getHeightFogMethod(this.heightFogSetting.fogType) : "\treturn 0.0;") + "\n} \n");
            str.append("float calculateHeightFogDepth(float vertical, float realY) \n{ \n" + (this.heightFogSetting != null ? LodFogConfig.getHeightDepthMethod(this.heightFogMode, this.heightFogHeight) : "\treturn 0.0;") + "\n} \n");
            str.append("float calculateFarFogDepth(float horizontal, float dist, float nearFogStart) \n{ \n\treturn " + (this.heightFogMixMode == HeightFogMixMode.BASIC ? "(dist - nearFogStart)/(1.0 - nearFogStart);" : "(horizontal - nearFogStart)/(1.0 - nearFogStart);") + "} \n");
            str.append("float mixFogThickness(float near, float far, float height) \n{ \n" + LodFogConfig.getMixFogLine(this.heightFogMixMode, this.drawNearFog) + "\n} \n");
        }
    }

    private StringBuilder makeRuntimeDefine() {
        StringBuilder str = new StringBuilder();
        str.append("// =======RUNTIME GENERATED DEFINE SECTION======== //\n");
        str.append("#version 150 core\n");
        FogSetting activeFarFogSetting = this.farFogSetting != null ? this.farFogSetting : FogSetting.EMPTY;
        FogSetting activeHeightFogSetting = this.heightFogSetting != null ? this.heightFogSetting : FogSetting.EMPTY;
        str.append("\n#define farFogStart " + activeFarFogSetting.start + "\n#define farFogLength " + (activeFarFogSetting.end - activeFarFogSetting.start) + "\n#define farFogMin " + activeFarFogSetting.min + "\n#define farFogRange " + (activeFarFogSetting.max - activeFarFogSetting.min) + "\n#define farFogDensity " + activeFarFogSetting.density + "\n\n#define heightFogStart " + activeHeightFogSetting.start + "\n#define heightFogLength " + (activeHeightFogSetting.end - activeHeightFogSetting.start) + "\n#define heightFogMin " + activeHeightFogSetting.min + "\n#define heightFogRange " + (activeHeightFogSetting.max - activeHeightFogSetting.min) + "\n#define heightFogDensity " + activeHeightFogSetting.density + "\n\n");
        str.append("// =======RUNTIME END======== //\n");
        return str;
    }

    private static String getFarFogMethod(FogSetting.FogType fogType) {
        switch (fogType) {
            case LINEAR: {
                return "return linearFog(dist, farFogStart, farFogLength, farFogMin, farFogRange);\n";
            }
            case EXPONENTIAL: {
                return "return exponentialFog(dist, farFogStart, farFogLength, farFogMin, farFogRange, farFogDensity);\n";
            }
            case EXPONENTIAL_SQUARED: {
                return "return exponentialSquaredFog(dist, farFogStart, farFogLength, farFogMin, farFogRange, farFogDensity);\n";
            }
        }
        throw new IllegalArgumentException("FogType [" + (Object)((Object)fogType) + "] not implemented for [getFarFogMethod].");
    }

    private static String getHeightDepthMethod(HeightFogMode heightMode, float heightFogHeight) {
        String str = "";
        if (!heightMode.basedOnCamera) {
            str = "\tvertical = realY - (" + heightFogHeight + ");\n";
        }
        str = heightMode.below && heightMode.above ? str + "\treturn abs(vertical);\n" : (heightMode.below ? str + "\treturn -vertical;\n" : (heightMode.above ? str + "\treturn vertical;\n" : str + "\treturn 0;\n"));
        return str;
    }

    private static String getHeightFogMethod(FogSetting.FogType fogType) {
        switch (fogType) {
            case LINEAR: {
                return "\treturn linearFog(dist, heightFogStart, heightFogLength, heightFogMin, heightFogRange);\n";
            }
            case EXPONENTIAL: {
                return "\treturn exponentialFog(dist, heightFogStart, heightFogLength, heightFogMin, heightFogRange, heightFogDensity);\n";
            }
            case EXPONENTIAL_SQUARED: {
                return "\treturn exponentialSquaredFog(dist, heightFogStart, heightFogLength, heightFogMin, heightFogRange, heightFogDensity);\n";
            }
        }
        throw new IllegalArgumentException("FogType [" + (Object)((Object)fogType) + "] not implemented for [getHeightFogMethod].");
    }

    private static String getMixFogLine(HeightFogMixMode heightFogMode, boolean drawNearFog) {
        String str = "\treturn ";
        switch (heightFogMode) {
            case BASIC: 
            case IGNORE_HEIGHT: {
                if (drawNearFog) {
                    str = str + "max(1.0-near, far);\n";
                    break;
                }
                str = str + "near * far;\n";
                break;
            }
            case ADDITION: {
                if (drawNearFog) {
                    str = str + "max(1.0-near, far + height);\n";
                    break;
                }
                str = str + "near * (far + height);\n";
                break;
            }
            case MAX: {
                if (drawNearFog) {
                    str = str + "max(1.0-near, max(far, height));\n";
                    break;
                }
                str = str + "near * max(far, height);\n";
                break;
            }
            case INVERSE_MULTIPLY: {
                if (drawNearFog) {
                    str = str + "max(1.0-near, 1.0 - (1.0-far)*(1.0-height));\n";
                    break;
                }
                str = str + "near * (1.0 - (1.0-far)*(1.0-height));\n";
                break;
            }
            case MULTIPLY: {
                if (drawNearFog) {
                    str = str + "max(1.0-near, far*height);\n";
                    break;
                }
                str = str + "near * far * height;\n";
                break;
            }
            case LIMITED_ADDITION: {
                if (drawNearFog) {
                    str = str + "max(1.0-near, far + max(far, height));\n";
                    break;
                }
                str = str + "near * (far + max(far, height));\n";
                break;
            }
            case MULTIPLY_ADDITION: {
                if (drawNearFog) {
                    str = str + "max(1.0-near, far + far*height);\n";
                    break;
                }
                str = str + "near * (far + far*height);\n";
                break;
            }
            case INVERSE_MULTIPLY_ADDITION: {
                if (drawNearFog) {
                    str = str + "max(1.0-near, far + 1.0 - (1.0-far)*(1.0-height));\n";
                    break;
                }
                str = str + "near * (far + 1.0 - (1.0-far)*(1.0-height));\n";
                break;
            }
            case AVERAGE: {
                if (drawNearFog) {
                    str = str + "max(1.0-near, far*0.5 + height*0.5);\n";
                    break;
                }
                str = str + "near * (far*0.5 + height*0.5);\n";
                break;
            }
            default: {
                throw new IllegalArgumentException("FogType [" + (Object)((Object)heightFogMode) + "] not implemented for [getMixFogMethod].");
            }
        }
        return str;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LodFogConfig that = (LodFogConfig)o;
        return Float.compare(that.heightFogHeight, this.heightFogHeight) == 0 && this.drawNearFog == that.drawNearFog && Objects.equals(this.farFogSetting, that.farFogSetting) && Objects.equals(this.heightFogSetting, that.heightFogSetting) && this.heightFogMixMode == that.heightFogMixMode && this.heightFogMode == that.heightFogMode && this.earthCurveRatio == that.earthCurveRatio;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.farFogSetting, this.heightFogSetting, this.heightFogMixMode, this.heightFogMode, Float.valueOf(this.heightFogHeight), this.drawNearFog, this.earthCurveRatio});
    }
}

