/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.render;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.builders.lodBuilding.bufferBuilding.LodBufferBuilderFactory;
import com.seibel.lod.core.enums.rendering.DebugMode;
import com.seibel.lod.core.enums.rendering.FogColorMode;
import com.seibel.lod.core.enums.rendering.FogDistance;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.logging.ConfigBasedLogger;
import com.seibel.lod.core.logging.ConfigBasedSpamLogger;
import com.seibel.lod.core.objects.BoolType;
import com.seibel.lod.core.objects.Pos2D;
import com.seibel.lod.core.objects.lod.LodDimension;
import com.seibel.lod.core.objects.math.Mat4f;
import com.seibel.lod.core.objects.math.Vec3d;
import com.seibel.lod.core.objects.math.Vec3f;
import com.seibel.lod.core.objects.opengl.RenderRegion;
import com.seibel.lod.core.render.GLProxy;
import com.seibel.lod.core.render.LodFogConfig;
import com.seibel.lod.core.render.LodRenderProgram;
import com.seibel.lod.core.render.objects.GLState;
import com.seibel.lod.core.render.objects.QuadElementBuffer;
import com.seibel.lod.core.util.DetailDistanceUtil;
import com.seibel.lod.core.util.LodUtil;
import com.seibel.lod.core.util.gridList.EdgeDistanceBooleanGrid;
import com.seibel.lod.core.util.gridList.MovableGridRingList;
import com.seibel.lod.core.util.gridList.PosArrayGridList;
import com.seibel.lod.core.wrapperInterfaces.block.AbstractBlockPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IProfilerWrapper;
import com.seibel.lod.core.wrapperInterfaces.misc.ILightMapWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IWorldWrapper;
import java.awt.Color;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.lwjgl.opengl.GL32;

public class LodRenderer {
    private static final ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
    public static final ConfigBasedLogger EVENT_LOGGER = new ConfigBasedLogger(LogManager.getLogger(LodRenderer.class), () -> CONFIG.client().advanced().debugging().debugSwitch().getLogRendererBufferEvent());
    public static ConfigBasedSpamLogger tickLogger = new ConfigBasedSpamLogger(LogManager.getLogger(LodRenderer.class), () -> CONFIG.client().advanced().debugging().debugSwitch().getLogRendererBufferEvent(), 1);
    public static final boolean ENABLE_DRAW_LAG_SPIKE_LOGGING = false;
    public static final boolean ENABLE_DUMP_GL_STATE = true;
    public static final long DRAW_LAG_SPIKE_THRESHOLD_NS = TimeUnit.NANOSECONDS.convert(20L, TimeUnit.MILLISECONDS);
    public static final boolean ENABLE_IBO = true;
    private static final IMinecraftClientWrapper MC = SingletonHandler.get(IMinecraftClientWrapper.class);
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonHandler.get(IMinecraftRenderWrapper.class);
    public DebugMode previousDebugMode = DebugMode.OFF;
    private boolean isSetupComplete = false;
    private final LodBufferBuilderFactory lodBufferBuilderFactory;
    LodRenderProgram shaderProgram = null;
    private AbstractBlockPosWrapper lastUpdatedPos = null;
    public QuadElementBuffer quadIBO = null;
    private int prevRenderDistance = 0;
    private long prevPlayerPosTime = 0L;
    private long prevVanillaChunkTime = 0L;
    private long prevChunkTime = 0L;
    private FogDistance prevFogDistance = FogDistance.NEAR_AND_FAR;
    private volatile boolean partialRegen = false;
    private volatile boolean fullRegen = true;
    private volatile boolean markToCleanup = false;
    public PosArrayGridList<BoolType> vanillaChunks = null;
    private boolean canVanillaFogBeDisabled = true;

    public void requestCleanup() {
        this.markToCleanup = true;
    }

    public LodRenderer(LodBufferBuilderFactory newLodNodeBufferBuilder) {
        this.lodBufferBuilderFactory = newLodNodeBufferBuilder;
    }

    public void drawLODs(LodDimension lodDim, Mat4f baseModelViewMatrix, Mat4f baseProjectionMatrix, float partialTicks, IProfilerWrapper profiler) {
        if (lodDim == null) {
            return;
        }
        if (MC_RENDER.playerHasBlindnessEffect()) {
            return;
        }
        if (MC_RENDER.getLightmapWrapper() == null) {
            return;
        }
        LagSpikeCatcher drawSaveGLState = new LagSpikeCatcher();
        GLState currentState = new GLState();
        tickLogger.debug("Saving GL state: {}", currentState);
        drawSaveGLState.end("drawSaveGLState");
        GLProxy glProxy = GLProxy.getInstance();
        if (this.canVanillaFogBeDisabled && CONFIG.client().graphics().fogQuality().getDisableVanillaFog() && !MC_RENDER.tryDisableVanillaFog()) {
            this.canVanillaFogBeDisabled = false;
        }
        LagSpikeCatcher updateStatus = new LagSpikeCatcher();
        this.updateRegenStatus(lodDim, partialTicks);
        updateStatus.end("LodDrawSetup:UpdateStatus");
        if (this.markToCleanup) {
            LagSpikeCatcher drawObjectClenup = new LagSpikeCatcher();
            this.markToCleanup = false;
            this.cleanup();
            drawObjectClenup.end("drawObjectClenup");
        }
        LagSpikeCatcher swapBuffer = new LagSpikeCatcher();
        if ((this.partialRegen || this.fullRegen) && this.lodBufferBuilderFactory.updateAndSwapLodBuffersAsync(this, lodDim, MC.getPlayerBlockPos().getX(), MC.getPlayerBlockPos().getY(), MC.getPlayerBlockPos().getZ(), this.fullRegen)) {
            this.fullRegen = false;
            this.partialRegen = false;
        }
        swapBuffer.end("SwapBuffer");
        MovableGridRingList<RenderRegion> regions = this.lodBufferBuilderFactory.getRenderRegions();
        if (regions == null) {
            return;
        }
        profiler.push("LOD draw setup");
        LagSpikeCatcher drawSetup = new LagSpikeCatcher();
        LagSpikeCatcher drawGLSetup = new LagSpikeCatcher();
        LagSpikeCatcher drawBindBuff = new LagSpikeCatcher();
        GL32.glViewport((int)0, (int)0, (int)MC_RENDER.getTargetFrameBufferViewportWidth(), (int)MC_RENDER.getTargetFrameBufferViewportHeight());
        GL32.glBindBuffer((int)34962, (int)0);
        drawBindBuff.end("drawBindBuff");
        LagSpikeCatcher drawSetPolygon = new LagSpikeCatcher();
        if (CONFIG.client().advanced().debugging().getDebugMode() == DebugMode.SHOW_DETAIL_WIREFRAME || CONFIG.client().advanced().debugging().getDebugMode() == DebugMode.SHOW_GENMODE_WIREFRAME || CONFIG.client().advanced().debugging().getDebugMode() == DebugMode.SHOW_WIREFRAME || CONFIG.client().advanced().debugging().getDebugMode() == DebugMode.SHOW_OVERLAPPING_QUADS_WIREFRAME) {
            GL32.glPolygonMode((int)1032, (int)6913);
        } else {
            GL32.glPolygonMode((int)1032, (int)6914);
            GL32.glEnable((int)2884);
        }
        drawSetPolygon.end("drawSetPolygon");
        LagSpikeCatcher drawEnableDepth = new LagSpikeCatcher();
        GL32.glEnable((int)2929);
        GL32.glDepthFunc((int)513);
        drawEnableDepth.end("drawEnableDepth");
        drawGLSetup.end("drawGLSetup");
        GL32.glDisable((int)3042);
        GL32.glClear((int)256);
        if (!this.isSetupComplete) {
            LagSpikeCatcher drawObjectSetup = new LagSpikeCatcher();
            this.setup();
            drawObjectSetup.end("drawObjectSetup");
        } else {
            LagSpikeCatcher drawShaderBind = new LagSpikeCatcher();
            LodFogConfig newConfig = this.shaderProgram.isShaderUsable();
            if (newConfig != null) {
                this.shaderProgram.free();
                this.shaderProgram = new LodRenderProgram(newConfig);
            }
            this.shaderProgram.bind();
            drawShaderBind.end("drawShaderBind");
        }
        LagSpikeCatcher drawSetActiveTexture = new LagSpikeCatcher();
        GL32.glActiveTexture((int)33984);
        drawSetActiveTexture.end("drawSetActiveTexture");
        LagSpikeCatcher drawCalculateParams = new LagSpikeCatcher();
        int vanillaBlockRenderedDistance = MC_RENDER.getRenderDistance() * 16;
        int farPlaneBlockDistance = MC.getWrappedClientWorld().getDimensionType().hasCeiling() ? Math.min(CONFIG.client().graphics().quality().getLodChunkRenderDistance(), 64) * 16 : CONFIG.client().graphics().quality().getLodChunkRenderDistance() * 16;
        drawCalculateParams.end("drawCalculateParams");
        Mat4f combinedMatrix = LodRenderer.createCombinedMatrix(baseProjectionMatrix, baseModelViewMatrix, vanillaBlockRenderedDistance, farPlaneBlockDistance, partialTicks);
        LagSpikeCatcher drawFillData = new LagSpikeCatcher();
        this.shaderProgram.fillUniformData(combinedMatrix, MC_RENDER.isFogStateSpecial() ? this.getSpecialFogColor(partialTicks) : this.getFogColor(partialTicks), 0, MC.getWrappedClientWorld().getHeight(), MC.getWrappedClientWorld().getMinHeight(), farPlaneBlockDistance, vanillaBlockRenderedDistance, MC_RENDER.isFogStateSpecial());
        LagSpikeCatcher drawFillLightmap = new LagSpikeCatcher();
        ILightMapWrapper lightmap = MC_RENDER.getLightmapWrapper();
        lightmap.bind();
        this.quadIBO.bind();
        drawFillLightmap.end("drawFillLightmap");
        drawFillData.end("DrawFillData");
        drawSetup.end("LodDrawSetup");
        profiler.popPush("LOD draw");
        LagSpikeCatcher draw = new LagSpikeCatcher();
        boolean cullingDisabled = CONFIG.client().graphics().advancedGraphics().getDisableDirectionalCulling();
        Vec3d cameraPos = MC_RENDER.getCameraExactPosition();
        AbstractBlockPosWrapper cameraBlockPos = MC_RENDER.getCameraBlockPosition();
        Vec3f cameraDir = MC_RENDER.getLookAtVector();
        int drawCount = 0;
        int dx = 0;
        int oy = 0;
        int ox = 0;
        int dy = -1;
        int len = regions.getSize();
        int maxI = len * len;
        int halfLen = len / 2;
        for (int i = 0; i < maxI; ++i) {
            if (-halfLen <= ox && ox <= halfLen && -halfLen <= oy && oy <= halfLen) {
                Pos2D pos = regions.getCenter();
                int regionX = ox + pos.x;
                int regionZ = oy + pos.y;
                RenderRegion region = regions.get(regionX, regionZ);
                if (region == null) continue;
                if (region.render(lodDim, cameraPos, cameraBlockPos, cameraDir, !cullingDisabled, this.shaderProgram)) {
                    ++drawCount;
                }
            }
            if (ox == oy || ox < 0 && ox == -oy || ox > 0 && ox == 1 - oy) {
                int temp = dx;
                dx = -dy;
                dy = temp;
            }
            ox += dx;
            oy += dy;
        }
        draw.end("LodDraw");
        profiler.popPush("LOD cleanup");
        LagSpikeCatcher drawCleanup = new LagSpikeCatcher();
        lightmap.unbind();
        this.quadIBO.unbind();
        GL32.glBindBuffer((int)34962, (int)0);
        this.shaderProgram.unbind();
        GL32.glClear((int)256);
        currentState.restore();
        drawCleanup.end("LodDrawCleanup");
        profiler.pop();
        tickLogger.incLogTries();
    }

    private void setup() {
        if (this.isSetupComplete) {
            EVENT_LOGGER.warn("Renderer setup called but it has already completed setup!", new Object[0]);
            return;
        }
        if (!GLProxy.hasInstance()) {
            EVENT_LOGGER.warn("Renderer setup called but GLProxy has not yet been setup!", new Object[0]);
            return;
        }
        EVENT_LOGGER.info("Setting up renderer", new Object[0]);
        this.isSetupComplete = true;
        this.shaderProgram = new LodRenderProgram(LodFogConfig.generateFogConfig());
        this.quadIBO = new QuadElementBuffer();
        this.quadIBO.reserve(LodBufferBuilderFactory.MAX_QUADS_PER_BUFFER);
        EVENT_LOGGER.info("Renderer setup complete", new Object[0]);
    }

    public void setupBuffers() {
        this.lodBufferBuilderFactory.triggerReset();
    }

    private Color getFogColor(float partialTicks) {
        Color fogColor = CONFIG.client().graphics().fogQuality().getFogColorMode() == FogColorMode.USE_SKY_COLOR ? MC_RENDER.getSkyColor() : MC_RENDER.getFogColor(partialTicks);
        return fogColor;
    }

    private Color getSpecialFogColor(float partialTicks) {
        return MC_RENDER.getSpecialFogColor(partialTicks);
    }

    private static float calculateNearClipPlane(float distance, float partialTicks) {
        double fov = MC_RENDER.getFov(partialTicks);
        double aspectRatio = (double)MC_RENDER.getScreenWidth() / (double)MC_RENDER.getScreenHeight();
        return (float)((double)distance / Math.sqrt(1.0 + LodUtil.pow2(Math.tan(fov / 180.0 * Math.PI / 2.0)) * (LodUtil.pow2(aspectRatio) + 1.0)));
    }

    private static Mat4f createCombinedMatrix(Mat4f projMat, Mat4f modelMat, float vanillaBlockRenderedDistance, int farPlaneBlockDistance, float partialTicks) {
        Mat4f lodProj = projMat.copy();
        float nearClipPlane = CONFIG.client().advanced().getLodOnlyMode() ? 0.1f : (CONFIG.client().graphics().advancedGraphics().getUseExtendedNearClipPlane() ? Math.min(vanillaBlockRenderedDistance - 16.0f, 128.0f) : 16.0f);
        lodProj.setClipPlanes(LodRenderer.calculateNearClipPlane(nearClipPlane, partialTicks), (float)((double)(farPlaneBlockDistance + 512) * Math.sqrt(2.0)));
        lodProj.multiply(modelMat);
        return lodProj;
    }

    private void cleanup() {
        if (!this.isSetupComplete) {
            EVENT_LOGGER.warn("Renderer cleanup called but Renderer has not completed setup!", new Object[0]);
            return;
        }
        if (!GLProxy.hasInstance()) {
            EVENT_LOGGER.warn("Renderer Cleanup called but the GLProxy has never been inited!", new Object[0]);
            return;
        }
        this.isSetupComplete = false;
        EVENT_LOGGER.info("Renderer Cleanup Started", new Object[0]);
        this.shaderProgram.free();
        if (this.quadIBO != null) {
            this.quadIBO.destroy(false);
        }
        EVENT_LOGGER.info("Renderer Cleanup Complete", new Object[0]);
    }

    public void destroyBuffers() {
        this.lodBufferBuilderFactory.destroyBuffers();
    }

    public void regenerateLODsNextFrame() {
        this.fullRegen = true;
    }

    private boolean updateVanillaRenderedChunks(LodDimension lodDim) {
        IWorldWrapper world = MC.getWrappedClientWorld();
        if (this.lastUpdatedPos.getY() > world.getHeight() - world.getMinHeight() || CONFIG.client().advanced().getLodOnlyMode()) {
            if (this.vanillaChunks != null) {
                this.vanillaChunks = null;
                return true;
            }
            return false;
        }
        LagSpikeCatcher getChunks = new LagSpikeCatcher();
        EdgeDistanceBooleanGrid edgeGrid = LodUtil.readVanillaRenderedChunks(lodDim);
        if (edgeGrid == null) {
            if (this.vanillaChunks != null) {
                this.vanillaChunks = null;
                return true;
            }
            return false;
        }
        getChunks.end("LodDrawSetup:UpdateStatus:UpdateVanillaChunks:getChunks");
        PosArrayGridList grid = new PosArrayGridList(edgeGrid.gridSize, edgeGrid.getOffsetX(), edgeGrid.getOffsetY());
        int overdrawOffset = LodUtil.computeOverdrawOffset(lodDim);
        edgeGrid.flagAllWithDistance(grid, i -> i >= overdrawOffset);
        this.vanillaChunks = grid;
        return true;
    }

    private void updateRegenStatus(LodDimension lodDim, float partialTicks) {
        short chunkRenderDistance = (short)MC_RENDER.getRenderDistance();
        long newTime = System.currentTimeMillis();
        AbstractBlockPosWrapper newPos = MC.getPlayerBlockPos();
        boolean shouldUpdateChunks = false;
        boolean tryPartialGen = false;
        boolean tryFullGen = false;
        if (ApiShared.previousLodRenderDistance != CONFIG.client().graphics().quality().getLodChunkRenderDistance() || chunkRenderDistance != this.prevRenderDistance || this.prevFogDistance != CONFIG.client().graphics().fogQuality().getFogDistance()) {
            DetailDistanceUtil.updateSettings();
            this.prevFogDistance = CONFIG.client().graphics().fogQuality().getFogDistance();
            this.prevRenderDistance = chunkRenderDistance;
            tryFullGen = true;
        } else if (CONFIG.client().advanced().debugging().getDebugMode() != this.previousDebugMode) {
            this.previousDebugMode = CONFIG.client().advanced().debugging().getDebugMode();
            tryFullGen = true;
        }
        if (newTime - this.prevPlayerPosTime > (long)LodRenderer.CONFIG.client().advanced().buffers().getRebuildTimes().playerMoveTimeout) {
            if (this.lastUpdatedPos == null || Math.abs(newPos.getX() - this.lastUpdatedPos.getX()) > LodRenderer.CONFIG.client().advanced().buffers().getRebuildTimes().playerMoveDistance * 16 || Math.abs(newPos.getZ() - this.lastUpdatedPos.getZ()) > LodRenderer.CONFIG.client().advanced().buffers().getRebuildTimes().playerMoveDistance * 16) {
                shouldUpdateChunks = true;
            }
            this.prevPlayerPosTime = newTime;
        }
        if (newTime - this.prevVanillaChunkTime > (long)LodRenderer.CONFIG.client().advanced().buffers().getRebuildTimes().renderedChunkTimeout) {
            shouldUpdateChunks = true;
            this.prevVanillaChunkTime = newTime;
        }
        if (newTime - this.prevChunkTime > (long)LodRenderer.CONFIG.client().advanced().buffers().getRebuildTimes().chunkChangeTimeout) {
            tryPartialGen = true;
            this.prevChunkTime = newTime;
        }
        if (shouldUpdateChunks |= tryFullGen) {
            this.lastUpdatedPos = newPos;
            tryPartialGen |= this.updateVanillaRenderedChunks(lodDim);
        }
        if (tryFullGen) {
            this.fullRegen = true;
        } else if (tryPartialGen) {
            this.partialRegen = true;
        }
    }

    public static class LagSpikeCatcher {
        long timer = System.nanoTime();

        public void end(String source) {
        }
    }
}

