/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.render;

import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.objects.math.Vec3f;
import com.seibel.lod.core.wrapperInterfaces.block.AbstractBlockPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.chunk.AbstractChunkPosWrapper;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftRenderWrapper;

public class RenderUtil {
    private static final IMinecraftRenderWrapper MC_RENDER = SingletonHandler.get(IMinecraftRenderWrapper.class);

    public static boolean isChunkPosInLoadedArea(AbstractChunkPosWrapper pos, AbstractChunkPosWrapper center) {
        return pos.getX() >= center.getX() - MC_RENDER.getRenderDistance() && pos.getX() <= center.getX() + MC_RENDER.getRenderDistance() && pos.getZ() >= center.getZ() - MC_RENDER.getRenderDistance() && pos.getZ() <= center.getZ() + MC_RENDER.getRenderDistance();
    }

    public static boolean isCoordinateInLoadedArea(int x, int z, int centerCoordinate) {
        return x >= centerCoordinate - MC_RENDER.getRenderDistance() && x <= centerCoordinate + MC_RENDER.getRenderDistance() && z >= centerCoordinate - MC_RENDER.getRenderDistance() && z <= centerCoordinate + MC_RENDER.getRenderDistance();
    }

    public static boolean isCoordinateInNearFogArea(int i, int j, int lodRadius) {
        int halfRadius = lodRadius / 2;
        return i >= lodRadius - halfRadius && i <= lodRadius + halfRadius && j >= lodRadius - halfRadius && j <= lodRadius + halfRadius;
    }

    public static boolean isRegionInViewFrustum(AbstractBlockPosWrapper playerBlockPos, Vec3f cameraDir, int vboRegionX, int vboRegionZ) {
        Vec3f vboVec = new Vec3f(vboRegionX * 512, 0.0f, vboRegionZ * 512);
        Vec3f playerVec = new Vec3f(playerBlockPos.getX(), playerBlockPos.getY(), playerBlockPos.getZ());
        vboVec.subtract(playerVec);
        Vec3f vboSeVec = new Vec3f(vboVec.x + 512.0f, vboVec.y, vboVec.z + 512.0f);
        Vec3f vboSwVec = new Vec3f(vboVec.x, vboVec.y, vboVec.z + 512.0f);
        Vec3f vboNwVec = new Vec3f(vboVec.x, vboVec.y, vboVec.z);
        Vec3f vboNeVec = new Vec3f(vboVec.x + 512.0f, vboVec.y, vboVec.z);
        return RenderUtil.isNormalizedVectorInViewFrustum(vboSeVec, cameraDir) || RenderUtil.isNormalizedVectorInViewFrustum(vboSwVec, cameraDir) || RenderUtil.isNormalizedVectorInViewFrustum(vboNwVec, cameraDir) || RenderUtil.isNormalizedVectorInViewFrustum(vboNeVec, cameraDir);
    }

    private static boolean isNormalizedVectorInViewFrustum(Vec3f objectVector, Vec3f cameraDir) {
        return (double)objectVector.dotProduct(cameraDir) > -0.1;
    }
}

