/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.wrapperInterfaces.chunk;

import com.seibel.lod.core.enums.LodDirection;
import com.seibel.lod.core.handlers.dependencyInjection.IBindable;
import com.seibel.lod.core.wrapperInterfaces.block.IBlockDetailWrapper;
import com.seibel.lod.core.wrapperInterfaces.world.IBiomeWrapper;

public interface IChunkWrapper
extends IBindable {
    default public int getHeight() {
        return this.getMaxBuildHeight() - this.getMinBuildHeight();
    }

    public int getMinBuildHeight();

    public int getMaxBuildHeight();

    public int getHeightMapValue(int var1, int var2);

    public IBiomeWrapper getBiome(int var1, int var2, int var3);

    public IBlockDetailWrapper getBlockDetail(int var1, int var2, int var3);

    public IBlockDetailWrapper getBlockDetailAtFace(int var1, int var2, int var3, LodDirection var4);

    public int getChunkPosX();

    public int getChunkPosZ();

    public int getRegionPosX();

    public int getRegionPosZ();

    public int getMaxY(int var1, int var2);

    public int getMaxX();

    public int getMaxZ();

    public int getMinX();

    public int getMinZ();

    public long getLongChunkPos();

    public boolean isLightCorrect();

    public boolean isWaterLogged(int var1, int var2, int var3);

    public int getEmittedBrightness(int var1, int var2, int var3);

    default public int getBlockLight(int x, int y, int z) {
        return -1;
    }

    default public int getSkyLight(int x, int y, int z) {
        return -1;
    }

    default public boolean blockPosInsideChunk(int x, int y, int z) {
        return x >= this.getMinX() && x <= this.getMaxX() && y >= this.getMinBuildHeight() && y < this.getMaxBuildHeight() && z >= this.getMinZ() && z <= this.getMaxZ();
    }

    public boolean doesNearbyChunksExist();

    public String toString();

    default public int roughHashCode() {
        int hash = 31;
        int primeMultiplier = 227;
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                hash = hash * primeMultiplier + Integer.hashCode(this.getMaxY(x, z));
            }
        }
        return hash;
    }
}

