/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.core.wrapperInterfaces.config;

import com.seibel.lod.core.enums.config.BlocksToAvoid;
import com.seibel.lod.core.enums.config.BufferRebuildTimes;
import com.seibel.lod.core.enums.config.DistanceGenerationMode;
import com.seibel.lod.core.enums.config.DropoffQuality;
import com.seibel.lod.core.enums.config.GenerationPriority;
import com.seibel.lod.core.enums.config.GpuUploadMethod;
import com.seibel.lod.core.enums.config.HorizontalQuality;
import com.seibel.lod.core.enums.config.HorizontalResolution;
import com.seibel.lod.core.enums.config.LightGenerationMode;
import com.seibel.lod.core.enums.config.LoggerMode;
import com.seibel.lod.core.enums.config.ServerFolderNameMode;
import com.seibel.lod.core.enums.config.VanillaOverdraw;
import com.seibel.lod.core.enums.config.VerticalQuality;
import com.seibel.lod.core.enums.rendering.DebugMode;
import com.seibel.lod.core.enums.rendering.FogColorMode;
import com.seibel.lod.core.enums.rendering.FogDistance;
import com.seibel.lod.core.enums.rendering.FogDrawMode;
import com.seibel.lod.core.enums.rendering.FogSetting;
import com.seibel.lod.core.enums.rendering.HeightFogMixMode;
import com.seibel.lod.core.enums.rendering.HeightFogMode;
import com.seibel.lod.core.enums.rendering.RendererType;
import com.seibel.lod.core.handlers.dependencyInjection.IBindable;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.objects.MinDefaultMax;
import com.seibel.lod.core.wrapperInterfaces.IVersionConstants;
import com.seibel.lod.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;

public interface ILodConfigWrapperSingleton
extends IBindable {
    public IClient client();

    public static interface IClient {
        public static final boolean OPTIONS_BUTTON_DEFAULT = true;
        public static final String OPTIONS_BUTTON_DESC = " Show the lod button in the options screen next to fov";

        public IGraphics graphics();

        public IWorldGenerator worldGenerator();

        public IMultiplayer multiplayer();

        public IAdvanced advanced();

        public boolean getOptionsButton();

        public void setOptionsButton(boolean var1);

        public static interface IAdvanced {
            public static final String DESC = "Advanced mod settings";
            public static final boolean LOD_ONLY_MODE_DEFAULT = false;
            public static final String LOD_ONLY_MODE_DESC = " Due to some demand for playing without vanilla terrains, \n we decided to add this mode for fun. \n\n NOTE: Do not report any issues when this mode is on! \n   Again, this setting is only for fun, and mod \n   compatibility is not guaranteed. \n\n";

            public IThreading threading();

            public IDebugging debugging();

            public IBuffers buffers();

            public boolean getLodOnlyMode();

            public void setLodOnlyMode(boolean var1);

            public static interface IBuffers {
                public static final String DESC = "These settings affect how often geometry is rebuilt.";
                public static final GpuUploadMethod GPU_UPLOAD_METHOD_DEFAULT = GpuUploadMethod.AUTO;
                public static final String GPU_UPLOAD_METHOD_DESC = " What method should be used to upload geometry to the GPU? \n\n " + (Object)((Object)GpuUploadMethod.AUTO) + ": Picks the best option based on the GPU you have. \n " + (Object)((Object)GpuUploadMethod.BUFFER_STORAGE) + ": Default for NVIDIA if OpenGL 4.5 is supported. \n                 Fast rendering, no stuttering. \n " + (Object)((Object)GpuUploadMethod.SUB_DATA) + ": Backup option for NVIDIA. \n           Fast rendering but may stutter when uploading. \n " + (Object)((Object)GpuUploadMethod.BUFFER_MAPPING) + ": Slow rendering but won't stutter when uploading. Possibly the best option for integrated GPUs. \n                Default option for AMD/Intel. \n                May end up storing buffers in System memory. \n                Fast rendering if in GPU memory, slow if in system memory, \n                but won't stutter when uploading.  \n " + (Object)((Object)GpuUploadMethod.DATA) + ": Fast rendering but will stutter when uploading. \n       Backup option for AMD/Intel. \n       Fast rendering but may stutter when uploading. \n\n If you don't see any difference when changing these settings, or the world looks corrupted: \n Restart the game to clear the old buffers. \n";
                public static final MinDefaultMax<Integer> GPU_UPLOAD_PER_MEGABYTE_IN_MILLISECONDS_DEFAULT = new MinDefaultMax<Integer>(0, 0, 50);
                public static final String GPU_UPLOAD_PER_MEGABYTE_IN_MILLISECONDS_DESC = " How long should a buffer wait per Megabyte of data uploaded?\n Helpful resource for frame times: https://fpstoms.com \n\n Longer times may reduce stuttering but will make fake chunks \n transition and load slower. Change this to [0] for no timeout.\n\n NOTE:\n Before changing this config, try changing \"GPU Upload methods\"\n  and determined the best method for your hardware first. \n";
                public static final String REBUILD_TIMES_DESC = " How frequently should vertex buffers (geometry) be rebuilt and sent to the GPU? \n Higher settings may cause stuttering, but will prevent holes in the world \n";
                public static final BufferRebuildTimes REBUILD_TIMES_DEFAULT = BufferRebuildTimes.NORMAL;

                public GpuUploadMethod getGpuUploadMethod();

                public void setGpuUploadMethod(GpuUploadMethod var1);

                public int getGpuUploadPerMegabyteInMilliseconds();

                public void setGpuUploadPerMegabyteInMilliseconds(int var1);

                public BufferRebuildTimes getRebuildTimes();

                public void setRebuildTimes(BufferRebuildTimes var1);
            }

            public static interface IDebugging {
                public static final String DESC = "These settings can be used to look for bugs, or see how certain aspects of the mod work.";
                public static final RendererType RENDERER_TYPE_DEFAULT = RendererType.DEFAULT;
                public static final String RENDERER_TYPE_DESC = " What renderer is active? \n\n " + (Object)((Object)RendererType.DEFAULT) + ": Default lod renderer \n " + (Object)((Object)RendererType.DEBUG) + ": Debug testing renderer \n " + (Object)((Object)RendererType.DISABLED) + ": Disable rendering \n";
                public static final DebugMode DEBUG_MODE_DEFAULT = DebugMode.OFF;
                public static final String DEBUG_MODE_DESC = " Should specialized colors/rendering modes be used? \n\n " + (Object)((Object)DebugMode.OFF) + ": Fake chunks will be drawn with their normal colors. \n " + (Object)((Object)DebugMode.SHOW_WIREFRAME) + ": Fake chunks will be drawn as wireframes. \n " + (Object)((Object)DebugMode.SHOW_DETAIL) + ": Fake chunks color will be based on their detail level. \n " + (Object)((Object)DebugMode.SHOW_DETAIL_WIREFRAME) + ": Fake chunks color will be based on their detail level, drawn as a wireframe. \n " + (Object)((Object)DebugMode.SHOW_GENMODE) + ": Fake chunks color will be based on their distant generation mode. \n " + (Object)((Object)DebugMode.SHOW_GENMODE_WIREFRAME) + ": Fake chunks color will be based on their distant generation mode, drawn as a wireframe. \n " + (Object)((Object)DebugMode.SHOW_OVERLAPPING_QUADS) + ": Fake chunks will be drawn with total white, but overlapping quads will be drawn with red. \n " + (Object)((Object)DebugMode.SHOW_OVERLAPPING_QUADS_WIREFRAME) + ": Fake chunks will be drawn with total white, \n but overlapping quads will be drawn with red, drawn as a wireframe. \n";
                public static final boolean DEBUG_KEYBINDINGS_ENABLED_DEFAULT = false;
                public static final String DEBUG_KEYBINDINGS_ENABLED_DESC = " If true the F8 key can be used to cycle through the different debug modes. \n and the F6 key can be used to enable and disable LOD rendering.";

                public RendererType getRendererType();

                public void setRendererType(RendererType var1);

                public DebugMode getDebugMode();

                public void setDebugMode(DebugMode var1);

                public boolean getDebugKeybindingsEnabled();

                public void setDebugKeybindingsEnabled(boolean var1);

                public IDebugSwitch debugSwitch();

                public static interface IDebugSwitch {
                    public static final String DESC = "These settings can be used to look for bugs by enabling and disabling logging.";
                    public static final LoggerMode LOG_WORLDGEN_EVENT_DEFAULT = LoggerMode.LOG_WARNING_TO_CHAT_AND_INFO_TO_FILE;
                    public static final String LOG_WORLDGEN_EVENT_DESC = " If enabled, the mod will log information about the world generation process. \n This can be useful for debugging. \n";
                    public static final LoggerMode LOG_WORLDGEN_PERFORMANCE_DEFAULT = LoggerMode.LOG_WARNING_TO_CHAT_AND_FILE;
                    public static final String LOG_WORLDGEN_PERFORMANCE_DESC = " If enabled, the mod will log performance about the world generation process. \n This can be useful for debugging. \n";
                    public static final LoggerMode LOG_WORLDGEN_LOAD_EVENT_DEFAULT = LoggerMode.LOG_WARNING_TO_CHAT_AND_FILE;
                    public static final String LOG_WORLDGEN_LOAD_EVENT_DESC = " If enabled, the mod will log information about the world generation process. \n This can be useful for debugging. \n";
                    public static final LoggerMode LOG_LODBUILDER_EVENT_DEFAULT = LoggerMode.LOG_WARNING_TO_CHAT_AND_INFO_TO_FILE;
                    public static final String LOG_LODBUILDER_EVENT_DESC = " If enabled, the mod will log information about the LOD generation process. \n This can be useful for debugging. \n";
                    public static final LoggerMode LOG_RENDERER_BUFFER_EVENT_DEFAULT = LoggerMode.LOG_WARNING_TO_CHAT_AND_INFO_TO_FILE;
                    public static final String LOG_RENDERER_BUFFER_EVENT_DESC = " If enabled, the mod will log information about the renderer buffer process. \n This can be useful for debugging. \n";
                    public static final LoggerMode LOG_RENDERER_GL_EVENT_DEFAULT = LoggerMode.LOG_WARNING_TO_CHAT_AND_INFO_TO_FILE;
                    public static final String LOG_RENDERER_GL_EVENT_DESC = " If enabled, the mod will log information about the renderer OpenGL process. \n This can be useful for debugging. \n";
                    public static final LoggerMode LOG_FILE_READWRITE_EVENT_DEFAULT = LoggerMode.LOG_WARNING_TO_CHAT_AND_INFO_TO_FILE;
                    public static final String LOG_FILE_READWRITE_EVENT_DESC = " If enabled, the mod will log information about file read/write operations. \n This can be useful for debugging. \n";
                    public static final LoggerMode LOG_FILE_SUB_DIM_EVENT_DEFAULT = LoggerMode.LOG_WARNING_TO_CHAT_AND_INFO_TO_FILE;
                    public static final String LOG_FILE_SUB_DIM_EVENT_DESC = " If enabled, the mod will log information about file sub-dimension operations. \n This can be useful for debugging. \n";
                    public static final LoggerMode LOG_NETWORK_EVENT_DEFAULT = LoggerMode.LOG_WARNING_TO_CHAT_AND_INFO_TO_FILE;
                    public static final String LOG_NETWORK_EVENT_DESC = " If enabled, the mod will log information about network operations. \n This can be useful for debugging. \n";

                    public LoggerMode getLogWorldGenEvent();

                    public void setLogWorldGenEvent(LoggerMode var1);

                    public LoggerMode getLogWorldGenPerformance();

                    public void setLogWorldGenPerformance(LoggerMode var1);

                    public LoggerMode getLogWorldGenLoadEvent();

                    public void setLogWorldGenLoadEvent(LoggerMode var1);

                    public LoggerMode getLogLodBuilderEvent();

                    public void setLogLodBuilderEvent(LoggerMode var1);

                    public LoggerMode getLogRendererBufferEvent();

                    public void setLogRendererBufferEvent(LoggerMode var1);

                    public LoggerMode getLogRendererGLEvent();

                    public void setLogRendererGLEvent(LoggerMode var1);

                    public LoggerMode getLogFileReadWriteEvent();

                    public void setLogFileReadWriteEvent(LoggerMode var1);

                    public LoggerMode getLogFileSubDimEvent();

                    public void setLogFileSubDimEvent(LoggerMode var1);

                    public LoggerMode getLogNetworkEvent();

                    public void setLogNetworkEvent(LoggerMode var1);
                }
            }

            public static interface IThreading {
                public static final String DESC = "These settings control how many CPU threads the mod uses for different tasks.";
                public static final MinDefaultMax<Double> NUMBER_OF_WORLD_GENERATION_THREADS_DEFAULT = new MinDefaultMax<Double>(0.1, Double.valueOf(Math.min(Runtime.getRuntime().availableProcessors() / 2, 4)), Double.valueOf(Runtime.getRuntime().availableProcessors()));
                public static final String NUMBER_OF_WORLD_GENERATION_THREADS_DESC = " How many threads should be used when generating fake \n chunks outside the normal render distance? \n\n If it's less than 1, it will be treated as a percentage \n of time single thread can run before going to idle. \n\n If you experience stuttering when generating distant LODs, \n decrease  this number. If you want to increase LOD \n generation speed, increase this number. \n\n This and the number of buffer builder threads are independent, \n so if they add up to more threads than your CPU has cores, \n that shouldn't cause an issue. \n";
                public static final MinDefaultMax<Integer> NUMBER_OF_BUFFER_BUILDER_THREADS_MIN_DEFAULT_MAX = new MinDefaultMax<Integer>(1, Math.min(Runtime.getRuntime().availableProcessors() / 2, 2), Runtime.getRuntime().availableProcessors());
                public static final String NUMBER_OF_BUFFER_BUILDER_THREADS_DESC = " How many threads are used when building vertex buffers? \n (The things sent to your GPU to draw the fake chunks). \n\n If you experience high CPU usage when NOT generating distant \n fake chunks, lower this number. A higher number will make fake\n fake chunks' transition faster when moving around the world. \n\n This and the number of world generator threads are independent, \n so if they add up to more threads than your CPU has cores, \n that shouldn't cause an issue. \n\n The maximum value is the number of logical processors on your CPU. \n";

                public double getNumberOfWorldGenerationThreads();

                public void setNumberOfWorldGenerationThreads(double var1);

                default public int _getWorldGenerationThreadPoolSize() {
                    return this.getNumberOfWorldGenerationThreads() < 1.0 ? 1 : (int)Math.ceil(this.getNumberOfWorldGenerationThreads());
                }

                default public double _getWorldGenerationPartialRunTime() {
                    return this.getNumberOfWorldGenerationThreads() > 1.0 ? 1.0 : this.getNumberOfWorldGenerationThreads();
                }

                public int getNumberOfBufferBuilderThreads();

                public void setNumberOfBufferBuilderThreads(int var1);
            }
        }

        public static interface IWorldGenerator {
            public static final String DESC = "These settings control how fake chunks outside your normal view range are generated.";
            public static final boolean ENABLE_DISTANT_GENERATION_DEFAULT = true;
            public static final String ENABLE_DISTANT_GENERATION_DESC = " Whether to enable Distant chunks generator? \n\n Turning this on allows Distant Horizons to make lods for chunks \n that are outside of vanilla view distance. \n\n Note that in server, distant generation is always off. \n";
            public static final DistanceGenerationMode DISTANCE_GENERATION_MODE_DEFAULT = DistanceGenerationMode.FEATURES;
            public static final LightGenerationMode LIGHT_GENERATION_MODE_DEFAULT = LightGenerationMode.FANCY;
            public static final String LIGHT_GENERATION_MODE_DESC = " How should block and sky lights be processed for distant generation? \n\n Note that this include already existing chunks since vanilla \n does not store sky light values to save file. \n\n " + (Object)((Object)LightGenerationMode.FAST) + ": Use height map to fake the light values. \n " + (Object)((Object)LightGenerationMode.FANCY) + ": Use actaul light engines to generate proper values. \n\n This will effect generation speed, but not the rendering performance.";
            public static final GenerationPriority GENERATION_PRIORITY_DEFAULT = GenerationPriority.NEAR_FIRST;
            public static final String GENERATION_PRIORITY_DESC = " In what priority should fake chunks be generated outside the vanilla render distance? \n\n " + (Object)((Object)GenerationPriority.FAR_FIRST) + " \n Fake chunks are generated from lowest to highest detail \n with a priority for far away regions. \n This fills in the world fastest, but you will have large low detail \n blocks for a while while the generation happens. \n\n " + (Object)((Object)GenerationPriority.NEAR_FIRST) + " \n Fake chunks are generated around the player \n in a spiral, similar to vanilla minecraft. \n Best used when on a server since we can't generate \n fake chunks. \n\n " + (Object)((Object)GenerationPriority.BALANCED) + " \n A mix between " + (Object)((Object)GenerationPriority.NEAR_FIRST) + "and" + (Object)((Object)GenerationPriority.FAR_FIRST) + ". \n First prioritise completing nearby highest detail chunks, \n then focus on filling in the low detail areas away from the player. \n\n " + (Object)((Object)GenerationPriority.AUTO) + " \n Uses " + (Object)((Object)GenerationPriority.BALANCED) + " when on a single player world \n and " + (Object)((Object)GenerationPriority.NEAR_FIRST) + " when connected to a server. \n\n This shouldn't affect performance.";
            public static final BlocksToAvoid BLOCKS_TO_AVOID_DEFAULT = BlocksToAvoid.BOTH;
            public static final String BLOCKS_TO_AVOID_DESC = " When generating fake chunks, what blocks should be ignored? \n Ignored blocks don't affect the height of the fake chunk, but might affect the color. \n So using " + (Object)((Object)BlocksToAvoid.BOTH) + " will prevent snow covered blocks from appearing one block too tall, \n but will still show the snow's color.\n\n " + (Object)((Object)BlocksToAvoid.NONE) + ": Use all blocks when generating fake chunks \n " + (Object)((Object)BlocksToAvoid.NON_FULL) + ": Only use full blocks when generating fake chunks (ignores slabs, lanterns, torches, tall grass, etc.) \n " + (Object)((Object)BlocksToAvoid.NO_COLLISION) + ": Only use solid blocks when generating fake chunks (ignores tall grass, torches, etc.) \n " + (Object)((Object)BlocksToAvoid.BOTH) + ": Only use full solid blocks when generating fake chunks \n\n This wont't affect performance.";

            public boolean getEnableDistantGeneration();

            public void setEnableDistantGeneration(boolean var1);

            public static String getDistanceGenerationModeDesc(IVersionConstants versionConstants) {
                return " How detailed should fake chunks be generated outside the vanilla render distance? \n\n The times are the amount of time it took one of the developer's PC to generate \n one chunk in Minecraft 1.16.5 and may be inaccurate for different Minecraft versions. \n They are included to give a rough estimate as to how the different options \n may perform in comparison to each other. \n (Note that all modes will load in already existing chunks) \n\n " + (Object)((Object)DistanceGenerationMode.NONE) + " \n Only run the Generator to load in already existing chunks. \n\n " + (Object)((Object)DistanceGenerationMode.BIOME_ONLY) + " \n Only generate the biomes and use the biome's \n grass color, water color, or snow color. \n Doesn't generate height, everything is shown at sea level. \n  - Fastest (2-5 ms) \n\n " + (Object)((Object)DistanceGenerationMode.BIOME_ONLY_SIMULATE_HEIGHT) + " \n Same as " + (Object)((Object)DistanceGenerationMode.BIOME_ONLY) + ", except instead \n of always using sea level as the LOD height \n different biome types (mountain, ocean, forest, etc.) \n use predetermined heights to simulate having height data. \n  - Fastest (2-5 ms) \n\n " + (Object)((Object)DistanceGenerationMode.SURFACE) + " \n Generate the world surface, \n this does NOT include trees, \n or structures. \n  - Faster (10-20 ms) \n\n " + (Object)((Object)DistanceGenerationMode.FEATURES) + " \n Generate everything except structures. \n WARNING: This may cause world generation bugs or instability! \n  - Fast (15-20 ms) \n\n " + (Object)((Object)DistanceGenerationMode.FULL) + " \n Ask the local server to generate/load each chunk. \n This will show player made structures, which can \n be useful if you are adding the mod to a pre-existing world. \n This is the most compatible, but causes server/simulation lag. \n  - Slow (15-50 ms, with spikes up to 200 ms) \n\n The multithreaded options may increase CPU load significantly (while generating) \n depending on how many world generation threads you have allocated. \n";
            }

            public DistanceGenerationMode getDistanceGenerationMode();

            public void setDistanceGenerationMode(DistanceGenerationMode var1);

            public LightGenerationMode getLightGenerationMode();

            public void setLightGenerationMode(LightGenerationMode var1);

            public GenerationPriority getGenerationPriority();

            public void setGenerationPriority(GenerationPriority var1);

            default public GenerationPriority getResolvedGenerationPriority() {
                GenerationPriority priority = this.getGenerationPriority();
                IMinecraftClientWrapper MC = SingletonHandler.get(IMinecraftClientWrapper.class);
                if (priority == GenerationPriority.AUTO) {
                    priority = MC.hasSinglePlayerServer() ? GenerationPriority.FAR_FIRST : GenerationPriority.BALANCED;
                }
                return priority;
            }

            public BlocksToAvoid getBlocksToAvoid();

            public void setBlockToAvoid(BlocksToAvoid var1);
        }

        public static interface IMultiplayer {
            public static final String DESC = "These settings control how different systems work when connected to a multiplayer world.";
            public static final ServerFolderNameMode SERVER_FOLDER_NAME_MODE_DEFAULT = ServerFolderNameMode.AUTO;
            public static final String SERVER_FOLDER_NAME_MODE_DESC = " What multiplayer save folders should be named. \n\n " + ServerFolderNameMode.AUTO.toString() + ": " + ServerFolderNameMode.NAME_IP.toString() + " for LAN connections, " + ServerFolderNameMode.NAME_IP_PORT.toString() + " for all others. \n " + ServerFolderNameMode.NAME_ONLY.toString() + ": Example: \"Minecraft Server\" \n " + ServerFolderNameMode.NAME_IP.toString() + ": Example: \"Minecraft Server IP 192.168.1.40\" \n " + ServerFolderNameMode.NAME_IP_PORT.toString() + ": Example: \"Minecraft Server IP 192.168.1.40:25565\" \n\n";
            public static final MinDefaultMax<Double> MULTI_DIMENSION_REQUIRED_SIMILARITY_MIN_DEFAULT_MAX = new MinDefaultMax<Double>(0.0, 0.0, 1.0);
            public static final String MULTI_DIMENSION_REQUIRED_SIMILARITY_DESC = " When matching worlds of the same dimension type the \n tested chunks must be at least this percent the same \n in order to be considered the same world. \n\n Note: If you use portals to enter a dimension at two \n different locations this system may think it is two different worlds. \n\n 1.0 (100%) the chunks must be identical. \n 0.5 (50%)  the chunks must be half the same. \n 0.0 (0%)   disables multi-dimension support, \n            only one world will be used per dimension. \n\n";

            public ServerFolderNameMode getServerFolderNameMode();

            public void setServerFolderNameMode(ServerFolderNameMode var1);

            public double getMultiDimensionRequiredSimilarity();

            public void setMultiDimensionRequiredSimilarity(double var1);
        }

        public static interface IGraphics {
            public static final String DESC = "These settings control how the mod will look in game";

            public IQuality quality();

            public IFogQuality fogQuality();

            public IAdvancedGraphics advancedGraphics();

            public static interface IAdvancedGraphics {
                public static final String DESC = "Graphics options that are a bit more technical.";
                public static final boolean DISABLE_DIRECTIONAL_CULLING_DEFAULT = false;
                public static final String DISABLE_DIRECTIONAL_CULLING_DESC = " If false fake chunks behind the player's camera \n aren't drawn, increasing GPU performance. \n\n If true all LODs are drawn, even those behind \n the player's camera, decreasing GPU performance. \n\n Disable this if you see LODs disappearing at the corners of your vision. \n";
                public static final VanillaOverdraw VANILLA_OVERDRAW_DEFAULT = VanillaOverdraw.DYNAMIC;
                public static final String VANILLA_OVERDRAW_DESC = " How often should LODs be drawn on top of regular chunks? \n HALF and ALWAYS will prevent holes in the world, \n but may look odd for transparent blocks or in caves. \n\n " + (Object)((Object)VanillaOverdraw.NEVER) + ": \n     LODs won't render on top of vanilla chunks. Use Overdraw offset to change the border offset. \n " + (Object)((Object)VanillaOverdraw.DYNAMIC) + ": \n     LODs will render on top of distant vanilla chunks to hide delayed loading. \n     Will dynamically decide the border offset based on vanilla render distance. \n " + (Object)((Object)VanillaOverdraw.ALWAYS) + ": \n     LODs will render on all vanilla chunks preventing all holes in the world. \n\n This setting shouldn't affect performance. \n";
                public static final MinDefaultMax<Integer> OVERDRAW_OFFSET_MIN_DEFAULT_MAX = new MinDefaultMax<Integer>(-16, 0, 16);
                public static final String OVERDRAW_OFFSET_DESC = " If on Vanilla Overdraw mode of NEVER, how much should should the border be offset? \n\n  '1': The start of lods will be shifted inwards by 1 chunk, causing 1 chunk of overdraw. \n '-1': The start fo lods will be shifted outwards by 1 chunk, causing 1 chunk of gap. \n\n This setting can be used to deal with gaps due to our vanilla rendered chunk \n   detection not being perfect. \n";
                public static final boolean USE_EXTENDED_NEAR_CLIP_PLANE_DEFAULT = true;
                public static final String USE_EXTENDED_NEAR_CLIP_PLANE_DESC = " Will prevent some overdraw issues, but may cause nearby fake chunks to render incorrectly \n especially when in/near an ocean. \n\n This setting shouldn't affect performance. \n";
                public static final double BRIGHTNESS_MULTIPLIER_DEFAULT = 1.0;
                public static final String BRIGHTNESS_MULTIPLIER_DESC = " How bright fake chunk colors are. \n\n 0 = black \n 1 = normal \n 2 = near white \n";
                public static final double SATURATION_MULTIPLIER_DEFAULT = 1.0;
                public static final String SATURATION_MULTIPLIER_DESC = " How saturated fake chunk colors are. \n\n 0 = black and white \n 1 = normal \n 2 = very saturated \n";
                public static final boolean ENABLE_CAVE_CULLING_DEFAULT = true;
                public static final String ENABLE_CAVE_CULLING_DESC = " If enabled caves will be culled \n\n NOTE: This feature is under development and \n  it is VERY experimental! Please don't report \n any issues related to this feature. \n\n Additional Info: Currently this cull all faces \n  with skylight value of 0 in dimensions that \n  does not have a ceiling. \n";
                public static final MinDefaultMax<Integer> CAVE_CULLING_HEIGHT_MIN_DEFAULT_MAX = new MinDefaultMax<Integer>(-4096, 40, 4096);
                public static final String CAVE_CULLING_HEIGHT_DESC = " At what Y value should cave culling start? \n";
                public static final MinDefaultMax<Integer> EARTH_CURVE_RATIO_MIN_DEFAULT_MAX = new MinDefaultMax<Integer>(0, 0, 5000);
                public static final String EARTH_CURVE_RATIO_DESC = " This is the earth size ratio when applying the curvature shader effect. \n\n NOTE: This feature is just for fun and is VERY experimental! \nPlease don't report any issues related to this feature. \n\n 0 = flat/disabled \n 1 = 1 to 1 (6,371,000 blocks) \n 100 = 1 to 100 (63,710 blocks) \n 10000 = 1 to 10000 (637.1 blocks) \n\n NOTE: Due to current limitations, the min value is 50 \n and the max value is 5000. Any values outside this range \n will be set to 0(disabled).";

                public boolean getDisableDirectionalCulling();

                public void setDisableDirectionalCulling(boolean var1);

                public VanillaOverdraw getVanillaOverdraw();

                public void setVanillaOverdraw(VanillaOverdraw var1);

                public int getOverdrawOffset();

                public void setOverdrawOffset(int var1);

                public boolean getUseExtendedNearClipPlane();

                public void setUseExtendedNearClipPlane(boolean var1);

                public double getBrightnessMultiplier();

                public void setBrightnessMultiplier(double var1);

                public double getSaturationMultiplier();

                public void setSaturationMultiplier(double var1);

                public boolean getEnableCaveCulling();

                public void setEnableCaveCulling(boolean var1);

                public int getCaveCullingHeight();

                public void setCaveCullingHeight(int var1);

                public int getEarthCurveRatio();

                public void setEarthCurveRatio(int var1);
            }

            public static interface IFogQuality {
                public static final String DESC = "These settings control the fog quality.";
                public static final FogDistance FOG_DISTANCE_DEFAULT = FogDistance.FAR;
                public static final String FOG_DISTANCE_DESC = " At what distance should Fog be drawn on the fake chunks? \n\n This setting shouldn't affect performance.";
                public static final FogDrawMode FOG_DRAW_MODE_DEFAULT = FogDrawMode.FOG_ENABLED;
                public static final String FOG_DRAW_MODE_DESC = " When should fog be drawn? \n\n " + (Object)((Object)FogDrawMode.USE_OPTIFINE_SETTING) + ": Use whatever Fog setting Optifine is using.\n If Optifine isn't installed this defaults to " + (Object)((Object)FogDrawMode.FOG_ENABLED) + ". \n " + (Object)((Object)FogDrawMode.FOG_ENABLED) + ": Never draw fog on the LODs \n " + (Object)((Object)FogDrawMode.FOG_DISABLED) + ": Always draw fast fog on the LODs \n\n Disabling fog will improve GPU performance.";
                public static final FogColorMode FOG_COLOR_MODE_DEFAULT = FogColorMode.USE_WORLD_FOG_COLOR;
                public static final String FOG_COLOR_MODE_DESC = " What color should fog use? \n\n " + (Object)((Object)FogColorMode.USE_WORLD_FOG_COLOR) + ": Use the world's fog color. \n " + (Object)((Object)FogColorMode.USE_SKY_COLOR) + ": Use the sky's color. \n\n This setting doesn't affect performance.";
                public static final boolean DISABLE_VANILLA_FOG_DEFAULT = true;
                public static final String DISABLE_VANILLA_FOG_DESC = " If true disable Minecraft's fog. \n\n Experimental! Mod support is not guarantee.";

                public FogDistance getFogDistance();

                public void setFogDistance(FogDistance var1);

                public FogDrawMode getFogDrawMode();

                public void setFogDrawMode(FogDrawMode var1);

                public FogColorMode getFogColorMode();

                public void setFogColorMode(FogColorMode var1);

                public boolean getDisableVanillaFog();

                public void setDisableVanillaFog(boolean var1);

                public IAdvancedFog advancedFog();

                public static interface IAdvancedFog {
                    public static final String DESC = "Advanced settings for fog rendering. Has no effect if Far Fog is not drawn \nSee https://www.desmos.com/calculator/?????? for how setting effect the curve.";
                    public static final MinDefaultMax<Double> FOG_RANGE = new MinDefaultMax<Double>(0.0, 1.0, Math.sqrt(2.0));
                    public static final MinDefaultMax<Double> FAR_FOG_START_MIN_DEFAULT_MAX = new MinDefaultMax<Double>((Double)IAdvancedFog.FOG_RANGE.minValue, 0.0, (Double)IAdvancedFog.FOG_RANGE.maxValue);
                    public static final String FAR_FOG_START_DESC = " Where should the far fog start? \n\n   '0.0': Fog start at player's position.\n   '1.0': The fog-start's circle fit just in the lod render distance square.\n '1.414': The lod render distance square fit just in the fog-start's circle.\n";
                    public static final MinDefaultMax<Double> FAR_FOG_END_MIN_DEFAULT_MAX = new MinDefaultMax<Double>((Double)IAdvancedFog.FOG_RANGE.minValue, 1.0, (Double)IAdvancedFog.FOG_RANGE.maxValue);
                    public static final String FAR_FOG_END_DESC = " Where should the far fog end? \n\n   '0.0': Fog end at player's position.\n   '1.0': The fog-end's circle fit just in the lod render distance square.\n '1.414': The lod render distance square fit just in the fog-end's circle.\n";
                    public static final MinDefaultMax<Double> FAR_FOG_MIN_MIN_DEFAULT_MAX = new MinDefaultMax<Double>(-5.0, 0.0, (Double)IAdvancedFog.FOG_RANGE.maxValue);
                    public static final String FAR_FOG_MIN_DESC = " What is the minimum fog thickness? \n\n   '0.0': No fog at all.\n   '1.0': Fully fog color.\n";
                    public static final MinDefaultMax<Double> FAR_FOG_MAX_MIN_DEFAULT_MAX = new MinDefaultMax<Double>((Double)IAdvancedFog.FOG_RANGE.minValue, 1.0, 5.0);
                    public static final String FAR_FOG_MAX_DESC = " What is the maximum fog thickness? \n\n   '0.0': No fog at all.\n   '1.0': Fully fog color.\n";
                    public static final FogSetting.FogType FAR_FOG_TYPE_DEFAULT = FogSetting.FogType.EXPONENTIAL_SQUARED;
                    public static final String FAR_FOG_TYPE_DESC = " How the fog thickness should be calculated from distance? \n\n " + (Object)((Object)FogSetting.FogType.LINEAR) + ": Linear based on distance (will ignore 'density')\n " + (Object)((Object)FogSetting.FogType.EXPONENTIAL) + ": 1/(e^(distance*density)) \n " + (Object)((Object)FogSetting.FogType.EXPONENTIAL_SQUARED) + ": 1/(e^((distance*density)^2) \n";
                    public static final MinDefaultMax<Double> FAR_FOG_DENSITY_MIN_DEFAULT_MAX = new MinDefaultMax<Double>(0.01, 2.5, 50.0);
                    public static final String FAR_FOG_DENSITY_DESC = " What is the fog density? \n";

                    public double getFarFogStart();

                    public void setFarFogStart(double var1);

                    public double getFarFogEnd();

                    public void setFarFogEnd(double var1);

                    public double getFarFogMin();

                    public void setFarFogMin(double var1);

                    public double getFarFogMax();

                    public void setFarFogMax(double var1);

                    public FogSetting.FogType getFarFogType();

                    public void setFarFogType(FogSetting.FogType var1);

                    public double getFarFogDensity();

                    public void setFarFogDensity(double var1);

                    public IHeightFog heightFog();

                    default public FogSetting computeFarFogSetting() {
                        return new FogSetting(this.getFarFogStart(), this.getFarFogEnd(), this.getFarFogMin(), this.getFarFogMax(), this.getFarFogDensity(), this.getFarFogType());
                    }

                    public static interface IHeightFog {
                        public static final String DESC = "Advanced settings for how far fog interacts with height. Has no effect if Far Fog is not drawn \nSee https://www.desmos.com/calculator/drzzlfmur9 for how setting effect the curve.";
                        public static final HeightFogMixMode HEIGHT_FOG_MIX_MODE_DEFAULT = HeightFogMixMode.BASIC;
                        public static final String HEIGHT_FOG_MIX_MODE_DESC = " How the height should effect the fog thickness combined with the normal function? \n\n " + (Object)((Object)HeightFogMixMode.BASIC) + ": No special height fog effect. Fog is calculated based on camera distance \n " + (Object)((Object)HeightFogMixMode.IGNORE_HEIGHT) + ": Ignore height completely. Fog is calculated based on horizontal distance \n " + (Object)((Object)HeightFogMixMode.ADDITION) + ": heightFog + farFog \n " + (Object)((Object)HeightFogMixMode.MAX) + ": max(heightFog, farFog) \n " + (Object)((Object)HeightFogMixMode.MULTIPLY) + ": heightFog * farFog \n " + (Object)((Object)HeightFogMixMode.INVERSE_MULTIPLY) + ": 1 - (1-heightFog) * (1-farFog) \n " + (Object)((Object)HeightFogMixMode.LIMITED_ADDITION) + ": farFog + max(farFog, heightFog) \n " + (Object)((Object)HeightFogMixMode.MULTIPLY_ADDITION) + ": farFog + farFog * heightFog \n " + (Object)((Object)HeightFogMixMode.INVERSE_MULTIPLY_ADDITION) + ": farFog + 1 - (1-heightFog) * (1-farFog) \n " + (Object)((Object)HeightFogMixMode.AVERAGE) + ": farFog*0.5 + heightFog*0.5 \n\n Note that for 'BASIC' mode and 'IGNORE_HEIGHT' mode, fog settings for height fog has no effect.\n";
                        public static final HeightFogMode HEIGHT_FOG_MODE_DEFAULT = HeightFogMode.ABOVE_AND_BELOW_CAMERA;
                        public static final String HEIGHT_FOG_MODE_DESC = " Where should the height fog be located? \n\n " + (Object)((Object)HeightFogMode.ABOVE_CAMERA) + ": Height fog starts from camera to the sky \n " + (Object)((Object)HeightFogMode.BELOW_CAMERA) + ": Height fog starts from camera to the void \n " + (Object)((Object)HeightFogMode.ABOVE_AND_BELOW_CAMERA) + ": Height fog starts from camera to both the sky and the void \n " + (Object)((Object)HeightFogMode.ABOVE_SET_HEIGHT) + ": Height fog starts from a set height to the sky \n " + (Object)((Object)HeightFogMode.BELOW_SET_HEIGHT) + ": Height fog starts from a set height to the void \n " + (Object)((Object)HeightFogMode.ABOVE_AND_BELOW_SET_HEIGHT) + ": Height fog starts from a set height to both the sky and the void \n\n";
                        public static final MinDefaultMax<Double> HEIGHT_FOG_HEIGHT_MIN_DEFAULT_MAX = new MinDefaultMax<Double>(-4096.0, 70.0, 4096.0);
                        public static final String HEIGHT_FOG_HEIGHT_DESC = " If the height fog is calculated around a set height, what is that height position? \n\n";
                        public static final MinDefaultMax<Double> HEIGHT_FOG_START_MIN_DEFAULT_MAX = new MinDefaultMax<Double>((Double)IAdvancedFog.FOG_RANGE.minValue, 0.0, (Double)IAdvancedFog.FOG_RANGE.maxValue);
                        public static final String HEIGHT_FOG_START_DESC = " How far the start of height fog should offset? \n\n   '0.0': Fog start with no offset.\n   '1.0': Fog start with offset of the entire world's height. (Include depth)\n";
                        public static final MinDefaultMax<Double> HEIGHT_FOG_END_MIN_DEFAULT_MAX = new MinDefaultMax<Double>((Double)IAdvancedFog.FOG_RANGE.minValue, 1.0, (Double)IAdvancedFog.FOG_RANGE.maxValue);
                        public static final String HEIGHT_FOG_END_DESC = " How far the end of height fog should offset? \n\n   '0.0': Fog end with no offset.\n   '1.0': Fog end with offset of the entire world's height. (Include depth)\n";
                        public static final MinDefaultMax<Double> HEIGHT_FOG_MIN_MIN_DEFAULT_MAX = new MinDefaultMax<Double>(-5.0, 0.0, (Double)IAdvancedFog.FOG_RANGE.maxValue);
                        public static final String HEIGHT_FOG_MIN_DESC = " What is the minimum fog thickness? \n\n   '0.0': No fog at all.\n   '1.0': Fully fog color.\n";
                        public static final MinDefaultMax<Double> HEIGHT_FOG_MAX_MIN_DEFAULT_MAX = new MinDefaultMax<Double>((Double)IAdvancedFog.FOG_RANGE.minValue, 1.0, 5.0);
                        public static final String HEIGHT_FOG_MAX_DESC = " What is the maximum fog thickness? \n\n   '0.0': No fog at all.\n   '1.0': Fully fog color.\n";
                        public static final FogSetting.FogType HEIGHT_FOG_TYPE_DEFAULT = FogSetting.FogType.EXPONENTIAL_SQUARED;
                        public static final String HEIGHT_FOG_TYPE_DESC = " How the fog thickness should be calculated from height? \n\n " + (Object)((Object)FogSetting.FogType.LINEAR) + ": Linear based on height (will ignore 'density')\n " + (Object)((Object)FogSetting.FogType.EXPONENTIAL) + ": 1/(e^(height*density)) \n " + (Object)((Object)FogSetting.FogType.EXPONENTIAL_SQUARED) + ": 1/(e^((height*density)^2) \n";
                        public static final MinDefaultMax<Double> HEIGHT_FOG_DENSITY_MIN_DEFAULT_MAX = new MinDefaultMax<Double>(0.01, 2.5, 50.0);
                        public static final String HEIGHT_FOG_DENSITY_DESC = " What is the fog density? \n";

                        public HeightFogMixMode getHeightFogMixMode();

                        public void setHeightFogMixMode(HeightFogMixMode var1);

                        public HeightFogMode getHeightFogMode();

                        public void setHeightFogMode(HeightFogMode var1);

                        public double getHeightFogHeight();

                        public void setHeightFogHeight(double var1);

                        public double getHeightFogStart();

                        public void setHeightFogStart(double var1);

                        public double getHeightFogEnd();

                        public void setHeightFogEnd(double var1);

                        public double getHeightFogMin();

                        public void setHeightFogMin(double var1);

                        public double getHeightFogMax();

                        public void setHeightFogMax(double var1);

                        public FogSetting.FogType getHeightFogType();

                        public void setHeightFogType(FogSetting.FogType var1);

                        public double getHeightFogDensity();

                        public void setHeightFogDensity(double var1);

                        default public FogSetting computeHeightFogSetting() {
                            return new FogSetting(this.getHeightFogStart(), this.getHeightFogEnd(), this.getHeightFogMin(), this.getHeightFogMax(), this.getHeightFogDensity(), this.getHeightFogType());
                        }
                    }
                }
            }

            public static interface IQuality {
                public static final String DESC = "These settings control how detailed the fake chunks will be.";
                public static final HorizontalResolution DRAW_RESOLUTION_DEFAULT = HorizontalResolution.BLOCK;
                public static final String DRAW_RESOLUTION_DESC = " What is the maximum detail fake chunks should be drawn at? \n This setting will only affect closer chunks.\n Higher settings will increase memory and GPU usage. \n\n " + (Object)((Object)HorizontalResolution.CHUNK) + ": render 1 LOD for each Chunk. \n " + (Object)((Object)HorizontalResolution.HALF_CHUNK) + ": render 4 LODs for each Chunk. \n " + (Object)((Object)HorizontalResolution.FOUR_BLOCKS) + ": render 16 LODs for each Chunk. \n " + (Object)((Object)HorizontalResolution.TWO_BLOCKS) + ": render 64 LODs for each Chunk. \n " + (Object)((Object)HorizontalResolution.BLOCK) + ": render 256 LODs for each Chunk (width of one block). \n\n Lowest Quality: " + (Object)((Object)HorizontalResolution.CHUNK) + " Highest Quality: " + (Object)((Object)HorizontalResolution.BLOCK);
                public static final MinDefaultMax<Integer> LOD_CHUNK_RENDER_DISTANCE_MIN_DEFAULT_MAX = new MinDefaultMax<Integer>(32, 128, 2048);
                public static final String LOD_CHUNK_RENDER_DISTANCE_DESC = " The radius of the mod's render distance. (measured in chunks) \n";
                public static final VerticalQuality VERTICAL_QUALITY_DEFAULT = VerticalQuality.MEDIUM;
                public static final String VERTICAL_QUALITY_DESC = " This indicates how detailed fake chunks will represent \n overhangs, caves, floating islands, ect. \n Higher options will make the world more accurate, but will increase memory and GPU usage. \n\n " + (Object)((Object)VerticalQuality.LOW) + ": uses at max 2 columns per position. \n " + (Object)((Object)VerticalQuality.MEDIUM) + ": uses at max 4 columns per position. \n " + (Object)((Object)VerticalQuality.HIGH) + ": uses at max 8 columns per position. \n\n Lowest Quality: " + (Object)((Object)VerticalQuality.LOW) + " Highest Quality: " + (Object)((Object)VerticalQuality.HIGH);
                public static final MinDefaultMax<Integer> HORIZONTAL_SCALE_MIN_DEFAULT_MAX = new MinDefaultMax<Integer>(2, 12, 64);
                public static final String HORIZONTAL_SCALE_DESC = " This indicates how quickly fake chunks decrease in quality the further away they are. \n Higher settings will render higher quality fake chunks farther away, \n but will increase memory and GPU usage.";
                public static final HorizontalQuality HORIZONTAL_QUALITY_DEFAULT = HorizontalQuality.MEDIUM;
                public static final String HORIZONTAL_QUALITY_DESC = " This indicates how much farther away each drop in quality is. \n\n " + (Object)((Object)HorizontalQuality.LOWEST) + ": each drop in quality is the same distance away. \n " + (Object)((Object)HorizontalQuality.LOW) + ": each drop in quality is " + HorizontalQuality.LOW.quadraticBase + " times farther away. \n " + (Object)((Object)HorizontalQuality.MEDIUM) + ": each drop in quality is " + HorizontalQuality.MEDIUM.quadraticBase + " times farther away. \n " + (Object)((Object)HorizontalQuality.HIGH) + ": each drop in quality is " + HorizontalQuality.HIGH.quadraticBase + " times farther away. \n\n Lowest Quality: " + (Object)((Object)HorizontalQuality.LOWEST) + " Highest Quality: " + (Object)((Object)HorizontalQuality.HIGH);
                public static final DropoffQuality DROPOFF_QUALITY_DEFAULT = DropoffQuality.AUTO;
                public static final String DROPOFF_QUALITY_DESC = " This determines how lod level drop off will be done. \n\n " + (Object)((Object)DropoffQuality.SMOOTH_DROPOFF) + ": \n     The lod level is calculated for each point, making the drop off a smooth circle. \n " + (Object)((Object)DropoffQuality.PERFORMANCE_FOCUSED) + ": \n     One detail level for an entire region. Minimize CPU usage and \n     improve terrain refresh delay, especially for high Lod render distance. \n " + (Object)((Object)DropoffQuality.AUTO) + ": \n     Use " + (Object)((Object)DropoffQuality.SMOOTH_DROPOFF) + " for less then 128 Lod render distance, \n     or " + (Object)((Object)DropoffQuality.PERFORMANCE_FOCUSED) + " otherwise. \n";
                public static final MinDefaultMax<Integer> LOD_BIOME_BLENDING_MIN_DEFAULT_MAX = new MinDefaultMax<Integer>(0, 1, 7);
                public static final String LOD_BIOME_BLENDING_DESC = " This is the same as vanilla Biome Blending settings for Lod area. \n     Note that anything other than '0' will greatly effect Lod building time \n     and increase triangle count. The cost on chunk generation speed is also \n     quite large if set too high.\n\n     '0' equals to Vanilla Biome Blending of '1x1' or 'OFF', \n     '1' equals to Vanilla Biome Blending of '3x3', \n     '2' equals to Vanilla Biome Blending of '5x5'... \n";

                public HorizontalResolution getDrawResolution();

                public void setDrawResolution(HorizontalResolution var1);

                public int getLodChunkRenderDistance();

                public void setLodChunkRenderDistance(int var1);

                public VerticalQuality getVerticalQuality();

                public void setVerticalQuality(VerticalQuality var1);

                public int getHorizontalScale();

                public void setHorizontalScale(int var1);

                public HorizontalQuality getHorizontalQuality();

                public void setHorizontalQuality(HorizontalQuality var1);

                public DropoffQuality getDropoffQuality();

                public void setDropoffQuality(DropoffQuality var1);

                default public DropoffQuality getResolvedDropoffQuality() {
                    DropoffQuality dropoffQuality = this.getDropoffQuality();
                    if (dropoffQuality == DropoffQuality.AUTO) {
                        dropoffQuality = this.getLodChunkRenderDistance() < 128 ? DropoffQuality.SMOOTH_DROPOFF : DropoffQuality.PERFORMANCE_FOCUSED;
                    }
                    return dropoffQuality;
                }

                public int getLodBiomeBlending();

                public void setLodBiomeBlending(int var1);
            }
        }
    }
}

