/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.fabric;

import com.seibel.lod.core.api.ClientApi;
import com.seibel.lod.core.api.EventApi;
import com.seibel.lod.core.handlers.dependencyInjection.SingletonHandler;
import com.seibel.lod.core.wrapperInterfaces.config.ILodConfigWrapperSingleton;
import fabric.com.seibel.lod.common.wrappers.chunk.ChunkWrapper;
import fabric.com.seibel.lod.common.wrappers.world.DimensionTypeWrapper;
import fabric.com.seibel.lod.common.wrappers.world.WorldWrapper;
import fabric.com.seibel.lod.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import java.util.HashSet;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerWorldEvents;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_442;
import net.minecraft.class_4538;
import net.minecraft.server.MinecraftServer;

public class ClientProxy {
    private final EventApi eventApi = EventApi.INSTANCE;
    private final ClientApi clientApi = ClientApi.INSTANCE;
    public static Supplier<Boolean> isGenerationThreadChecker = null;
    private static final int[] KEY_TO_CHECK_FOR = new int[]{295, 297};
    HashSet<Integer> previousKeyDown = new HashSet();

    public void registerEvents() {
        ServerTickEvents.END_SERVER_TICK.register(this::serverTickEvent);
        ServerWorldEvents.LOAD.register((server, level) -> this.worldLoadEvent((class_1937)level));
        ServerWorldEvents.UNLOAD.register((server, level) -> this.worldUnloadEvent((class_1937)level));
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (client.field_1724 != null) {
                this.onKeyInput();
            }
        });
        isGenerationThreadChecker = BatchGenerationEnvironment::isCurrentThreadDistantGeneratorThread;
    }

    public void serverTickEvent(MinecraftServer server) {
        this.eventApi.serverTickEvent();
    }

    public void chunkLoadEvent(class_1936 level, class_2818 chunk) {
        this.clientApi.clientChunkLoadEvent(new ChunkWrapper((class_2791)chunk, (class_4538)level), WorldWrapper.getWorldWrapper(level));
    }

    public void worldSaveEvent() {
        this.eventApi.worldSaveEvent();
    }

    public void worldLoadEvent(class_1937 level) {
        if (class_310.method_1551().field_1755 instanceof class_442) {
            return;
        }
        if (level != null) {
            this.eventApi.worldLoadEvent(WorldWrapper.getWorldWrapper((class_1936)level));
        }
    }

    public void worldUnloadEvent(class_1937 level) {
        if (level != null) {
            this.eventApi.worldUnloadEvent(WorldWrapper.getWorldWrapper((class_1936)level));
        }
    }

    public void blockChangeEvent(class_1936 world, class_2338 pos) {
        ChunkWrapper chunk = new ChunkWrapper(world.method_22350(pos), (class_4538)world);
        DimensionTypeWrapper dimType = DimensionTypeWrapper.getDimensionTypeWrapper(world.method_8597());
        this.eventApi.blockChangeEvent(chunk, dimType);
    }

    public void onKeyInput() {
        ILodConfigWrapperSingleton CONFIG = SingletonHandler.get(ILodConfigWrapperSingleton.class);
        if (CONFIG.client().advanced().debugging().getDebugKeybindingsEnabled()) {
            HashSet<Integer> currectKeyDown = new HashSet<Integer>();
            for (int i = 65; i <= 90; ++i) {
                if (!class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)i)) continue;
                currectKeyDown.add(i);
            }
            for (int i : KEY_TO_CHECK_FOR) {
                if (!class_3675.method_15987((long)class_310.method_1551().method_22683().method_4490(), (int)i)) continue;
                currectKeyDown.add(i);
            }
            Object object = currectKeyDown.iterator();
            while (object.hasNext()) {
                int c = (Integer)object.next();
                if (this.previousKeyDown.contains(c)) continue;
                ClientApi.INSTANCE.keyPressedEvent(c);
            }
            this.previousKeyDown = currectKeyDown;
        }
    }
}

