/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge.fabric.api.client.networking.v1;

import com.seibel.lod.forge.fabric.impl.networking.client.ClientNetworkingImpl;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientHandshakePacketListenerImpl;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.PacketListener;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class ClientLoginNetworking {
    public static boolean registerGlobalReceiver(ResourceLocation channelName, LoginQueryRequestHandler queryHandler) {
        return ClientNetworkingImpl.LOGIN.registerGlobalReceiver(channelName, queryHandler);
    }

    @Nullable
    public static LoginQueryRequestHandler unregisterGlobalReceiver(ResourceLocation channelName) {
        return ClientNetworkingImpl.LOGIN.unregisterGlobalReceiver(channelName);
    }

    public static Set<ResourceLocation> getGlobalReceivers() {
        return ClientNetworkingImpl.LOGIN.getChannels();
    }

    public static boolean registerReceiver(ResourceLocation channelName, LoginQueryRequestHandler queryHandler) throws IllegalStateException {
        PacketListener packetListener;
        Connection connection = ClientNetworkingImpl.getLoginConnection();
        if (connection != null && (packetListener = connection.m_129538_()) instanceof ClientHandshakePacketListenerImpl) {
            return ClientNetworkingImpl.getAddon((ClientHandshakePacketListenerImpl)packetListener).registerChannel(channelName, queryHandler);
        }
        throw new IllegalStateException("Cannot register receiver while client is not logging in!");
    }

    @Nullable
    public static LoginQueryRequestHandler unregisterReceiver(ResourceLocation channelName) throws IllegalStateException {
        PacketListener packetListener;
        Connection connection = ClientNetworkingImpl.getLoginConnection();
        if (connection != null && (packetListener = connection.m_129538_()) instanceof ClientHandshakePacketListenerImpl) {
            return (LoginQueryRequestHandler)ClientNetworkingImpl.getAddon((ClientHandshakePacketListenerImpl)packetListener).unregisterChannel(channelName);
        }
        throw new IllegalStateException("Cannot unregister receiver while client is not logging in!");
    }

    private ClientLoginNetworking() {
    }

    @FunctionalInterface
    public static interface LoginQueryRequestHandler {
        public CompletableFuture<@Nullable FriendlyByteBuf> receive(Minecraft var1, ClientHandshakePacketListenerImpl var2, FriendlyByteBuf var3, Consumer<GenericFutureListener<? extends Future<? super Void>>> var4);
    }
}

