/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge.fabric.api.client.networking.v1;

import com.seibel.lod.forge.fabric.api.networking.v1.PacketSender;
import com.seibel.lod.forge.fabric.impl.networking.client.ClientNetworkingImpl;
import com.seibel.lod.forge.fabric.impl.networking.client.ClientPlayNetworkAddon;
import java.util.Objects;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class ClientPlayNetworking {
    public static boolean registerGlobalReceiver(ResourceLocation channelName, PlayChannelHandler channelHandler) {
        return ClientNetworkingImpl.PLAY.registerGlobalReceiver(channelName, channelHandler);
    }

    @Nullable
    public static PlayChannelHandler unregisterGlobalReceiver(ResourceLocation channelName) {
        return ClientNetworkingImpl.PLAY.unregisterGlobalReceiver(channelName);
    }

    public static Set<ResourceLocation> getGlobalReceivers() {
        return ClientNetworkingImpl.PLAY.getChannels();
    }

    public static boolean registerReceiver(ResourceLocation channelName, PlayChannelHandler channelHandler) {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.registerChannel(channelName, channelHandler);
        }
        throw new IllegalStateException("Cannot register receiver while not in game!");
    }

    @Nullable
    public static PlayChannelHandler unregisterReceiver(ResourceLocation channelName) throws IllegalStateException {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return (PlayChannelHandler)addon.unregisterChannel(channelName);
        }
        throw new IllegalStateException("Cannot unregister receiver while not in game!");
    }

    public static Set<ResourceLocation> getReceived() throws IllegalStateException {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.getReceivableChannels();
        }
        throw new IllegalStateException("Cannot get a list of channels the client can receive packets on while not in game!");
    }

    public static Set<ResourceLocation> getSendable() throws IllegalStateException {
        ClientPlayNetworkAddon addon = ClientNetworkingImpl.getClientPlayAddon();
        if (addon != null) {
            return addon.getSendableChannels();
        }
        throw new IllegalStateException("Cannot get a list of channels the server can receive packets on while not in game!");
    }

    public static boolean canSend(ResourceLocation channelName) throws IllegalArgumentException {
        if (Minecraft.m_91087_().m_91403_() != null) {
            return ClientNetworkingImpl.getAddon(Minecraft.m_91087_().m_91403_()).getSendableChannels().contains(channelName);
        }
        return false;
    }

    public static Packet<?> createC2SPacket(ResourceLocation channelName, FriendlyByteBuf buf) {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(buf, "Buf cannot be null");
        return ClientNetworkingImpl.createPlayC2SPacket(channelName, buf);
    }

    public static PacketSender getSender() throws IllegalStateException {
        if (Minecraft.m_91087_().m_91403_() != null) {
            return ClientNetworkingImpl.getAddon(Minecraft.m_91087_().m_91403_());
        }
        throw new IllegalStateException("Cannot get packet sender when not in game!");
    }

    public static void send(ResourceLocation channelName, FriendlyByteBuf buf) throws IllegalStateException {
        if (Minecraft.m_91087_().m_91403_() != null) {
            Minecraft.m_91087_().m_91403_().m_104955_(ClientPlayNetworking.createC2SPacket(channelName, buf));
            return;
        }
        throw new IllegalStateException("Cannot send packets when not in game!");
    }

    private ClientPlayNetworking() {
    }

    @FunctionalInterface
    public static interface PlayChannelHandler {
        public void receive(Minecraft var1, ClientPacketListener var2, FriendlyByteBuf var3, PacketSender var4);
    }
}

