/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge.fabric.api.event;

import com.seibel.lod.forge.fabric.api.event.Event;
import com.seibel.lod.forge.fabric.impl.base.event.EventFactoryImpl;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;

public final class EventFactory {
    private static boolean profilingEnabled = true;

    private EventFactory() {
    }

    public static boolean isProfilingEnabled() {
        return profilingEnabled;
    }

    public static void invalidate() {
        EventFactoryImpl.invalidate();
    }

    public static <T> Event<T> createArrayBacked(Class<? super T> type, Function<T[], T> invokerFactory) {
        return EventFactoryImpl.createArrayBacked(type, invokerFactory);
    }

    public static <T> Event<T> createArrayBacked(Class<T> type, T emptyInvoker, Function<T[], T> invokerFactory) {
        return EventFactory.createArrayBacked(type, listeners -> {
            if (((Object[])listeners).length == 0) {
                return emptyInvoker;
            }
            if (((Object[])listeners).length == 1) {
                return listeners[0];
            }
            return invokerFactory.apply((T[])listeners);
        });
    }

    public static <T> Event<T> createWithPhases(Class<? super T> type, Function<T[], T> invokerFactory, ResourceLocation ... defaultPhases) {
        EventFactoryImpl.ensureContainsDefault(defaultPhases);
        EventFactoryImpl.ensureNoDuplicates(defaultPhases);
        Event<T> event = EventFactory.createArrayBacked(type, invokerFactory);
        for (int i = 1; i < defaultPhases.length; ++i) {
            event.addPhaseOrdering(defaultPhases[i - 1], defaultPhases[i]);
        }
        return event;
    }

    public static String getHandlerName(Object handler) {
        return handler.getClass().getName();
    }
}

