/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge.fabric.api.networking.v1;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Objects;
import net.minecraft.network.FriendlyByteBuf;

public final class FutureListeners {
    public static ChannelFutureListener free(FriendlyByteBuf buf) {
        Objects.requireNonNull(buf, "PacketByteBuf cannot be null");
        return future -> {
            if (!FutureListeners.isLocalChannel(future.channel())) {
                buf.release();
            }
        };
    }

    public static boolean isLocalChannel(Channel channel) {
        return channel instanceof LocalServerChannel || channel instanceof LocalChannel;
    }

    public static <A extends Future<? super Void>, B extends Future<? super Void>> GenericFutureListener<? extends Future<? super Void>> union(GenericFutureListener<A> first, GenericFutureListener<B> second) {
        if (first == null && second == null) {
            return future -> {};
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        return future -> {
            first.operationComplete(future);
            second.operationComplete(future);
        };
    }

    private FutureListeners() {
    }
}

