/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge.fabric.api.networking.v1;

import com.seibel.lod.forge.fabric.api.networking.v1.PacketSender;
import com.seibel.lod.forge.fabric.impl.networking.server.ServerNetworkingImpl;
import com.seibel.lod.forge.mixins.fabric.mixin.networking.accessor.ServerLoginNetworkHandlerAccessor;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Future;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import org.jetbrains.annotations.Nullable;

public final class ServerLoginNetworking {
    public static boolean registerGlobalReceiver(ResourceLocation channelName, LoginQueryResponseHandler channelHandler) {
        return ServerNetworkingImpl.LOGIN.registerGlobalReceiver(channelName, channelHandler);
    }

    @Nullable
    public static LoginQueryResponseHandler unregisterGlobalReceiver(ResourceLocation channelName) {
        return ServerNetworkingImpl.LOGIN.unregisterGlobalReceiver(channelName);
    }

    public static Set<ResourceLocation> getGlobalReceivers() {
        return ServerNetworkingImpl.LOGIN.getChannels();
    }

    public static boolean registerReceiver(ServerLoginPacketListenerImpl networkHandler, ResourceLocation channelName, LoginQueryResponseHandler responseHandler) {
        Objects.requireNonNull(networkHandler, "Network handler cannot be null");
        return ServerNetworkingImpl.getAddon(networkHandler).registerChannel(channelName, responseHandler);
    }

    @Nullable
    public static LoginQueryResponseHandler unregisterReceiver(ServerLoginPacketListenerImpl networkHandler, ResourceLocation channelName) {
        Objects.requireNonNull(networkHandler, "Network handler cannot be null");
        return (LoginQueryResponseHandler)ServerNetworkingImpl.getAddon(networkHandler).unregisterChannel(channelName);
    }

    public static MinecraftServer getServer(ServerLoginPacketListenerImpl handler) {
        Objects.requireNonNull(handler, "Network handler cannot be null");
        return ((ServerLoginNetworkHandlerAccessor)handler).getServer();
    }

    private ServerLoginNetworking() {
    }

    @FunctionalInterface
    public static interface LoginQueryResponseHandler {
        public void receive(MinecraftServer var1, ServerLoginPacketListenerImpl var2, boolean var3, FriendlyByteBuf var4, LoginSynchronizer var5, PacketSender var6);
    }

    @FunctionalInterface
    public static interface LoginSynchronizer {
        public void waitFor(Future<?> var1);
    }
}

