/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge.fabric.api.networking.v1;

import com.seibel.lod.forge.fabric.api.networking.v1.PacketSender;
import com.seibel.lod.forge.fabric.impl.networking.server.ServerNetworkingImpl;
import java.util.Objects;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import org.jetbrains.annotations.Nullable;

public final class ServerPlayNetworking {
    public static boolean registerGlobalReceiver(ResourceLocation channelName, PlayChannelHandler channelHandler) {
        return ServerNetworkingImpl.PLAY.registerGlobalReceiver(channelName, channelHandler);
    }

    @Nullable
    public static PlayChannelHandler unregisterGlobalReceiver(ResourceLocation channelName) {
        return ServerNetworkingImpl.PLAY.unregisterGlobalReceiver(channelName);
    }

    public static Set<ResourceLocation> getGlobalReceivers() {
        return ServerNetworkingImpl.PLAY.getChannels();
    }

    public static boolean registerReceiver(ServerGamePacketListenerImpl networkHandler, ResourceLocation channelName, PlayChannelHandler channelHandler) {
        Objects.requireNonNull(networkHandler, "Network handler cannot be null");
        return ServerNetworkingImpl.getAddon(networkHandler).registerChannel(channelName, channelHandler);
    }

    @Nullable
    public static PlayChannelHandler unregisterReceiver(ServerGamePacketListenerImpl networkHandler, ResourceLocation channelName) {
        Objects.requireNonNull(networkHandler, "Network handler cannot be null");
        return (PlayChannelHandler)ServerNetworkingImpl.getAddon(networkHandler).unregisterChannel(channelName);
    }

    public static Set<ResourceLocation> getReceived(ServerPlayer player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getReceived(player.f_8906_);
    }

    public static Set<ResourceLocation> getReceived(ServerGamePacketListenerImpl handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getReceivableChannels();
    }

    public static Set<ResourceLocation> getSendable(ServerPlayer player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getSendable(player.f_8906_);
    }

    public static Set<ResourceLocation> getSendable(ServerGamePacketListenerImpl handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels();
    }

    public static boolean canSend(ServerPlayer player, ResourceLocation channelName) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.canSend(player.f_8906_, channelName);
    }

    public static boolean canSend(ServerGamePacketListenerImpl handler, ResourceLocation channelName) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        return ServerNetworkingImpl.getAddon(handler).getSendableChannels().contains(channelName);
    }

    public static Packet<?> createS2CPacket(ResourceLocation channelName, FriendlyByteBuf buf) {
        Objects.requireNonNull(channelName, "Channel cannot be null");
        Objects.requireNonNull(buf, "Buf cannot be null");
        return ServerNetworkingImpl.createPlayC2SPacket(channelName, buf);
    }

    public static PacketSender getSender(ServerPlayer player) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        return ServerPlayNetworking.getSender(player.f_8906_);
    }

    public static PacketSender getSender(ServerGamePacketListenerImpl handler) {
        Objects.requireNonNull(handler, "Server play network handler cannot be null");
        return ServerNetworkingImpl.getAddon(handler);
    }

    public static void send(ServerPlayer player, ResourceLocation channelName, FriendlyByteBuf buf) {
        Objects.requireNonNull(player, "Server player entity cannot be null");
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(buf, "Packet byte buf cannot be null");
        player.f_8906_.m_141995_(ServerPlayNetworking.createS2CPacket(channelName, buf));
    }

    public static MinecraftServer getServer(ServerGamePacketListenerImpl handler) {
        Objects.requireNonNull(handler, "Network handler cannot be null");
        return handler.f_9743_.f_8924_;
    }

    private ServerPlayNetworking() {
    }

    @FunctionalInterface
    public static interface PlayChannelHandler {
        public void receive(MinecraftServer var1, ServerPlayer var2, ServerGamePacketListenerImpl var3, FriendlyByteBuf var4, PacketSender var5);
    }
}

