/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge.fabric.impl.networking;

import com.seibel.lod.forge.fabric.api.networking.v1.PacketByteBufs;
import com.seibel.lod.forge.fabric.api.networking.v1.PacketSender;
import com.seibel.lod.forge.fabric.impl.networking.AbstractNetworkAddon;
import com.seibel.lod.forge.fabric.impl.networking.ChannelInfoHolder;
import com.seibel.lod.forge.fabric.impl.networking.GlobalReceiverRegistry;
import com.seibel.lod.forge.fabric.impl.networking.NetworkingImpl;
import io.netty.buffer.ByteBuf;
import io.netty.util.AsciiString;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.ResourceLocationException;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractChanneledNetworkAddon<H>
extends AbstractNetworkAddon<H>
implements PacketSender {
    protected final Connection connection;
    protected final GlobalReceiverRegistry<H> receiver;
    protected final Set<ResourceLocation> sendableChannels;
    protected final Set<ResourceLocation> sendableChannelsView;

    protected AbstractChanneledNetworkAddon(GlobalReceiverRegistry<H> receiver, Connection connection, String description) {
        this(receiver, connection, new HashSet<ResourceLocation>(), description);
    }

    protected AbstractChanneledNetworkAddon(GlobalReceiverRegistry<H> receiver, Connection connection, Set<ResourceLocation> sendableChannels, String description) {
        super(receiver, description);
        this.connection = connection;
        this.receiver = receiver;
        this.sendableChannels = sendableChannels;
        this.sendableChannelsView = Collections.unmodifiableSet(sendableChannels);
    }

    public abstract void lateInit();

    protected void registerPendingChannels(ChannelInfoHolder holder) {
        Collection<ResourceLocation> pending = holder.getPendingChannelsNames();
        if (!pending.isEmpty()) {
            this.register(new ArrayList<ResourceLocation>(pending));
            pending.clear();
        }
    }

    protected boolean handle(ResourceLocation channelName, FriendlyByteBuf originalBuf) {
        this.logger.debug("Handling inbound packet from channel with name \"{}\"", (Object)channelName);
        if (NetworkingImpl.REGISTER_CHANNEL.equals((Object)channelName)) {
            this.receiveRegistration(true, PacketByteBufs.slice((ByteBuf)originalBuf));
            return true;
        }
        if (NetworkingImpl.UNREGISTER_CHANNEL.equals((Object)channelName)) {
            this.receiveRegistration(false, PacketByteBufs.slice((ByteBuf)originalBuf));
            return true;
        }
        @Nullable H handler = this.getHandler(channelName);
        if (handler == null) {
            return false;
        }
        FriendlyByteBuf buf = PacketByteBufs.slice((ByteBuf)originalBuf);
        try {
            this.receive(handler, buf);
        }
        catch (Throwable ex) {
            this.logger.error("Encountered exception while handling in channel with name \"{}\"", (Object)channelName, (Object)ex);
            throw ex;
        }
        return true;
    }

    protected abstract void receive(H var1, FriendlyByteBuf var2);

    protected void sendInitialChannelRegistrationPacket() {
        FriendlyByteBuf buf = this.createRegistrationPacket(this.getReceivableChannels());
        if (buf != null) {
            this.sendPacket(NetworkingImpl.REGISTER_CHANNEL, buf);
        }
    }

    @Nullable
    protected FriendlyByteBuf createRegistrationPacket(Collection<ResourceLocation> channels) {
        if (channels.isEmpty()) {
            return null;
        }
        FriendlyByteBuf buf = PacketByteBufs.create();
        boolean first = true;
        for (ResourceLocation channel : channels) {
            if (first) {
                first = false;
            } else {
                buf.writeByte(0);
            }
            buf.writeBytes(channel.toString().getBytes(StandardCharsets.US_ASCII));
        }
        return buf;
    }

    protected void receiveRegistration(boolean register, FriendlyByteBuf buf) {
        ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>();
        StringBuilder active = new StringBuilder();
        while (buf.isReadable()) {
            byte b = buf.readByte();
            if (b != 0) {
                active.append(AsciiString.b2c((byte)b));
                continue;
            }
            this.addId(ids, active);
            active = new StringBuilder();
        }
        this.addId(ids, active);
        this.schedule(register ? () -> this.register(ids) : () -> this.unregister(ids));
    }

    void register(List<ResourceLocation> ids) {
        this.sendableChannels.addAll(ids);
        this.invokeRegisterEvent(ids);
    }

    void unregister(List<ResourceLocation> ids) {
        this.sendableChannels.removeAll(ids);
        this.invokeUnregisterEvent(ids);
    }

    @Override
    public void sendPacket(Packet<?> packet) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        this.connection.m_129512_(packet);
    }

    @Override
    public void sendPacket(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> callback) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        this.connection.m_129514_(packet, callback);
    }

    protected abstract void schedule(Runnable var1);

    protected abstract void invokeRegisterEvent(List<ResourceLocation> var1);

    protected abstract void invokeUnregisterEvent(List<ResourceLocation> var1);

    private void addId(List<ResourceLocation> ids, StringBuilder sb) {
        String literal = sb.toString();
        try {
            ids.add(new ResourceLocation(literal));
        }
        catch (ResourceLocationException ex) {
            this.logger.warn("Received invalid channel identifier \"{}\" from connection {}", (Object)literal, (Object)this.connection);
        }
    }

    public Set<ResourceLocation> getSendableChannels() {
        return this.sendableChannelsView;
    }
}

