/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge.fabric.impl.networking;

import com.seibel.lod.forge.fabric.impl.networking.GlobalReceiverRegistry;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractNetworkAddon<H> {
    protected final GlobalReceiverRegistry<H> receiver;
    protected final Logger logger;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<ResourceLocation, H> handlers = new HashMap<ResourceLocation, H>();
    private final AtomicBoolean disconnected = new AtomicBoolean();

    protected AbstractNetworkAddon(GlobalReceiverRegistry<H> receiver, String description) {
        this.receiver = receiver;
        this.logger = LogManager.getLogger((String)description);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public H getHandler(ResourceLocation channel) {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            H h = this.handlers.get(channel);
            return h;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerChannel(ResourceLocation channelName, H handler) {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(handler, "Packet handler cannot be null");
        if (this.isReservedChannel(channelName)) {
            throw new IllegalArgumentException(String.format("Cannot register handler for reserved channel with name \"%s\"", channelName));
        }
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            boolean replaced;
            boolean bl = replaced = this.handlers.putIfAbsent(channelName, handler) == null;
            if (replaced) {
                this.handleRegistration(channelName);
            }
            boolean bl2 = replaced;
            return bl2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public H unregisterChannel(ResourceLocation channelName) {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        if (this.isReservedChannel(channelName)) {
            throw new IllegalArgumentException(String.format("Cannot register handler for reserved channel with name \"%s\"", channelName));
        }
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            H removed = this.handlers.remove(channelName);
            if (removed != null) {
                this.handleUnregistration(channelName);
            }
            H h = removed;
            return h;
        }
        finally {
            lock.unlock();
        }
    }

    public Set<ResourceLocation> getReceivableChannels() {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            HashSet<ResourceLocation> hashSet = new HashSet<ResourceLocation>(this.handlers.keySet());
            return hashSet;
        }
        finally {
            lock.unlock();
        }
    }

    protected abstract void handleRegistration(ResourceLocation var1);

    protected abstract void handleUnregistration(ResourceLocation var1);

    public final void handleDisconnect() {
        if (this.disconnected.compareAndSet(false, true)) {
            this.invokeDisconnectEvent();
        }
    }

    protected abstract void invokeDisconnectEvent();

    protected abstract boolean isReservedChannel(ResourceLocation var1);
}

