/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge.fabric.impl.networking;

import com.seibel.lod.forge.fabric.impl.networking.AbstractNetworkAddon;
import com.seibel.lod.forge.fabric.impl.networking.NetworkingImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class GlobalReceiverRegistry<H> {
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Map<ResourceLocation, H> handlers;
    private final Set<AbstractNetworkAddon<H>> trackedAddons = new HashSet<AbstractNetworkAddon<H>>();

    public GlobalReceiverRegistry() {
        this(new HashMap());
    }

    public GlobalReceiverRegistry(Map<ResourceLocation, H> map) {
        this.handlers = map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public H getHandler(ResourceLocation channelName) {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            H h = this.handlers.get(channelName);
            return h;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean registerGlobalReceiver(ResourceLocation channelName, H handler) {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        Objects.requireNonNull(handler, "Channel handler cannot be null");
        if (NetworkingImpl.isReservedPlayChannel(channelName)) {
            throw new IllegalArgumentException(String.format("Cannot register handler for reserved channel with name \"%s\"", channelName));
        }
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            boolean replaced;
            boolean bl = replaced = this.handlers.putIfAbsent(channelName, handler) == null;
            if (!replaced) {
                this.handleRegistration(channelName, handler);
            }
            boolean bl2 = replaced;
            return bl2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public H unregisterGlobalReceiver(ResourceLocation channelName) {
        Objects.requireNonNull(channelName, "Channel name cannot be null");
        if (NetworkingImpl.isReservedPlayChannel(channelName)) {
            throw new IllegalArgumentException(String.format("Cannot unregister packet handler for reserved channel with name \"%s\"", channelName));
        }
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            H removed = this.handlers.remove(channelName);
            if (removed != null) {
                this.handleUnregistration(channelName);
            }
            H h = removed;
            return h;
        }
        finally {
            lock.unlock();
        }
    }

    public Map<ResourceLocation, H> getHandlers() {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            HashMap<ResourceLocation, H> hashMap = new HashMap<ResourceLocation, H>(this.handlers);
            return hashMap;
        }
        finally {
            lock.unlock();
        }
    }

    public Set<ResourceLocation> getChannels() {
        Lock lock = this.lock.readLock();
        lock.lock();
        try {
            HashSet<ResourceLocation> hashSet = new HashSet<ResourceLocation>(this.handlers.keySet());
            return hashSet;
        }
        finally {
            lock.unlock();
        }
    }

    public void startSession(AbstractNetworkAddon<H> addon) {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            this.trackedAddons.add(addon);
        }
        finally {
            lock.unlock();
        }
    }

    public void endSession(AbstractNetworkAddon<H> addon) {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            this.trackedAddons.remove(addon);
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleRegistration(ResourceLocation channelName, H handler) {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            for (AbstractNetworkAddon<H> addon : this.trackedAddons) {
                addon.registerChannel(channelName, handler);
            }
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleUnregistration(ResourceLocation channelName) {
        Lock lock = this.lock.writeLock();
        lock.lock();
        try {
            for (AbstractNetworkAddon<H> addon : this.trackedAddons) {
                addon.unregisterChannel(channelName);
            }
        }
        finally {
            lock.unlock();
        }
    }
}

