/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge.fabric.impl.networking;

import com.seibel.lod.forge.fabric.api.networking.v1.PacketByteBufs;
import com.seibel.lod.forge.fabric.api.networking.v1.ServerLoginConnectionEvents;
import com.seibel.lod.forge.fabric.api.networking.v1.ServerLoginNetworking;
import com.seibel.lod.forge.fabric.api.networking.v1.ServerPlayNetworking;
import com.seibel.lod.forge.fabric.impl.networking.ChannelInfoHolder;
import java.util.ArrayList;
import java.util.Set;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class NetworkingImpl {
    public static final String MOD_ID = "fabric-networking-api-v1";
    public static final Logger LOGGER = LogManager.getLogger((String)"fabric-networking-api-v1");
    public static final ResourceLocation REGISTER_CHANNEL = new ResourceLocation("minecraft", "register");
    public static final ResourceLocation UNREGISTER_CHANNEL = new ResourceLocation("minecraft", "unregister");
    public static final ResourceLocation EARLY_REGISTRATION_CHANNEL = new ResourceLocation("fabric-networking-api-v1", "early_registration");

    public static void init() {
        ServerLoginConnectionEvents.QUERY_START.register((handler, server, sender, synchronizer) -> {
            FriendlyByteBuf buf = PacketByteBufs.create();
            Set<ResourceLocation> channelsNames = ServerPlayNetworking.getGlobalReceivers();
            buf.m_130130_(channelsNames.size());
            for (ResourceLocation id : channelsNames) {
                buf.m_130085_(id);
            }
            sender.sendPacket(EARLY_REGISTRATION_CHANNEL, buf);
            LOGGER.debug("Sent accepted channels to the client for \"{}\"", (Object)handler.m_10056_());
        });
        ServerLoginNetworking.registerGlobalReceiver(EARLY_REGISTRATION_CHANNEL, (server, handler, understood, buf, synchronizer, sender) -> {
            if (!understood) {
                return;
            }
            int n = buf.m_130242_();
            ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>(n);
            for (int i = 0; i < n; ++i) {
                ids.add(buf.m_130281_());
            }
            ((ChannelInfoHolder)handler.m_6198_()).getPendingChannelsNames().addAll(ids);
            LOGGER.debug("Received accepted channels from the client for \"{}\"", (Object)handler.m_10056_());
        });
    }

    public static boolean isReservedPlayChannel(ResourceLocation channelName) {
        return channelName.equals((Object)REGISTER_CHANNEL) || channelName.equals((Object)UNREGISTER_CHANNEL);
    }
}

