/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge.fabric.impl.networking.client;

import com.seibel.lod.forge.fabric.api.client.networking.v1.ClientLoginConnectionEvents;
import com.seibel.lod.forge.fabric.api.client.networking.v1.ClientLoginNetworking;
import com.seibel.lod.forge.fabric.api.networking.v1.FutureListeners;
import com.seibel.lod.forge.fabric.api.networking.v1.PacketByteBufs;
import com.seibel.lod.forge.fabric.impl.networking.AbstractNetworkAddon;
import com.seibel.lod.forge.fabric.impl.networking.client.ClientNetworkingImpl;
import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientHandshakePacketListenerImpl;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryPacket;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class ClientLoginNetworkAddon
extends AbstractNetworkAddon<ClientLoginNetworking.LoginQueryRequestHandler> {
    private final ClientHandshakePacketListenerImpl handler;
    private final Minecraft client;
    private boolean firstResponse = true;

    public ClientLoginNetworkAddon(ClientHandshakePacketListenerImpl handler, Minecraft client) {
        super(ClientNetworkingImpl.LOGIN, "ClientLoginNetworkAddon for Client");
        this.handler = handler;
        this.client = client;
        ClientLoginConnectionEvents.INIT.invoker().onLoginStart(this.handler, this.client);
        this.receiver.startSession(this);
    }

    public boolean handlePacket(ClientboundCustomQueryPacket packet) {
        return this.handlePacket(packet.m_134755_(), packet.m_179811_(), packet.m_179812_());
    }

    private boolean handlePacket(int queryId, ResourceLocation channelName, FriendlyByteBuf originalBuf) {
        ClientLoginNetworking.LoginQueryRequestHandler handler;
        this.logger.debug("Handling inbound login response with id {} and channel with name {}", (Object)queryId, (Object)channelName);
        if (this.firstResponse) {
            for (Map.Entry<ResourceLocation, ClientLoginNetworking.LoginQueryRequestHandler> entry : ClientNetworkingImpl.LOGIN.getHandlers().entrySet()) {
                ClientLoginNetworking.registerReceiver(entry.getKey(), entry.getValue());
            }
            ClientLoginConnectionEvents.QUERY_START.invoker().onLoginQueryStart(this.handler, this.client);
            this.firstResponse = false;
        }
        if ((handler = (ClientLoginNetworking.LoginQueryRequestHandler)this.getHandler(channelName)) == null) {
            return false;
        }
        FriendlyByteBuf buf = PacketByteBufs.slice((ByteBuf)originalBuf);
        ArrayList futureListeners = new ArrayList();
        try {
            CompletableFuture<@Nullable FriendlyByteBuf> future = handler.receive(this.client, this.handler, buf, futureListeners::add);
            future.thenAccept(result -> {
                ServerboundCustomQueryPacket packet = new ServerboundCustomQueryPacket(queryId, result);
                GenericFutureListener<Future<Void>> listener = null;
                for (GenericFutureListener each : futureListeners) {
                    listener = FutureListeners.union(listener, each);
                }
                this.handler.m_6198_().m_129514_((Packet)packet, listener);
            });
        }
        catch (Throwable ex) {
            this.logger.error("Encountered exception while handling in channel with name \"{}\"", (Object)channelName, (Object)ex);
            throw ex;
        }
        return true;
    }

    @Override
    protected void handleRegistration(ResourceLocation channelName) {
    }

    @Override
    protected void handleUnregistration(ResourceLocation channelName) {
    }

    @Override
    protected void invokeDisconnectEvent() {
        ClientLoginConnectionEvents.DISCONNECT.invoker().onLoginDisconnect(this.handler, this.client);
        this.receiver.endSession(this);
    }

    public void handlePlayTransition() {
        this.receiver.endSession(this);
    }

    @Override
    protected boolean isReservedChannel(ResourceLocation channelName) {
        return false;
    }
}

