/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge.fabric.impl.networking.client;

import com.seibel.lod.forge.fabric.api.client.networking.v1.ClientLoginNetworking;
import com.seibel.lod.forge.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import com.seibel.lod.forge.fabric.api.client.networking.v1.ClientPlayNetworking;
import com.seibel.lod.forge.fabric.api.networking.v1.PacketByteBufs;
import com.seibel.lod.forge.fabric.impl.networking.ChannelInfoHolder;
import com.seibel.lod.forge.fabric.impl.networking.GlobalReceiverRegistry;
import com.seibel.lod.forge.fabric.impl.networking.NetworkHandlerExtensions;
import com.seibel.lod.forge.fabric.impl.networking.NetworkingImpl;
import com.seibel.lod.forge.fabric.impl.networking.client.ClientLoginNetworkAddon;
import com.seibel.lod.forge.fabric.impl.networking.client.ClientPlayNetworkAddon;
import com.seibel.lod.forge.mixins.fabric.mixin.networking.accessor.ConnectScreenAccessor;
import com.seibel.lod.forge.mixins.fabric.mixin.networking.accessor.MinecraftClientAccessor;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.ConnectScreen;
import net.minecraft.client.multiplayer.ClientHandshakePacketListenerImpl;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.Nullable;

public final class ClientNetworkingImpl {
    public static final GlobalReceiverRegistry<ClientLoginNetworking.LoginQueryRequestHandler> LOGIN = new GlobalReceiverRegistry();
    public static final GlobalReceiverRegistry<ClientPlayNetworking.PlayChannelHandler> PLAY = new GlobalReceiverRegistry();
    private static ClientPlayNetworkAddon currentPlayAddon;

    public static ClientPlayNetworkAddon getAddon(ClientPacketListener handler) {
        return (ClientPlayNetworkAddon)((NetworkHandlerExtensions)handler).getAddon();
    }

    public static ClientLoginNetworkAddon getAddon(ClientHandshakePacketListenerImpl handler) {
        return (ClientLoginNetworkAddon)((NetworkHandlerExtensions)handler).getAddon();
    }

    public static Packet<?> createPlayC2SPacket(ResourceLocation channelName, FriendlyByteBuf buf) {
        return new ServerboundCustomPayloadPacket(channelName, buf);
    }

    @Nullable
    public static Connection getLoginConnection() {
        Connection connection = ((MinecraftClientAccessor)Minecraft.m_91087_()).getConnection();
        if (connection != null) {
            return connection;
        }
        if (Minecraft.m_91087_().f_91080_ instanceof ConnectScreen) {
            return ((ConnectScreenAccessor)Minecraft.m_91087_().f_91080_).getConnection();
        }
        return null;
    }

    @Nullable
    public static ClientPlayNetworkAddon getClientPlayAddon() {
        if (Minecraft.m_91087_().m_91403_() != null) {
            currentPlayAddon = null;
            return ClientNetworkingImpl.getAddon(Minecraft.m_91087_().m_91403_());
        }
        if (currentPlayAddon != null) {
            return currentPlayAddon;
        }
        return null;
    }

    public static void setClientPlayAddon(ClientPlayNetworkAddon addon) {
        currentPlayAddon = addon;
    }

    public static void clientInit() {
        ClientPlayConnectionEvents.DISCONNECT.register((handler, client) -> {
            currentPlayAddon = null;
        });
        ClientLoginNetworking.registerGlobalReceiver(NetworkingImpl.EARLY_REGISTRATION_CHANNEL, (client, handler, buf, listenerAdder) -> {
            int n = buf.m_130242_();
            ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>(n);
            for (int i = 0; i < n; ++i) {
                ids.add(buf.m_130281_());
            }
            ((ChannelInfoHolder)handler.m_6198_()).getPendingChannelsNames().addAll(ids);
            NetworkingImpl.LOGGER.debug("Received accepted channels from the server");
            FriendlyByteBuf response = PacketByteBufs.create();
            Set<ResourceLocation> channels = ClientPlayNetworking.getGlobalReceivers();
            response.m_130130_(channels.size());
            for (ResourceLocation id : channels) {
                response.m_130085_(id);
            }
            NetworkingImpl.LOGGER.debug("Sent accepted channels to the server");
            return CompletableFuture.completedFuture(response);
        });
    }
}

