/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge.fabric.impl.networking.client;

import com.seibel.lod.forge.fabric.api.client.networking.v1.C2SPlayChannelEvents;
import com.seibel.lod.forge.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import com.seibel.lod.forge.fabric.api.client.networking.v1.ClientPlayNetworking;
import com.seibel.lod.forge.fabric.impl.networking.AbstractChanneledNetworkAddon;
import com.seibel.lod.forge.fabric.impl.networking.ChannelInfoHolder;
import com.seibel.lod.forge.fabric.impl.networking.NetworkingImpl;
import com.seibel.lod.forge.fabric.impl.networking.client.ClientNetworkingImpl;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;

public final class ClientPlayNetworkAddon
extends AbstractChanneledNetworkAddon<ClientPlayNetworking.PlayChannelHandler> {
    private final ClientPacketListener handler;
    private final Minecraft client;
    private boolean sentInitialRegisterPacket;

    public ClientPlayNetworkAddon(ClientPacketListener handler, Minecraft client) {
        super(ClientNetworkingImpl.PLAY, handler.m_6198_(), "ClientPlayNetworkAddon for " + handler.m_105144_().getName());
        this.handler = handler;
        this.client = client;
        this.registerPendingChannels((ChannelInfoHolder)this.connection);
        this.receiver.startSession(this);
    }

    @Override
    public void lateInit() {
        for (Map.Entry entry : this.receiver.getHandlers().entrySet()) {
            this.registerChannel(entry.getKey(), (ClientPlayNetworking.PlayChannelHandler)entry.getValue());
        }
        ClientPlayConnectionEvents.INIT.invoker().onPlayInit(this.handler, this.client);
    }

    public void onServerReady() {
        ClientPlayConnectionEvents.JOIN.invoker().onPlayReady(this.handler, this, this.client);
        this.sendInitialChannelRegistrationPacket();
        this.sentInitialRegisterPacket = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(ClientboundCustomPayloadPacket packet) {
        if (this.client.m_18695_()) {
            return false;
        }
        FriendlyByteBuf buf = packet.m_132045_();
        try {
            boolean bl = this.handle(packet.m_132042_(), buf);
            return bl;
        }
        finally {
            buf.release();
        }
    }

    @Override
    protected void receive(ClientPlayNetworking.PlayChannelHandler handler, FriendlyByteBuf buf) {
        handler.receive(this.client, this.handler, buf, this);
    }

    @Override
    protected void schedule(Runnable task) {
        Minecraft.m_91087_().execute(task);
    }

    @Override
    public Packet<?> createPacket(ResourceLocation channelName, FriendlyByteBuf buf) {
        return ClientPlayNetworking.createC2SPacket(channelName, buf);
    }

    @Override
    protected void invokeRegisterEvent(List<ResourceLocation> ids) {
        C2SPlayChannelEvents.REGISTER.invoker().onChannelRegister(this.handler, this, this.client, ids);
    }

    @Override
    protected void invokeUnregisterEvent(List<ResourceLocation> ids) {
        C2SPlayChannelEvents.UNREGISTER.invoker().onChannelUnregister(this.handler, this, this.client, ids);
    }

    @Override
    protected void handleRegistration(ResourceLocation channelName) {
        FriendlyByteBuf buf;
        if (this.sentInitialRegisterPacket && (buf = this.createRegistrationPacket(Collections.singleton(channelName))) != null) {
            this.sendPacket(NetworkingImpl.REGISTER_CHANNEL, buf);
        }
    }

    @Override
    protected void handleUnregistration(ResourceLocation channelName) {
        FriendlyByteBuf buf;
        if (this.sentInitialRegisterPacket && (buf = this.createRegistrationPacket(Collections.singleton(channelName))) != null) {
            this.sendPacket(NetworkingImpl.UNREGISTER_CHANNEL, buf);
        }
    }

    @Override
    protected void invokeDisconnectEvent() {
        ClientPlayConnectionEvents.DISCONNECT.invoker().onPlayDisconnect(this.handler, this.client);
        this.receiver.endSession(this);
    }

    @Override
    protected boolean isReservedChannel(ResourceLocation channelName) {
        return NetworkingImpl.isReservedPlayChannel(channelName);
    }
}

