/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge.fabric.impl.networking.server;

import com.seibel.lod.forge.fabric.api.networking.v1.PacketByteBufs;
import com.seibel.lod.forge.fabric.api.networking.v1.PacketSender;
import com.seibel.lod.forge.fabric.api.networking.v1.ServerLoginConnectionEvents;
import com.seibel.lod.forge.fabric.api.networking.v1.ServerLoginNetworking;
import com.seibel.lod.forge.fabric.impl.networking.AbstractNetworkAddon;
import com.seibel.lod.forge.fabric.impl.networking.server.QueryIdFactory;
import com.seibel.lod.forge.fabric.impl.networking.server.ServerNetworkingImpl;
import com.seibel.lod.forge.mixins.fabric.mixin.networking.accessor.LoginQueryResponseC2SPacketAccessor;
import com.seibel.lod.forge.mixins.fabric.mixin.networking.accessor.ServerLoginNetworkHandlerAccessor;
import io.netty.buffer.ByteBuf;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ClientboundLoginCompressionPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import org.jetbrains.annotations.Nullable;

public final class ServerLoginNetworkAddon
extends AbstractNetworkAddon<ServerLoginNetworking.LoginQueryResponseHandler>
implements PacketSender {
    private final Connection connection;
    private final ServerLoginPacketListenerImpl handler;
    private final MinecraftServer server;
    private final QueryIdFactory queryIdFactory;
    private final Collection<java.util.concurrent.Future<?>> waits = new ConcurrentLinkedQueue();
    private final Map<Integer, ResourceLocation> channels = new ConcurrentHashMap<Integer, ResourceLocation>();
    private boolean firstQueryTick = true;

    public ServerLoginNetworkAddon(ServerLoginPacketListenerImpl handler) {
        super(ServerNetworkingImpl.LOGIN, "ServerLoginNetworkAddon for " + handler.m_10056_());
        this.connection = handler.f_10013_;
        this.handler = handler;
        this.server = ((ServerLoginNetworkHandlerAccessor)handler).getServer();
        this.queryIdFactory = QueryIdFactory.create();
        ServerLoginConnectionEvents.INIT.invoker().onLoginInit(handler, this.server);
        this.receiver.startSession(this);
    }

    public boolean queryTick() {
        if (this.firstQueryTick) {
            this.sendCompressionPacket();
            for (Map.Entry<ResourceLocation, ServerLoginNetworking.LoginQueryResponseHandler> entry : ServerNetworkingImpl.LOGIN.getHandlers().entrySet()) {
                ServerLoginNetworking.registerReceiver(this.handler, entry.getKey(), entry.getValue());
            }
            ServerLoginConnectionEvents.QUERY_START.invoker().onLoginStart(this.handler, this.server, this, this.waits::add);
            this.firstQueryTick = false;
        }
        AtomicReference error = new AtomicReference();
        this.waits.removeIf(future -> {
            if (!future.isDone()) {
                return false;
            }
            try {
                future.get();
            }
            catch (ExecutionException ex) {
                Throwable caught = ex.getCause();
                error.getAndUpdate(oldEx -> {
                    if (oldEx == null) {
                        return caught;
                    }
                    oldEx.addSuppressed(caught);
                    return oldEx;
                });
            }
            catch (InterruptedException | CancellationException exception) {
                // empty catch block
            }
            return true;
        });
        return this.channels.isEmpty() && this.waits.isEmpty();
    }

    private void sendCompressionPacket() {
        if (this.server.m_6328_() >= 0 && !this.connection.m_129531_()) {
            this.connection.m_129514_((Packet)new ClientboundLoginCompressionPacket(this.server.m_6328_()), channelFuture -> this.connection.m_129484_(this.server.m_6328_(), true));
        }
    }

    public boolean handle(ServerboundCustomQueryPacket packet) {
        LoginQueryResponseC2SPacketAccessor access = (LoginQueryResponseC2SPacketAccessor)packet;
        return this.handle(access.getTransactionId(), access.getData());
    }

    private boolean handle(int queryId, @Nullable FriendlyByteBuf originalBuf) {
        this.logger.debug("Handling inbound login query with id {}", (Object)queryId);
        ResourceLocation channel = this.channels.remove(queryId);
        if (channel == null) {
            this.logger.warn("Query ID {} was received but no query has been associated in {}!", (Object)queryId, (Object)this.connection);
            return false;
        }
        boolean understood = originalBuf != null;
        @Nullable ServerLoginNetworking.LoginQueryResponseHandler handler = ServerNetworkingImpl.LOGIN.getHandler(channel);
        if (handler == null) {
            return false;
        }
        FriendlyByteBuf buf = understood ? PacketByteBufs.slice((ByteBuf)originalBuf) : PacketByteBufs.empty();
        try {
            handler.receive(this.server, this.handler, understood, buf, this.waits::add, this);
        }
        catch (Throwable ex) {
            this.logger.error("Encountered exception while handling in channel \"{}\"", (Object)channel, (Object)ex);
            throw ex;
        }
        return true;
    }

    @Override
    public Packet<?> createPacket(ResourceLocation channelName, FriendlyByteBuf buf) {
        int queryId = this.queryIdFactory.nextId();
        ClientboundCustomQueryPacket ret = new ClientboundCustomQueryPacket(queryId, channelName, buf);
        return ret;
    }

    @Override
    public void sendPacket(Packet<?> packet) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        this.connection.m_129512_(packet);
    }

    @Override
    public void sendPacket(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> callback) {
        Objects.requireNonNull(packet, "Packet cannot be null");
        this.connection.m_129514_(packet, callback);
    }

    public void registerOutgoingPacket(ClientboundCustomQueryPacket packet) {
        this.channels.put(packet.m_134755_(), packet.m_179811_());
    }

    @Override
    protected void handleRegistration(ResourceLocation channelName) {
    }

    @Override
    protected void handleUnregistration(ResourceLocation channelName) {
    }

    @Override
    protected void invokeDisconnectEvent() {
        ServerLoginConnectionEvents.DISCONNECT.invoker().onLoginDisconnect(this.handler, this.server);
        this.receiver.endSession(this);
    }

    public void handlePlayTransition() {
        this.receiver.endSession(this);
    }

    @Override
    protected boolean isReservedChannel(ResourceLocation channelName) {
        return false;
    }
}

