/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge.fabric.impl.networking.server;

import com.seibel.lod.forge.fabric.api.networking.v1.S2CPlayChannelEvents;
import com.seibel.lod.forge.fabric.api.networking.v1.ServerPlayConnectionEvents;
import com.seibel.lod.forge.fabric.api.networking.v1.ServerPlayNetworking;
import com.seibel.lod.forge.fabric.impl.networking.AbstractChanneledNetworkAddon;
import com.seibel.lod.forge.fabric.impl.networking.ChannelInfoHolder;
import com.seibel.lod.forge.fabric.impl.networking.NetworkingImpl;
import com.seibel.lod.forge.fabric.impl.networking.server.ServerNetworkingImpl;
import com.seibel.lod.forge.mixins.fabric.mixin.networking.accessor.CustomPayloadC2SPacketAccessor;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;

public final class ServerPlayNetworkAddon
extends AbstractChanneledNetworkAddon<ServerPlayNetworking.PlayChannelHandler> {
    private final ServerGamePacketListenerImpl handler;
    private final MinecraftServer server;
    private boolean sentInitialRegisterPacket;

    public ServerPlayNetworkAddon(ServerGamePacketListenerImpl handler, MinecraftServer server) {
        super(ServerNetworkingImpl.PLAY, handler.m_6198_(), "ServerPlayNetworkAddon for " + handler.f_9743_.m_6302_());
        this.handler = handler;
        this.server = server;
        this.registerPendingChannels((ChannelInfoHolder)this.connection);
        this.receiver.startSession(this);
    }

    @Override
    public void lateInit() {
        for (Map.Entry entry : this.receiver.getHandlers().entrySet()) {
            this.registerChannel(entry.getKey(), (ServerPlayNetworking.PlayChannelHandler)entry.getValue());
        }
        ServerPlayConnectionEvents.INIT.invoker().onPlayInit(this.handler, this.server);
    }

    public void onClientReady() {
        ServerPlayConnectionEvents.JOIN.invoker().onPlayReady(this.handler, this, this.server);
        this.sendInitialChannelRegistrationPacket();
        this.sentInitialRegisterPacket = true;
    }

    public boolean handle(ServerboundCustomPayloadPacket packet) {
        if (this.server.m_18695_()) {
            return false;
        }
        CustomPayloadC2SPacketAccessor access = (CustomPayloadC2SPacketAccessor)packet;
        return this.handle(access.getIdentifier(), access.getData());
    }

    @Override
    protected void receive(ServerPlayNetworking.PlayChannelHandler handler, FriendlyByteBuf buf) {
        handler.receive(this.server, this.handler.f_9743_, this.handler, buf, this);
    }

    @Override
    protected void schedule(Runnable task) {
        this.handler.f_9743_.f_8924_.execute(task);
    }

    @Override
    public Packet<?> createPacket(ResourceLocation channelName, FriendlyByteBuf buf) {
        return ServerPlayNetworking.createS2CPacket(channelName, buf);
    }

    @Override
    protected void invokeRegisterEvent(List<ResourceLocation> ids) {
        S2CPlayChannelEvents.REGISTER.invoker().onChannelRegister(this.handler, this, this.server, ids);
    }

    @Override
    protected void invokeUnregisterEvent(List<ResourceLocation> ids) {
        S2CPlayChannelEvents.UNREGISTER.invoker().onChannelUnregister(this.handler, this, this.server, ids);
    }

    @Override
    protected void handleRegistration(ResourceLocation channelName) {
        FriendlyByteBuf buf;
        if (this.sentInitialRegisterPacket && (buf = this.createRegistrationPacket(Collections.singleton(channelName))) != null) {
            this.sendPacket(NetworkingImpl.REGISTER_CHANNEL, buf);
        }
    }

    @Override
    protected void handleUnregistration(ResourceLocation channelName) {
        FriendlyByteBuf buf;
        if (this.sentInitialRegisterPacket && (buf = this.createRegistrationPacket(Collections.singleton(channelName))) != null) {
            this.sendPacket(NetworkingImpl.UNREGISTER_CHANNEL, buf);
        }
    }

    @Override
    protected void invokeDisconnectEvent() {
        ServerPlayConnectionEvents.DISCONNECT.invoker().onPlayDisconnect(this.handler, this.server);
        this.receiver.endSession(this);
    }

    @Override
    protected boolean isReservedChannel(ResourceLocation channelName) {
        return NetworkingImpl.isReservedPlayChannel(channelName);
    }
}

