/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge.mixins.fabric.mixin.networking;

import com.seibel.lod.forge.fabric.impl.networking.ChannelInfoHolder;
import com.seibel.lod.forge.fabric.impl.networking.DisconnectPacketSource;
import com.seibel.lod.forge.fabric.impl.networking.NetworkHandlerExtensions;
import com.seibel.lod.forge.fabric.impl.networking.PacketCallbackListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.resources.ResourceLocation;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Connection.class})
abstract class ClientConnectionMixin
implements ChannelInfoHolder {
    @Shadow
    private PacketListener f_129470_;
    @Unique
    private Collection<ResourceLocation> playChannels;

    ClientConnectionMixin() {
    }

    @Shadow
    public abstract void m_129514_(Packet<?> var1, GenericFutureListener<? extends Future<? super Void>> var2);

    @Shadow
    public abstract void m_129507_(Component var1);

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initAddedFields(PacketFlow side, CallbackInfo ci) {
        this.playChannels = Collections.newSetFromMap(new ConcurrentHashMap());
    }

    @Redirect(method={"Lnet/minecraft/network/Connection;exceptionCaught(Lio/netty/channel/ChannelHandlerContext;Ljava/lang/Throwable;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/network/Connection;send(Lnet/minecraft/network/protocol/Packet;Lio/netty/util/concurrent/GenericFutureListener;)V"))
    private void resendOnExceptionCaught(Connection self, Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> listener) {
        PacketListener handler = this.f_129470_;
        if (handler instanceof DisconnectPacketSource) {
            this.m_129514_(((DisconnectPacketSource)handler).createDisconnectPacket((Component)new TranslatableComponent("disconnect.genericReason")), listener);
        } else {
            this.m_129507_((Component)new TranslatableComponent("disconnect.genericReason"));
        }
    }

    @Inject(method={"sendPacket"}, at={@At(value="FIELD", target="Lnet/minecraft/network/Connection;sentPackets:I")})
    private void checkPacket(Packet<?> packet, GenericFutureListener<? extends Future<? super Void>> callback, CallbackInfo ci) {
        if (this.f_129470_ instanceof PacketCallbackListener) {
            ((PacketCallbackListener)this.f_129470_).sent(packet);
        }
    }

    @Inject(method={"channelInactive"}, at={@At(value="HEAD")})
    private void handleDisconnect(ChannelHandlerContext channelHandlerContext, CallbackInfo ci) throws Exception {
        if (this.f_129470_ instanceof NetworkHandlerExtensions) {
            ((NetworkHandlerExtensions)this.f_129470_).getAddon().handleDisconnect();
        }
    }

    @Override
    public Collection<ResourceLocation> getPendingChannelsNames() {
        return this.playChannels;
    }
}

