/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.lod.forge.mixins.fabric.mixin.networking;

import com.seibel.lod.forge.fabric.impl.networking.DisconnectPacketSource;
import com.seibel.lod.forge.fabric.impl.networking.NetworkHandlerExtensions;
import com.seibel.lod.forge.fabric.impl.networking.PacketCallbackListener;
import com.seibel.lod.forge.fabric.impl.networking.server.ServerLoginNetworkAddon;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.login.ClientboundCustomQueryPacket;
import net.minecraft.network.protocol.login.ClientboundLoginDisconnectPacket;
import net.minecraft.network.protocol.login.ServerboundCustomQueryPacket;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerLoginPacketListenerImpl;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={ServerLoginPacketListenerImpl.class})
abstract class ServerLoginNetworkHandlerMixin
implements NetworkHandlerExtensions,
DisconnectPacketSource,
PacketCallbackListener {
    @Shadow
    @Final
    private MinecraftServer f_10018_;
    @Unique
    private ServerLoginNetworkAddon addon;

    ServerLoginNetworkHandlerMixin() {
    }

    @Shadow
    public abstract void m_10055_();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void initAddon(CallbackInfo ci) {
        this.addon = new ServerLoginNetworkAddon((ServerLoginPacketListenerImpl)this);
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/network/ServerLoginPacketListenerImpl;handleAcceptedLogin()V"))
    private void handlePlayerJoin(ServerLoginPacketListenerImpl handler) {
        if (this.addon.queryTick()) {
            this.m_10055_();
        }
    }

    @Inject(method={"handleCustomQueryPacket"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleCustomPayloadReceivedAsync(ServerboundCustomQueryPacket packet, CallbackInfo ci) {
        if (this.addon.handle(packet)) {
            ci.cancel();
        }
    }

    @Redirect(method={"handleAcceptedLogin"}, at=@At(value="INVOKE", target="Lnet/minecraft/server/MinecraftServer;getCompressionThreshold()I", ordinal=0))
    private int removeLateCompressionPacketSending(MinecraftServer server) {
        return -1;
    }

    @Inject(method={"onDisconnect"}, at={@At(value="HEAD")})
    private void handleDisconnection(Component reason, CallbackInfo ci) {
        this.addon.handleDisconnect();
    }

    @Inject(method={"placeNewPlayer"}, at={@At(value="HEAD")})
    private void handlePlayTransitionNormal(ServerPlayer player, CallbackInfo ci) {
        this.addon.handlePlayTransition();
    }

    @Override
    public void sent(Packet<?> packet) {
        if (packet instanceof ClientboundCustomQueryPacket) {
            this.addon.registerOutgoingPacket((ClientboundCustomQueryPacket)packet);
        }
    }

    public ServerLoginNetworkAddon getAddon() {
        return this.addon;
    }

    @Override
    public Packet<?> createDisconnectPacket(Component message) {
        return new ClientboundLoginDisconnectPacket(message);
    }
}

