/*
 * Decompiled with CFR 0.152.
 */
package fabric.com.seibel.lod.common.wrappers.worldGeneration.mimicObject;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.enums.config.LightGenerationMode;
import fabric.com.seibel.lod.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import fabric.com.seibel.lod.common.wrappers.worldGeneration.mimicObject.WorldGenLevelLightEngine;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_2821;
import net.minecraft.class_2902;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3233;
import net.minecraft.class_3532;
import net.minecraft.class_3568;
import net.minecraft.class_3980;
import net.minecraft.class_4076;
import net.minecraft.class_5539;
import net.minecraft.class_6539;
import org.jetbrains.annotations.Nullable;

public class LightedWorldGenRegion
extends class_3233 {
    public final WorldGenLevelLightEngine light;
    public final LightGenerationMode lightMode;
    public final BatchGenerationEnvironment.EmptyChunkGenerator generator;
    public final int writeRadius;
    public final int size;
    private final class_1923 firstPos;
    private final List<class_2791> cache;
    Long2ObjectOpenHashMap<class_2791> chunkMap = new Long2ObjectOpenHashMap();
    private static class_2806 debugTriggeredForStatus = null;

    public LightedWorldGenRegion(class_3218 serverLevel, WorldGenLevelLightEngine lightEngine, List<class_2791> list, class_2806 chunkStatus, int i, LightGenerationMode lightMode, BatchGenerationEnvironment.EmptyChunkGenerator generator) {
        super(serverLevel, list, chunkStatus, i);
        this.lightMode = lightMode;
        this.firstPos = list.get(0).method_12004();
        this.generator = generator;
        this.light = lightEngine;
        this.writeRadius = i;
        this.cache = list;
        this.size = class_3532.method_15357((double)Math.sqrt(list.size()));
    }

    public boolean method_37368(class_2338 blockPos) {
        int i = class_4076.method_18675((int)blockPos.method_10263());
        int j = class_4076.method_18675((int)blockPos.method_10260());
        class_1923 chunkPos = this.method_33561();
        class_2791 center = this.method_8392(chunkPos.field_9181, chunkPos.field_9180);
        int k = Math.abs(chunkPos.field_9181 - i);
        int l = Math.abs(chunkPos.field_9180 - j);
        if (k > this.writeRadius || l > this.writeRadius) {
            return false;
        }
        if (center.method_39461()) {
            class_5539 levelHeightAccessor = center.method_39460();
            if (blockPos.method_10264() < levelHeightAccessor.method_31607() || blockPos.method_10264() >= levelHeightAccessor.method_31600()) {
                return false;
            }
        }
        return true;
    }

    public boolean method_30092(class_2338 blockPos, class_2680 blockState, int i, int j) {
        class_2791 chunkAccess = this.method_22350(blockPos);
        if (chunkAccess instanceof class_2818) {
            return true;
        }
        chunkAccess.method_12010(blockPos, blockState, false);
        return true;
    }

    public boolean method_30093(class_2338 blockPos, boolean bl, @Nullable class_1297 entity, int i) {
        class_2680 blockState = this.method_8320(blockPos);
        if (blockState.method_26215()) {
            return false;
        }
        return this.method_30092(blockPos, class_2246.field_10124.method_9564(), 3, i);
    }

    public class_2586 method_8321(class_2338 blockPos) {
        return null;
    }

    public boolean method_8649(class_1297 entity) {
        return true;
    }

    public class_2791 method_8392(int i, int j) {
        return this.method_22342(i, j, class_2806.field_12798);
    }

    public class_2791 method_22342(int i, int j, class_2806 chunkStatus) {
        return this.method_8402(i, j, chunkStatus, true);
    }

    private class_2791 superGetChunk(int x, int z, class_2806 cs) {
        int k = x - this.firstPos.field_9181;
        int l = z - this.firstPos.field_9180;
        return this.cache.get(k + l * this.size);
    }

    private boolean superHasChunk(int x, int z) {
        int k = x - this.firstPos.field_9181;
        int l = z - this.firstPos.field_9180;
        return l >= 0 && l < this.size && k >= 0 && k < this.size;
    }

    @Nullable
    public class_2791 method_8402(int i, int j, class_2806 chunkStatus, boolean bl) {
        class_2791 chunk = this.getChunkAccess(i, j, chunkStatus, bl);
        if (chunk instanceof class_2818) {
            chunk = new class_2821((class_2818)chunk, true);
        }
        return chunk;
    }

    private class_2791 getChunkAccess(int i, int j, class_2806 chunkStatus, boolean bl) {
        class_2791 chunk;
        class_2791 class_27912 = chunk = this.superHasChunk(i, j) ? this.superGetChunk(i, j, class_2806.field_12798) : null;
        if (chunk != null && chunk.method_12009().method_12165(chunkStatus)) {
            return chunk;
        }
        if (!bl) {
            return null;
        }
        if (chunk == null && (chunk = (class_2791)this.chunkMap.get(class_1923.method_8331((int)i, (int)j))) == null) {
            chunk = this.generator.generate(i, j);
            if (chunk == null) {
                throw new NullPointerException("The provided generator should not return null!");
            }
            this.chunkMap.put(class_1923.method_8331((int)i, (int)j), (Object)chunk);
        }
        if (chunkStatus != class_2806.field_12798 && chunkStatus != debugTriggeredForStatus) {
            ApiShared.LOGGER.info("WorldGen requiring " + chunkStatus + " outside expected range detected. Force passing EMPTY chunk and seeing if it works.");
            debugTriggeredForStatus = chunkStatus;
        }
        return chunk;
    }

    public class_3568 method_22336() {
        return this.light;
    }

    public int method_8314(class_1944 lightLayer, class_2338 blockPos) {
        if (this.lightMode != LightGenerationMode.FAST) {
            return this.light.method_15562(lightLayer).method_15543(blockPos);
        }
        if (lightLayer == class_1944.field_9282) {
            return 0;
        }
        class_2338 p = super.method_8598(class_2902.class_2903.field_13203, blockPos);
        return p.method_10264() <= blockPos.method_10264() ? this.method_8315() : 0;
    }

    public int method_22335(class_2338 blockPos, int i) {
        if (this.lightMode != LightGenerationMode.FAST) {
            return this.light.method_22363(blockPos, i);
        }
        class_2338 p = super.method_8598(class_2902.class_2903.field_13203, blockPos);
        return p.method_10264() <= blockPos.method_10264() ? this.method_8315() : 0;
    }

    public boolean method_8311(class_2338 blockPos) {
        return this.method_8314(class_1944.field_9284, blockPos) >= this.method_8315();
    }

    public int method_23752(class_2338 blockPos, class_6539 colorResolver) {
        return this.calculateBlockTint(blockPos, colorResolver);
    }

    private class_1959 _getBiome(class_2338 pos) {
        return (class_1959)this.method_23753(pos).comp_349();
    }

    public int calculateBlockTint(class_2338 blockPos, class_6539 colorResolver) {
        int i = class_310.method_1551().field_1690.field_1878;
        if (i == 0) {
            return colorResolver.getColor(this._getBiome(blockPos), (double)blockPos.method_10263(), (double)blockPos.method_10260());
        }
        int j = (i * 2 + 1) * (i * 2 + 1);
        int k = 0;
        int l = 0;
        int m = 0;
        class_3980 cursor3D = new class_3980(blockPos.method_10263() - i, blockPos.method_10264(), blockPos.method_10260() - i, blockPos.method_10263() + i, blockPos.method_10264(), blockPos.method_10260() + i);
        class_2338.class_2339 mutableBlockPos = new class_2338.class_2339();
        while (cursor3D.method_17963()) {
            mutableBlockPos.method_10103(cursor3D.method_18671(), cursor3D.method_18672(), cursor3D.method_18673());
            int n = colorResolver.getColor(this._getBiome((class_2338)mutableBlockPos), (double)mutableBlockPos.method_10263(), (double)mutableBlockPos.method_10260());
            k += (n & 0xFF0000) >> 16;
            l += (n & 0xFF00) >> 8;
            m += n & 0xFF;
        }
        return (k / j & 0xFF) << 16 | (l / j & 0xFF) << 8 | m / j & 0xFF;
    }
}

