/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.world;

import com.seibel.lod.core.wrapperInterfaces.world.IBiomeWrapper;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.MaterialColor;

public class BiomeWrapper
implements IBiomeWrapper {
    public static final ConcurrentMap<Biome, BiomeWrapper> biomeWrapperMap = new ConcurrentHashMap<Biome, BiomeWrapper>();
    private final Biome biome;

    public BiomeWrapper(Biome biome) {
        this.biome = biome;
    }

    public static IBiomeWrapper getBiomeWrapper(Biome biome) {
        if (biomeWrapperMap.containsKey(biome) && biomeWrapperMap.get(biome) != null) {
            return (IBiomeWrapper)biomeWrapperMap.get(biome);
        }
        BiomeWrapper biomeWrapper = new BiomeWrapper(biome);
        biomeWrapperMap.put(biome, biomeWrapper);
        return biomeWrapper;
    }

    @Override
    public int getColorForBiome(int x, int z) {
        return switch (this.biome.f_47442_) {
            case Biome.BiomeCategory.NETHER -> Blocks.f_50134_.m_49966_().m_60767_().m_76339_().f_76396_;
            case Biome.BiomeCategory.THEEND -> Blocks.f_50259_.m_49966_().m_60767_().m_76339_().f_76396_;
            case Biome.BiomeCategory.BEACH, Biome.BiomeCategory.DESERT -> Blocks.f_49992_.m_49966_().m_60767_().m_76339_().f_76396_;
            case Biome.BiomeCategory.EXTREME_HILLS -> Blocks.f_50069_.m_60590_().f_76396_;
            case Biome.BiomeCategory.MUSHROOM -> MaterialColor.f_76420_.f_76396_;
            case Biome.BiomeCategory.ICY -> Blocks.f_50125_.m_60590_().f_76396_;
            case Biome.BiomeCategory.MESA -> Blocks.f_49993_.m_60590_().f_76396_;
            case Biome.BiomeCategory.OCEAN, Biome.BiomeCategory.RIVER -> this.biome.m_47560_();
            default -> this.biome.m_47464_((double)x, (double)z);
        };
    }

    @Override
    public String getName() {
        return this.biome.toString();
    }

    @Override
    public int getGrassTint(int x, int z) {
        return this.biome.m_47464_((double)x, (double)z);
    }

    @Override
    public int getFolliageTint() {
        return this.biome.m_47542_();
    }

    @Override
    public int getWaterTint() {
        return this.biome.m_47560_();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof BiomeWrapper)) {
            return false;
        }
        BiomeWrapper that = (BiomeWrapper)obj;
        return Objects.equals(this.biome, that.biome);
    }

    public int hashCode() {
        return Objects.hash(this.biome);
    }
}

