/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.worldGeneration.mimicObject;

import com.seibel.lod.core.api.ApiShared;
import com.seibel.lod.core.enums.config.LightGenerationMode;
import forge.com.seibel.lod.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import forge.com.seibel.lod.common.wrappers.worldGeneration.mimicObject.WorldGenLevelLightEngine;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Cursor3D;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ColorResolver;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import org.jetbrains.annotations.Nullable;

public class LightedWorldGenRegion
extends WorldGenRegion {
    public final WorldGenLevelLightEngine light;
    public final LightGenerationMode lightMode;
    public final BatchGenerationEnvironment.EmptyChunkGenerator generator;
    public final int writeRadius;
    public final int size;
    private final ChunkPos firstPos;
    private final List<ChunkAccess> cache;
    Long2ObjectOpenHashMap<ChunkAccess> chunkMap = new Long2ObjectOpenHashMap();
    private static ChunkStatus debugTriggeredForStatus = null;

    public LightedWorldGenRegion(ServerLevel serverLevel, WorldGenLevelLightEngine lightEngine, List<ChunkAccess> list, ChunkStatus chunkStatus, int i, LightGenerationMode lightMode, BatchGenerationEnvironment.EmptyChunkGenerator generator) {
        super(serverLevel, list, chunkStatus, i);
        this.lightMode = lightMode;
        this.firstPos = list.get(0).m_7697_();
        this.generator = generator;
        this.light = lightEngine;
        this.writeRadius = i;
        this.cache = list;
        this.size = Mth.m_14107_((double)Math.sqrt(list.size()));
    }

    public boolean m_180807_(BlockPos blockPos) {
        int i = SectionPos.m_123171_((int)blockPos.m_123341_());
        int j = SectionPos.m_123171_((int)blockPos.m_123343_());
        ChunkPos chunkPos = this.m_143488_();
        ChunkAccess center = this.m_6325_(chunkPos.f_45578_, chunkPos.f_45579_);
        int k = Math.abs(chunkPos.f_45578_ - i);
        int l = Math.abs(chunkPos.f_45579_ - j);
        if (k > this.writeRadius || l > this.writeRadius) {
            return false;
        }
        if (center.m_187679_()) {
            LevelHeightAccessor levelHeightAccessor = center.m_183618_();
            if (blockPos.m_123342_() < levelHeightAccessor.m_141937_() || blockPos.m_123342_() >= levelHeightAccessor.m_151558_()) {
                return false;
            }
        }
        return true;
    }

    public boolean m_6933_(BlockPos blockPos, BlockState blockState, int i, int j) {
        ChunkAccess chunkAccess = this.m_46865_(blockPos);
        if (chunkAccess instanceof LevelChunk) {
            return true;
        }
        chunkAccess.m_6978_(blockPos, blockState, false);
        return true;
    }

    public boolean m_7740_(BlockPos blockPos, boolean bl, @Nullable Entity entity, int i) {
        BlockState blockState = this.m_8055_(blockPos);
        if (blockState.m_60795_()) {
            return false;
        }
        return this.m_6933_(blockPos, Blocks.f_50016_.m_49966_(), 3, i);
    }

    public BlockEntity m_7702_(BlockPos blockPos) {
        return null;
    }

    public boolean m_7967_(Entity entity) {
        return true;
    }

    public ChunkAccess m_6325_(int i, int j) {
        return this.m_46819_(i, j, ChunkStatus.f_62314_);
    }

    public ChunkAccess m_46819_(int i, int j, ChunkStatus chunkStatus) {
        return this.m_6522_(i, j, chunkStatus, true);
    }

    private ChunkAccess superGetChunk(int x, int z, ChunkStatus cs) {
        int k = x - this.firstPos.f_45578_;
        int l = z - this.firstPos.f_45579_;
        return this.cache.get(k + l * this.size);
    }

    private boolean superHasChunk(int x, int z) {
        int k = x - this.firstPos.f_45578_;
        int l = z - this.firstPos.f_45579_;
        return l >= 0 && l < this.size && k >= 0 && k < this.size;
    }

    @Nullable
    public ChunkAccess m_6522_(int i, int j, ChunkStatus chunkStatus, boolean bl) {
        ChunkAccess chunk = this.getChunkAccess(i, j, chunkStatus, bl);
        if (chunk instanceof LevelChunk) {
            chunk = new ImposterProtoChunk((LevelChunk)chunk, true);
        }
        return chunk;
    }

    private ChunkAccess getChunkAccess(int i, int j, ChunkStatus chunkStatus, boolean bl) {
        ChunkAccess chunk;
        ChunkAccess chunkAccess = chunk = this.superHasChunk(i, j) ? this.superGetChunk(i, j, ChunkStatus.f_62314_) : null;
        if (chunk != null && chunk.m_6415_().m_62427_(chunkStatus)) {
            return chunk;
        }
        if (!bl) {
            return null;
        }
        if (chunk == null && (chunk = (ChunkAccess)this.chunkMap.get(ChunkPos.m_45589_((int)i, (int)j))) == null) {
            chunk = this.generator.generate(i, j);
            if (chunk == null) {
                throw new NullPointerException("The provided generator should not return null!");
            }
            this.chunkMap.put(ChunkPos.m_45589_((int)i, (int)j), (Object)chunk);
        }
        if (chunkStatus != ChunkStatus.f_62314_ && chunkStatus != debugTriggeredForStatus) {
            ApiShared.LOGGER.info("WorldGen requiring " + chunkStatus + " outside expected range detected. Force passing EMPTY chunk and seeing if it works.");
            debugTriggeredForStatus = chunkStatus;
        }
        return chunk;
    }

    public LevelLightEngine m_5518_() {
        return this.light;
    }

    public int m_45517_(LightLayer lightLayer, BlockPos blockPos) {
        if (this.lightMode != LightGenerationMode.FAST) {
            return this.light.m_75814_(lightLayer).m_7768_(blockPos);
        }
        if (lightLayer == LightLayer.BLOCK) {
            return 0;
        }
        BlockPos p = super.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, blockPos);
        return p.m_123342_() <= blockPos.m_123342_() ? this.m_7469_() : 0;
    }

    public int m_45524_(BlockPos blockPos, int i) {
        if (this.lightMode != LightGenerationMode.FAST) {
            return this.light.m_75831_(blockPos, i);
        }
        BlockPos p = super.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, blockPos);
        return p.m_123342_() <= blockPos.m_123342_() ? this.m_7469_() : 0;
    }

    public boolean m_45527_(BlockPos blockPos) {
        return this.m_45517_(LightLayer.SKY, blockPos) >= this.m_7469_();
    }

    public int m_6171_(BlockPos blockPos, ColorResolver colorResolver) {
        return this.calculateBlockTint(blockPos, colorResolver);
    }

    private Biome _getBiome(BlockPos pos) {
        return (Biome)this.m_204166_(pos).m_203334_();
    }

    public int calculateBlockTint(BlockPos blockPos, ColorResolver colorResolver) {
        int i = Minecraft.m_91087_().f_91066_.f_92032_;
        if (i == 0) {
            return colorResolver.m_130045_(this._getBiome(blockPos), (double)blockPos.m_123341_(), (double)blockPos.m_123343_());
        }
        int j = (i * 2 + 1) * (i * 2 + 1);
        int k = 0;
        int l = 0;
        int m = 0;
        Cursor3D cursor3D = new Cursor3D(blockPos.m_123341_() - i, blockPos.m_123342_(), blockPos.m_123343_() - i, blockPos.m_123341_() + i, blockPos.m_123342_(), blockPos.m_123343_() + i);
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        while (cursor3D.m_122304_()) {
            mutableBlockPos.m_122178_(cursor3D.m_122305_(), cursor3D.m_122306_(), cursor3D.m_122307_());
            int n = colorResolver.m_130045_(this._getBiome((BlockPos)mutableBlockPos), (double)mutableBlockPos.m_123341_(), (double)mutableBlockPos.m_123343_());
            k += (n & 0xFF0000) >> 16;
            l += (n & 0xFF00) >> 8;
            m += n & 0xFF;
        }
        return (k / j & 0xFF) << 16 | (l / j & 0xFF) << 8 | m / j & 0xFF;
    }
}

