/*
 * Decompiled with CFR 0.152.
 */
package forge.com.seibel.lod.common.wrappers.worldGeneration.mimicObject;

import forge.com.seibel.lod.common.wrappers.worldGeneration.mimicObject.LightGetterAdaptor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.DataLayer;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.BlockLightEngine;
import net.minecraft.world.level.lighting.LayerLightEventListener;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.lighting.SkyLightEngine;
import org.jetbrains.annotations.Nullable;

public class WorldGenLevelLightEngine
extends LevelLightEngine {
    public static final int MAX_SOURCE_LEVEL = 15;
    public static final int LIGHT_SECTION_PADDING = 1;
    protected final LevelHeightAccessor levelHeightAccessor;
    @Nullable
    public final BlockLightEngine blockEngine;
    @Nullable
    public final SkyLightEngine skyEngine;

    public WorldGenLevelLightEngine(LightGetterAdaptor genRegion) {
        super((LightChunkGetter)genRegion, false, false);
        this.levelHeightAccessor = genRegion.getLevelHeightAccessor();
        this.blockEngine = new BlockLightEngine((LightChunkGetter)genRegion);
        this.skyEngine = new SkyLightEngine((LightChunkGetter)genRegion);
    }

    public void m_142202_(BlockPos blockPos) {
        if (this.blockEngine != null) {
            this.blockEngine.m_142202_(blockPos);
        }
        if (this.skyEngine != null) {
            this.skyEngine.m_142202_(blockPos);
        }
    }

    public void m_142519_(BlockPos blockPos, int i) {
        if (this.blockEngine != null) {
            this.blockEngine.m_142519_(blockPos, i);
        }
    }

    public boolean m_142182_() {
        if (this.skyEngine != null && this.skyEngine.m_142182_()) {
            return true;
        }
        return this.blockEngine != null && this.blockEngine.m_142182_();
    }

    public int m_142528_(int i, boolean bl, boolean bl2) {
        if (this.blockEngine != null && this.skyEngine != null) {
            int j = i / 2;
            int k = this.blockEngine.m_142528_(j, bl, bl2);
            int l = i - j + k;
            int m = this.skyEngine.m_142528_(l, bl, bl2);
            if (k == 0 && m > 0) {
                return this.blockEngine.m_142528_(m, bl, bl2);
            }
            return m;
        }
        if (this.blockEngine != null) {
            return this.blockEngine.m_142528_(i, bl, bl2);
        }
        if (this.skyEngine != null) {
            return this.skyEngine.m_142528_(i, bl, bl2);
        }
        return i;
    }

    public void m_6191_(SectionPos sectionPos, boolean bl) {
        if (this.blockEngine != null) {
            this.blockEngine.m_6191_(sectionPos, bl);
        }
        if (this.skyEngine != null) {
            this.skyEngine.m_6191_(sectionPos, bl);
        }
    }

    public void m_141940_(ChunkPos chunkPos, boolean bl) {
        if (this.blockEngine != null) {
            this.blockEngine.m_141940_(chunkPos, bl);
        }
        if (this.skyEngine != null) {
            this.skyEngine.m_141940_(chunkPos, bl);
        }
    }

    public LayerLightEventListener m_75814_(LightLayer lightLayer) {
        if (lightLayer == LightLayer.BLOCK) {
            if (this.blockEngine == null) {
                return LayerLightEventListener.DummyLightLayerEventListener.INSTANCE;
            }
            return this.blockEngine;
        }
        if (this.skyEngine == null) {
            return LayerLightEventListener.DummyLightLayerEventListener.INSTANCE;
        }
        return this.skyEngine;
    }

    public int m_75831_(BlockPos blockPos, int i) {
        int j = this.skyEngine == null ? 0 : this.skyEngine.m_7768_(blockPos) - i;
        int k = this.blockEngine == null ? 0 : this.blockEngine.m_7768_(blockPos);
        return Math.max(k, j);
    }

    public void lightChunk(ChunkAccess chunkAccess, boolean needLightBlockUpdate) {
        ChunkPos chunkPos = chunkAccess.m_7697_();
        chunkAccess.m_8094_(false);
        LevelChunkSection[] levelChunkSections = chunkAccess.m_7103_();
        for (int i = 0; i < chunkAccess.m_151559_(); ++i) {
            LevelChunkSection levelChunkSection = levelChunkSections[i];
            if (levelChunkSection.m_188008_()) continue;
            int j = this.levelHeightAccessor.m_151568_(i);
            this.m_6191_(SectionPos.m_123196_((ChunkPos)chunkPos, (int)j), false);
        }
        this.m_141940_(chunkPos, true);
        if (needLightBlockUpdate) {
            chunkAccess.m_6267_().forEach(blockPos -> this.m_142519_((BlockPos)blockPos, chunkAccess.m_7146_(blockPos)));
        }
        chunkAccess.m_8094_(true);
    }

    public String m_75816_(LightLayer lightLayer, SectionPos sectionPos) {
        throw new UnsupportedOperationException("This should never be used!");
    }

    public void m_5687_(LightLayer lightLayer, SectionPos sectionPos, @Nullable DataLayer dataLayer, boolean bl) {
        if (lightLayer == LightLayer.BLOCK) {
            if (this.blockEngine != null) {
                this.blockEngine.m_75660_(sectionPos.m_123252_(), dataLayer, bl);
            }
        } else if (this.skyEngine != null) {
            this.skyEngine.m_75660_(sectionPos.m_123252_(), dataLayer, bl);
        }
    }

    public void m_6462_(ChunkPos chunkPos, boolean bl) {
        if (this.blockEngine != null) {
            this.blockEngine.m_75699_(chunkPos, bl);
        }
        if (this.skyEngine != null) {
            this.skyEngine.m_75699_(chunkPos, bl);
        }
    }

    public int m_164446_() {
        throw new UnsupportedOperationException("This should never be used!");
    }

    public int m_164447_() {
        throw new UnsupportedOperationException("This should never be used!");
    }

    public int m_164448_() {
        throw new UnsupportedOperationException("This should never be used!");
    }
}

