/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.voicechat.voice.client.speaker;

import com.mojang.math.Vector3f;
import de.maxhenkel.voicechat.Voicechat;
import de.maxhenkel.voicechat.VoicechatClient;
import de.maxhenkel.voicechat.api.events.OpenALSoundEvent;
import de.maxhenkel.voicechat.plugins.PluginManager;
import de.maxhenkel.voicechat.voice.client.SoundManager;
import de.maxhenkel.voicechat.voice.client.speaker.Speaker;
import de.maxhenkel.voicechat.voice.client.speaker.SpeakerException;
import de.maxhenkel.voicechat.voice.common.NamedThreadPoolFactory;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.Vec3;
import org.lwjgl.openal.AL11;

public abstract class ALSpeakerBase
implements Speaker {
    protected final Minecraft mc = Minecraft.m_91087_();
    protected final SoundManager soundManager;
    protected final int sampleRate;
    protected int bufferSize;
    protected int bufferSampleSize;
    protected int source;
    protected volatile int bufferIndex;
    protected final int[] buffers;
    protected final ExecutorService executor;
    @Nullable
    protected UUID audioChannelId;

    public ALSpeakerBase(SoundManager soundManager, int sampleRate, int bufferSize, @Nullable UUID audioChannelId) {
        this.soundManager = soundManager;
        this.sampleRate = sampleRate;
        this.bufferSize = bufferSize;
        this.bufferSampleSize = bufferSize;
        this.audioChannelId = audioChannelId;
        this.buffers = new int[32];
        String threadName = audioChannelId == null ? "SoundSourceThread" : "SoundSourceThread-%s".formatted(audioChannelId);
        this.executor = Executors.newSingleThreadExecutor(NamedThreadPoolFactory.create(threadName));
    }

    @Override
    public void open() throws SpeakerException {
        this.runInContext(this::openSync);
    }

    protected void openSync() {
        if (this.hasValidSourceSync()) {
            return;
        }
        this.source = AL11.alGenSources();
        SoundManager.checkAlError();
        AL11.alSourcei((int)this.source, (int)4103, (int)0);
        SoundManager.checkAlError();
        AL11.alDistanceModel((int)0);
        SoundManager.checkAlError();
        AL11.alGenBuffers((int[])this.buffers);
        SoundManager.checkAlError();
    }

    @Override
    public void play(short[] data, float volume, @Nullable Vec3 position) {
        this.runInContext(() -> {
            boolean stopped;
            this.removeProcessedBuffersSync();
            int buffers = this.getQueuedBuffersSync();
            boolean bl = stopped = this.getStateSync() == 4113 || this.getStateSync() == 4116 || buffers <= 1;
            if (stopped) {
                for (int i = 0; i < this.getBufferSize(); ++i) {
                    this.writeSync(new short[this.bufferSize], 1.0f, position);
                }
            }
            this.writeSync(data, volume, position);
            if (stopped) {
                AL11.alSourcePlay((int)this.source);
                SoundManager.checkAlError();
            }
        });
    }

    protected int getBufferSize() {
        return VoicechatClient.CLIENT_CONFIG.outputBufferSize.get();
    }

    protected void writeSync(short[] data, float volume, @Nullable Vec3 position) {
        PluginManager.instance().onALSound(this.source, this.audioChannelId, position, OpenALSoundEvent.Pre.class);
        this.setPositionSync(position);
        PluginManager.instance().onALSound(this.source, this.audioChannelId, position, OpenALSoundEvent.class);
        AL11.alSourcef((int)this.source, (int)4110, (float)6.0f);
        SoundManager.checkAlError();
        AL11.alSourcef((int)this.source, (int)4106, (float)volume);
        SoundManager.checkAlError();
        AL11.alListenerf((int)4106, (float)1.0f);
        SoundManager.checkAlError();
        int queuedBuffers = this.getQueuedBuffersSync();
        if (queuedBuffers >= this.buffers.length) {
            Voicechat.LOGGER.warn("Full playback buffer: {}/{}", (Object)queuedBuffers, (Object)this.buffers.length);
            int sampleOffset = AL11.alGetSourcei((int)this.source, (int)4133);
            SoundManager.checkAlError();
            int buffersToSkip = queuedBuffers - this.getBufferSize();
            AL11.alSourcei((int)this.source, (int)4133, (int)(sampleOffset + buffersToSkip * this.bufferSampleSize));
            SoundManager.checkAlError();
            this.removeProcessedBuffersSync();
        }
        AL11.alBufferData((int)this.buffers[this.bufferIndex], (int)this.getFormat(), (short[])this.convert(data, position), (int)this.sampleRate);
        SoundManager.checkAlError();
        AL11.alSourceQueueBuffers((int)this.source, (int)this.buffers[this.bufferIndex]);
        SoundManager.checkAlError();
        this.bufferIndex = (this.bufferIndex + 1) % this.buffers.length;
        PluginManager.instance().onALSound(this.source, this.audioChannelId, position, OpenALSoundEvent.Post.class);
    }

    protected abstract int getFormat();

    protected short[] convert(short[] data, @Nullable Vec3 position) {
        return data;
    }

    protected void setPositionSync(@Nullable Vec3 soundPos) {
        Camera camera = this.mc.f_91063_.m_109153_();
        Vec3 position = camera.m_90583_();
        Vector3f look = camera.m_90596_();
        Vector3f up = camera.m_90597_();
        AL11.alListener3f((int)4100, (float)((float)position.f_82479_), (float)((float)position.f_82480_), (float)((float)position.f_82481_));
        SoundManager.checkAlError();
        AL11.alListenerfv((int)4111, (float[])new float[]{look.m_122239_(), look.m_122260_(), look.m_122269_(), up.m_122239_(), up.m_122260_(), up.m_122269_()});
        SoundManager.checkAlError();
        if (soundPos != null) {
            AL11.alSourcei((int)this.source, (int)514, (int)0);
            SoundManager.checkAlError();
            AL11.alSource3f((int)this.source, (int)4100, (float)((float)soundPos.f_82479_), (float)((float)soundPos.f_82480_), (float)((float)soundPos.f_82481_));
            SoundManager.checkAlError();
        } else {
            AL11.alSourcei((int)this.source, (int)514, (int)1);
            SoundManager.checkAlError();
            AL11.alSource3f((int)this.source, (int)4100, (float)0.0f, (float)0.0f, (float)0.0f);
            SoundManager.checkAlError();
        }
    }

    @Override
    public void close() {
        this.runInContext(this::closeSync);
    }

    protected void closeSync() {
        if (this.hasValidSourceSync()) {
            if (this.getStateSync() == 4114) {
                AL11.alSourceStop((int)this.source);
                SoundManager.checkAlError();
            }
            AL11.alDeleteSources((int)this.source);
            SoundManager.checkAlError();
            AL11.alDeleteBuffers((int[])this.buffers);
            SoundManager.checkAlError();
        }
        this.source = 0;
        this.executor.shutdown();
    }

    public void checkBufferEmpty(Runnable onEmpty) {
        this.runInContext(() -> {
            if (this.getStateSync() == 4116 || this.getQueuedBuffersSync() <= 0) {
                onEmpty.run();
            }
        });
    }

    protected void removeProcessedBuffersSync() {
        int processed = AL11.alGetSourcei((int)this.source, (int)4118);
        SoundManager.checkAlError();
        for (int i = 0; i < processed; ++i) {
            AL11.alSourceUnqueueBuffers((int)this.source);
            SoundManager.checkAlError();
        }
    }

    protected int getStateSync() {
        int state = AL11.alGetSourcei((int)this.source, (int)4112);
        SoundManager.checkAlError();
        return state;
    }

    protected int getQueuedBuffersSync() {
        int buffers = AL11.alGetSourcei((int)this.source, (int)4117);
        SoundManager.checkAlError();
        return buffers;
    }

    protected boolean hasValidSourceSync() {
        boolean validSource = AL11.alIsSource((int)this.source);
        SoundManager.checkAlError();
        return validSource;
    }

    public void runInContext(Runnable runnable) {
        this.soundManager.runInContext(this.executor, runnable);
    }
}

