/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.util.AssetsProtector;

import com.github.L_Ender.cataclysm.util.AssetsProtector.AESUtil;
import com.mojang.blaze3d.platform.NativeImage;
import com.mojang.blaze3d.platform.TextureUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.CompletableFuture;
import javax.imageio.ImageIO;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.SimpleTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class AESTexture
extends SimpleTexture {
    public final File cacheFile;
    private CompletableFuture<?> future;
    private boolean textureUploaded;

    public AESTexture(File file, ResourceLocation resource) {
        super(resource);
        this.cacheFile = file;
    }

    public void loadCallback(NativeImage image) {
        Minecraft.m_91087_().execute(() -> {
            this.textureUploaded = true;
            if (!RenderSystem.isOnRenderThread()) {
                RenderSystem.recordRenderCall(() -> this.upload(image));
            } else {
                this.upload(image);
            }
        });
    }

    private void upload(NativeImage p_118021_) {
        TextureUtil.prepareImage((int)this.m_117963_(), (int)p_118021_.m_84982_(), (int)p_118021_.m_85084_());
        p_118021_.m_85040_(0, 0, 0, true);
    }

    public void m_6704_(ResourceManager resourceManager) throws IOException {
        Minecraft.m_91087_().execute(() -> {
            if (!this.textureUploaded) {
                AESTexture aESTexture = this;
                synchronized (aESTexture) {
                    this.textureUploaded = true;
                }
            }
        });
        if (this.future == null) {
            if (this.cacheFile != null && this.cacheFile.isFile()) {
                NativeImage image = null;
                try {
                    image = NativeImage.m_85058_((InputStream)new FileInputStream(this.cacheFile));
                    this.loadCallback(this.process(image));
                }
                catch (IOException ioexception) {
                    this.loadTexture();
                }
            } else {
                this.loadTexture();
            }
        }
    }

    protected void loadTexture() {
        this.future = CompletableFuture.runAsync(() -> {
            try {
                Resource resource = Minecraft.m_91087_().m_91098_().m_215593_(this.f_118129_);
                InputStream inputStream = ImageIO.read(resource.m_215507_()) != null ? resource.m_215507_() : AESUtil.decrypt(resource.m_215507_().readAllBytes());
                try {
                    NativeImage nativeimage = this.process(NativeImage.m_85058_((InputStream)inputStream));
                    Minecraft.m_91087_().execute(() -> {
                        if (nativeimage != null) {
                            this.loadCallback(nativeimage);
                        }
                    });
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return;
            }
        }, Util.m_183991_());
    }

    public NativeImage process(NativeImage image) {
        boolean lvt_2_1_;
        int scale = image.m_84982_() / 64;
        boolean bl = lvt_2_1_ = image.m_85084_() != image.m_84982_();
        if (lvt_2_1_) {
            try (NativeImage nativeImage = new NativeImage(64 * scale, 64 * scale, true);){
                nativeImage.m_85054_(image);
                image.close();
                image = nativeImage;
                nativeImage.m_84997_(0, 32 * scale, 64 * scale, 32 * scale, 0);
                nativeImage.m_85025_(4 * scale, 16 * scale, 16 * scale, 32 * scale, 4 * scale, 4 * scale, true, false);
                nativeImage.m_85025_(8 * scale, 16 * scale, 16 * scale, 32 * scale, 4 * scale, 4 * scale, true, false);
                nativeImage.m_85025_(0, 20 * scale, 24 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
                nativeImage.m_85025_(4 * scale, 20 * scale, 16 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
                nativeImage.m_85025_(8 * scale, 20 * scale, 8 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
                nativeImage.m_85025_(12 * scale, 20 * scale, 16 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
                nativeImage.m_85025_(44 * scale, 16 * scale, -8 * scale, 32 * scale, 4 * scale, 4 * scale, true, false);
                nativeImage.m_85025_(48 * scale, 16 * scale, -8 * scale, 32 * scale, 4 * scale, 4 * scale, true, false);
                nativeImage.m_85025_(40 * scale, 20 * scale, 0, 32 * scale, 4 * scale, 12 * scale, true, false);
                nativeImage.m_85025_(44 * scale, 20 * scale, -8 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
                nativeImage.m_85025_(48 * scale, 20 * scale, -16 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
                nativeImage.m_85025_(52 * scale, 20 * scale, -8 * scale, 32 * scale, 4 * scale, 12 * scale, true, false);
            }
        }
        if (lvt_2_1_) {
            AESTexture.setAreaTransparent(image, 32 * scale, 0, 64 * scale, 32 * scale);
        }
        return image;
    }

    private static void setAreaTransparent(NativeImage image, int x, int y, int width, int height) {
        for (int i = x; i < width; ++i) {
            for (int j = y; j < height; ++j) {
                int k = image.m_84985_(i, j);
                if ((k >> 24 & 0xFF) >= 128) continue;
                return;
            }
        }
        for (int l = x; l < width; ++l) {
            for (int i1 = y; i1 < height; ++i1) {
                image.m_84988_(l, i1, image.m_84985_(l, i1) & 0xFFFFFF);
            }
        }
    }
}

