/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.container;

import com.milamber_brass.brass_armory.BrassArmory;
import com.milamber_brass.brass_armory.init.BrassArmoryMenus;
import com.milamber_brass.brass_armory.item.abstracts.AbstractGunItem;
import com.milamber_brass.brass_armory.item.ammo_behaviour.AbstractAmmoBehaviour;
import com.mojang.datafixers.util.Pair;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GunContainer
extends AbstractContainerMenu {
    public static final ResourceLocation EMPTY_POWDER_SLOT = BrassArmory.locate("gui/empty_powder_slot");
    public static final ResourceLocation EMPTY_AMMO_SLOT = BrassArmory.locate("gui/empty_ammo_slot");
    public final ItemStack gunStack;
    private final Slot ammoSlot;
    private final Slot powderSlot;

    public GunContainer(int id, Inventory playerInventory) {
        this(id, playerInventory, (IItemHandler)new ItemStackHandler(2), ItemStack.f_41583_);
    }

    @ParametersAreNonnullByDefault
    public GunContainer(int id, Inventory playerInventory, IItemHandler slot, ItemStack stack) {
        super((MenuType)BrassArmoryMenus.GUN_MENU.get(), id);
        int maxAmmo;
        Predicate<ItemStack> inputPredicate;
        this.gunStack = stack;
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                this.m_38897_(new DefaultSlot((Container)playerInventory, 9 + row * 9 + column, 8 + column * 18, 84 + row * 18));
            }
        }
        for (int column = 0; column < 9; ++column) {
            this.m_38897_(new DefaultSlot((Container)playerInventory, column, 8 + column * 18, 142));
        }
        this.m_38897_(new DefaultSlot((Container)playerInventory, 40, 8, 50){

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)InventoryMenu.f_39697_);
            }
        });
        Item item = this.gunStack.m_41720_();
        if (item instanceof AbstractGunItem) {
            AbstractGunItem gunItem = (AbstractGunItem)item;
            inputPredicate = gunItem.m_6437_();
            maxAmmo = gunItem.getMaxAmmoItems();
        } else {
            inputPredicate = inputStack -> true;
            maxAmmo = 1;
        }
        this.ammoSlot = this.m_38897_((Slot)new GunSlot(slot, 0, 61, 24, inputPredicate, maxAmmo){

            @Override
            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_AMMO_SLOT);
            }
        });
        this.powderSlot = this.m_38897_((Slot)new GunSlot(slot, 1, 99, 24, inputStack -> inputStack.m_41720_().equals(Items.f_42403_) || inputStack.m_41720_().equals(Items.f_42613_), 1){

            @Override
            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_POWDER_SLOT);
            }
        });
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public ItemStack m_7648_(Player player, int index) {
        ItemStack retStack = ItemStack.f_41583_;
        Slot slot = this.m_38853_(index);
        if (slot.m_6657_()) {
            ItemStack item = slot.m_7993_();
            retStack = item.m_41777_();
            if (index < 27 ? !this.m_38903_(item, 27, 36, false) : !this.m_38903_(item, 0, 27, false)) {
                return ItemStack.f_41583_;
            }
            if (item.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
        }
        return retStack;
    }

    @Nonnull
    public static MenuConstructor getServerContainer(ItemStack stack) {
        return (id, playerInv, player) -> {
            stack.m_41784_().m_128379_("InGunContainerMenu", true);
            return new GunContainer(id, playerInv, (IItemHandler)new ItemStackHandler(2), stack);
        };
    }

    @ParametersAreNonnullByDefault
    public boolean m_6875_(Player player) {
        return true;
    }

    @ParametersAreNonnullByDefault
    public void m_6877_(Player player) {
        super.m_6877_(player);
        ItemStack ammoStack = this.ammoSlot.m_7993_();
        ItemStack powderStack = this.powderSlot.m_7993_();
        if (!powderStack.m_41619_() && !ammoStack.m_41619_()) {
            AbstractAmmoBehaviour.getStackBehaviour(ammoStack).ifPresent(behaviour -> behaviour.onLoad(player.f_19853_, (LivingEntity)player, this.gunStack, ammoStack));
            AbstractGunItem.addStack(this.gunStack, ammoStack, "BAAmmo");
            AbstractGunItem.addStack(this.gunStack, powderStack, "BAPowder");
            AbstractGunItem.setLoad(this.gunStack, 1);
            this.gunStack.m_41784_().m_128379_("InGunContainerMenu", false);
        } else {
            player.m_36176_(ammoStack, true);
            player.m_36176_(powderStack, true);
        }
    }

    static class DefaultSlot
    extends Slot {
        public DefaultSlot(Container container, int index, int xPosition, int yPosition) {
            super(container, index, xPosition, yPosition);
        }

        @ParametersAreNonnullByDefault
        public boolean m_8010_(Player player) {
            return !(this.m_7993_().m_41720_() instanceof AbstractGunItem);
        }
    }

    static class GunSlot
    extends SlotItemHandler {
        private final Predicate<ItemStack> mayPlace;
        private final int maxStack;

        public GunSlot(IItemHandler itemHandler, int index, int xPosition, int yPosition, Predicate<ItemStack> mayPlace, int maxStack) {
            super(itemHandler, index, xPosition, yPosition);
            this.mayPlace = mayPlace;
            this.maxStack = maxStack;
        }

        @Nullable
        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
            return super.m_7543_();
        }

        public boolean m_5857_(@NotNull ItemStack stack) {
            return this.mayPlace.test(stack);
        }

        public int m_6641_() {
            return this.maxStack;
        }

        public int m_5866_(@NotNull ItemStack stack) {
            return this.m_6641_();
        }
    }
}

