/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile;

import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.item.BABaseArrowItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.StringRepresentable;

public enum ArrowType implements StringRepresentable
{
    EMPTY(0.0, "empty"),
    DIRT(1.0, "dirt"),
    EXPLOSION(0.0, "explosion"),
    FROST(4.0, "frost"),
    GRASS(2.0, "grass"),
    LASER(4.0, "laser"),
    ROPE(2.0, "rope"),
    SLIME(4.0, "slime"),
    WARP(1.0, "warp"),
    FIRE(4.0, "fire"),
    CONCUSSION(4.0, "concuss");

    private final double damage;
    private final String name;

    private ArrowType(double damageIn, String nameIn) {
        this.damage = damageIn;
        this.name = nameIn;
    }

    @Nullable
    public static BABaseArrowItem getModItemFor(ArrowType arrowType) {
        switch (arrowType) {
            default: {
                return (BABaseArrowItem)BrassArmoryItems.DIRT_ARROW.get();
            }
            case EXPLOSION: {
                return (BABaseArrowItem)BrassArmoryItems.EX_ARROW.get();
            }
            case FROST: {
                return (BABaseArrowItem)BrassArmoryItems.FROST_ARROW.get();
            }
            case GRASS: {
                return (BABaseArrowItem)BrassArmoryItems.GRASS_ARROW.get();
            }
            case LASER: {
                return (BABaseArrowItem)BrassArmoryItems.LASER_ARROW.get();
            }
            case ROPE: {
                return (BABaseArrowItem)BrassArmoryItems.ROPE_ARROW.get();
            }
            case SLIME: {
                return (BABaseArrowItem)BrassArmoryItems.SLIME_ARROW.get();
            }
            case WARP: {
                return (BABaseArrowItem)BrassArmoryItems.WARP_ARROW.get();
            }
            case FIRE: {
                return (BABaseArrowItem)BrassArmoryItems.FIRE_ARROW.get();
            }
            case CONCUSSION: 
        }
        return (BABaseArrowItem)BrassArmoryItems.CONCUSSION_ARROW.get();
    }

    public static ArrowType byName(String name) {
        for (ArrowType arrowType : ArrowType.values()) {
            if (!arrowType.name.equals(name)) continue;
            return arrowType;
        }
        return EMPTY;
    }

    public double getDamage() {
        return this.damage;
    }

    @Nonnull
    public String m_7912_() {
        return this.name;
    }
}

