/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile;

import com.milamber_brass.brass_armory.block.RopeBlock;
import com.milamber_brass.brass_armory.entity.projectile.ArrowType;
import com.milamber_brass.brass_armory.init.BrassArmoryBlocks;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Endermite;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ThrownEnderpearl;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraftforge.common.util.BlockSnapshot;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.EntityTeleportEvent;
import net.minecraftforge.network.NetworkHooks;

public class BAArrowEntity
extends AbstractArrow {
    private static final EntityDataAccessor<String> ARROW_TYPE = SynchedEntityData.m_135353_(BAArrowEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final String ARROW_TYPE_STRING = "ArrowType";
    private final int maxRopeLength = 24;
    private boolean hitEntity = false;
    private int flightTime = 0;
    private boolean placeRope = false;
    private BlockPos currentRopePos;
    private double baDamage;
    private int totalRope = 0;
    private Direction hitBlockfaceDirection;
    private int ticksSinceRope;
    private Vec3 lastArrowPos;

    public BAArrowEntity(EntityType<? extends AbstractArrow> entityType, Level worldIn) {
        super(entityType, worldIn);
    }

    public BAArrowEntity(EntityType<? extends AbstractArrow> type, Level worldIn, LivingEntity shooter, ArrowType typeIn) {
        super(type, shooter, worldIn);
        this.setArrowType(typeIn.m_7912_());
        if (this.isArrowType(ArrowType.LASER)) {
            this.m_36767_((byte)5);
            this.m_20242_(true);
        }
        this.m_36781_(this.getArrowType().getDamage());
    }

    public BAArrowEntity(Level worldIn, LivingEntity shooter, ArrowType typeIn) {
        this((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.BA_ARROW.get()), worldIn, shooter, typeIn);
    }

    public BAArrowEntity(Level worldIn, double x, double y, double z, ArrowType typeIn) {
        super((EntityType)BrassArmoryEntityTypes.BA_ARROW.get(), x, y, z, worldIn);
        this.setArrowType(typeIn.m_7912_());
    }

    public ArrowType getArrowType() {
        return ArrowType.byName((String)this.m_20088_().m_135370_(ARROW_TYPE));
    }

    public void setArrowType(String arrowTypeName) {
        if (arrowTypeName != null) {
            this.m_20088_().m_135381_(ARROW_TYPE, (Object)arrowTypeName);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(ARROW_TYPE, (Object)ArrowType.EMPTY.m_7912_());
    }

    @ParametersAreNonnullByDefault
    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        if (this.getArrowType() != null) {
            compound.m_128359_(ARROW_TYPE_STRING, this.getArrowType().m_7912_());
        }
    }

    @ParametersAreNonnullByDefault
    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        if (compound.m_128441_(ARROW_TYPE_STRING)) {
            this.setArrowType(compound.m_128461_(ARROW_TYPE_STRING));
        }
    }

    @ParametersAreNonnullByDefault
    protected void m_7761_(LivingEntity living) {
        super.m_7761_(living);
        this.hitEntity = true;
        switch (ArrowType.byName((String)this.m_20088_().m_135370_(ARROW_TYPE))) {
            case DIRT: {
                this.f_19853_.m_7731_(new BlockPos(this.m_20185_(), this.m_20186_(), this.m_20189_()), Blocks.f_50493_.m_49966_(), 2);
                break;
            }
            case EXPLOSION: {
                this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, Explosion.BlockInteraction.BREAK);
                break;
            }
            case FROST: {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 70, 3));
                break;
            }
            case SLIME: {
                living.m_147240_(2.0, 1.0, 1.0);
                break;
            }
            case FIRE: {
                living.m_20254_(16);
                break;
            }
            case CONCUSSION: {
                living.m_7292_(new MobEffectInstance(MobEffects.f_19604_, Mth.m_14045_((int)(this.flightTime * 2), (int)80, (int)240), Mth.m_14045_((int)(this.flightTime / 80), (int)0, (int)2)));
                break;
            }
        }
    }

    @ParametersAreNonnullByDefault
    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        switch (ArrowType.byName((String)this.m_20088_().m_135370_(ARROW_TYPE))) {
            case DIRT: {
                this.setBlockAtArrowFace(Blocks.f_50493_.m_49966_(), result);
                this.m_146870_();
                break;
            }
            case EXPLOSION: {
                this.f_19853_.m_46511_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, Explosion.BlockInteraction.BREAK);
                this.m_146870_();
                break;
            }
            case FROST: {
                break;
            }
            case GRASS: {
                if (this.f_19853_.m_8055_(result.m_82425_()) == Blocks.f_50493_.m_49966_()) {
                    this.setBlockAtArrow(Blocks.f_50440_.m_49966_(), result);
                    this.m_146870_();
                    break;
                }
                if (this.f_19853_.m_8055_(result.m_82425_()) != Blocks.f_50440_.m_49966_()) break;
                this.f_19853_.m_7731_(result.m_82425_().m_7494_(), Blocks.f_50034_.m_49966_(), 2);
                this.m_146870_();
                break;
            }
            case ROPE: {
                this.placeRopes(result);
                break;
            }
            case SLIME: {
                this.spawnSmallSlime();
                break;
            }
            case FIRE: {
                this.setBlockAtArrowFace(Blocks.f_50083_.m_49966_(), result);
                break;
            }
            case LASER: {
                if (!this.hitEntity) break;
                this.m_146870_();
                break;
            }
            case WARP: {
                if (!this.f_19853_.m_8055_(this.m_142538_()).m_60819_().m_76178_()) break;
                this.teleportShooter();
                break;
            }
        }
    }

    public void m_8119_() {
        super.m_8119_();
        ++this.flightTime;
        if (this.isArrowType(ArrowType.FROST)) {
            this.freezeNearby(this.f_19853_, this.m_142538_());
            if (this.f_36703_ && this.f_36704_ != 0) {
                this.m_146870_();
            }
        } else if (this.isArrowType(ArrowType.LASER)) {
            if (!this.f_36703_) {
                if (this.flightTime > 4) {
                    Vec3 deltaMovement = this.m_20184_();
                    super.m_8119_();
                    if (this.m_20068_()) {
                        super.m_8119_();
                        this.m_20256_(deltaMovement);
                    }
                    if (!this.f_19853_.m_7232_(this.m_146902_().f_45578_, this.m_146902_().f_45579_)) {
                        this.m_142687_(Entity.RemovalReason.UNLOADED_TO_CHUNK);
                    }
                }
            } else {
                this.m_20242_(false);
            }
        } else if (this.isArrowType(ArrowType.ROPE) && this.placeRope) {
            ++this.ticksSinceRope;
            if (this.ticksSinceRope > 6) {
                BlockPos newPos = this.currentRopePos.m_5484_(Direction.DOWN, 1);
                if (this.f_19853_.m_8055_(newPos).m_60795_() && this.totalRope < this.maxRopeLength) {
                    this.f_19853_.m_7731_(newPos, (BlockState)((BlockState)((RopeBlock)BrassArmoryBlocks.EXPLORERS_ROPE_BLOCK.get()).m_49966_().m_61124_((Property)RopeBlock.FACING, (Comparable)this.hitBlockfaceDirection)).m_61124_((Property)RopeBlock.HAS_ARROW, (Comparable)Boolean.valueOf(this.totalRope == 0)), 2);
                    this.currentRopePos = newPos;
                    ++this.totalRope;
                    this.ticksSinceRope = 0;
                } else {
                    this.placeRope = false;
                    this.m_146870_();
                }
            }
        }
        if (this.f_19853_.f_46443_) {
            if (this.f_36703_) {
                if (this.f_36704_ % 5 == 0) {
                    this.spawnArrowParticles(1);
                }
            } else {
                this.spawnArrowParticles(2);
            }
        } else if (this.f_36703_ && this.f_36704_ != 0 && this.f_36704_ >= 600) {
            this.f_19853_.m_7605_((Entity)this, (byte)0);
        }
        this.lastArrowPos = this.m_20182_();
    }

    private void placeRopes(BlockHitResult result) {
        this.hitBlockfaceDirection = result.m_82434_();
        if (!this.hitBlockfaceDirection.equals((Object)Direction.DOWN) && !this.hitBlockfaceDirection.equals((Object)Direction.UP)) {
            BlockPos hitPos = result.m_82425_();
            this.currentRopePos = hitPos.m_142300_(this.hitBlockfaceDirection);
            BlockState hitBlockState = this.f_19853_.m_8055_(hitPos);
            if (hitBlockState.m_60783_((BlockGetter)this.f_19853_, this.currentRopePos, this.hitBlockfaceDirection) && this.f_19853_.m_8055_(this.currentRopePos).m_60795_()) {
                this.f_19853_.m_7731_(this.currentRopePos, (BlockState)((BlockState)((RopeBlock)BrassArmoryBlocks.EXPLORERS_ROPE_BLOCK.get()).m_49966_().m_61124_((Property)RopeBlock.FACING, (Comparable)this.hitBlockfaceDirection)).m_61124_((Property)RopeBlock.HAS_ARROW, (Comparable)Boolean.valueOf(this.totalRope == 0)), 2);
                ++this.totalRope;
                this.placeRope = true;
                this.f_36705_ = AbstractArrow.Pickup.DISALLOWED;
            }
        }
    }

    private void teleportShooter() {
        for (int i = 0; i < 32; ++i) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123760_, this.m_20185_(), this.m_20186_() + this.f_19796_.nextDouble() * 0.5, this.m_20189_(), this.f_19796_.nextGaussian(), 0.0, this.f_19796_.nextGaussian());
        }
        Entity entity = this.m_37282_();
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            if (entity instanceof ServerPlayer) {
                EntityTeleportEvent.EnderPearl event;
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                if (serverPlayer.f_8906_.m_6198_().m_129536_() && serverPlayer.f_19853_ == this.f_19853_ && !serverPlayer.m_5803_() && !(event = ForgeEventFactory.onEnderPearlLand((ServerPlayer)serverPlayer, (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (ThrownEnderpearl)((ThrownEnderpearl)EntityType.f_20484_.m_20615_(this.f_19853_)), (float)5.0f)).isCanceled()) {
                    if (this.f_19796_.nextFloat() < 0.05f && this.f_19853_.m_46469_().m_46207_(GameRules.f_46134_)) {
                        Endermite endermiteentity = (Endermite)EntityType.f_20567_.m_20615_(this.f_19853_);
                        endermiteentity.m_7678_(serverPlayer.m_20185_(), serverPlayer.m_20186_(), serverPlayer.m_20189_(), serverPlayer.m_146908_(), serverPlayer.m_146909_());
                        this.f_19853_.m_7967_((Entity)endermiteentity);
                    }
                    if (serverPlayer.m_20159_()) {
                        serverPlayer.m_142098_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    } else {
                        entity.m_6021_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                    }
                    entity.m_6021_(event.getTargetX(), event.getTargetY(), event.getTargetZ());
                    entity.m_183634_();
                }
            } else if (entity != null) {
                entity.m_6021_(this.m_20185_(), this.m_20186_(), this.m_20189_());
                entity.m_183634_();
            }
            this.m_146870_();
        }
    }

    private void spawnSmallSlime() {
        if (!this.f_19853_.f_46443_ && this.m_6084_() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46134_)) {
            Slime slimeEntity = (Slime)EntityType.f_20526_.m_20615_(this.f_19853_);
            slimeEntity.m_6210_();
            slimeEntity.m_21153_(1.0f);
            slimeEntity.m_7678_((double)((float)this.m_142538_().m_123341_() + 0.5f), (double)((float)this.m_142538_().m_123342_() + 0.05f), (double)((float)this.m_142538_().m_123343_() + 0.5f), this.m_146908_(), this.m_146909_());
            this.f_19853_.m_7967_((Entity)slimeEntity);
            this.m_142687_(Entity.RemovalReason.DISCARDED);
        }
    }

    public void setBlockAtArrowFace(BlockState state, BlockHitResult result) {
        Direction face = result.m_82434_();
        this.f_19853_.m_7731_(switch (face) {
            case Direction.UP -> result.m_82425_().m_7494_();
            case Direction.DOWN -> result.m_82425_().m_7495_();
            case Direction.NORTH -> result.m_82425_().m_142127_();
            case Direction.SOUTH -> result.m_82425_().m_142128_();
            case Direction.EAST -> result.m_82425_().m_142126_();
            case Direction.WEST -> result.m_82425_().m_142125_();
            default -> result.m_82425_();
        }, state, 2);
    }

    public void setBlockAtArrow(BlockState state, BlockHitResult result) {
        Direction face = result.m_82434_();
        BlockPos newPos = result.m_82425_();
        this.f_19853_.m_7731_(newPos, state, 2);
    }

    public void freezeNearby(Level worldIn, BlockPos pos) {
        BlockState blockstate = Blocks.f_50126_.m_49966_();
        float f = Math.min(16, 3);
        BlockPos.MutableBlockPos blockpos$mutable = new BlockPos.MutableBlockPos();
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pos.m_142022_((double)(-f), -1.0, (double)(-f)), (BlockPos)pos.m_142022_((double)f, -1.0, (double)f))) {
            boolean isFull;
            if (!blockpos.m_123314_((Vec3i)this.m_142538_(), (double)f)) continue;
            blockpos$mutable.m_122178_(blockpos.m_123341_(), blockpos.m_123342_() + 1, blockpos.m_123343_());
            BlockState blockstate1 = worldIn.m_8055_((BlockPos)blockpos$mutable);
            if (!blockstate1.m_60795_()) continue;
            BlockState blockstate2 = worldIn.m_8055_(blockpos);
            boolean bl = isFull = blockstate2.m_60734_() == Blocks.f_49990_ && (Integer)blockstate2.m_61143_((Property)LiquidBlock.f_54688_) == 0;
            if (blockstate2.m_60767_() != Material.f_76305_ || !isFull || !blockstate.m_60710_((LevelReader)worldIn, blockpos) || !worldIn.m_45752_(blockstate, blockpos, CollisionContext.m_82749_())) continue;
            if (ForgeEventFactory.onBlockPlace((Entity)this, (BlockSnapshot)BlockSnapshot.create((ResourceKey)worldIn.m_46472_(), (LevelAccessor)worldIn, (BlockPos)blockpos), (Direction)Direction.UP)) continue;
            worldIn.m_46597_(blockpos, blockstate);
            worldIn.m_186460_(blockpos, Blocks.f_50449_, Mth.m_14072_((Random)this.f_19796_, (int)60, (int)120));
        }
    }

    private void spawnArrowParticles(int particleCount) {
        if (particleCount > 0) {
            double d0 = 40.0;
            double d1 = 75.0;
            double d2 = 40.0;
            switch (ArrowType.byName((String)this.m_20088_().m_135370_(ARROW_TYPE))) {
                case DIRT: 
                case GRASS: {
                    for (int j = 0; j < particleCount; ++j) {
                        this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50493_.m_49966_()), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
                    }
                    break;
                }
                case EXPLOSION: {
                    if (!this.f_19853_.f_46443_ || this.f_19853_.m_5822_().nextInt(particleCount) != 1) break;
                    Vec3 smokeVec = this.m_20182_().m_82549_(this.m_20184_().m_82542_(-1.5, -1.5, -1.5)).m_82520_(0.0, 0.125, 0.0);
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, smokeVec.f_82479_, smokeVec.f_82480_, smokeVec.f_82481_, 0.0, 0.0, 0.0);
                    break;
                }
                case FIRE: {
                    for (int j = 0; j < particleCount; ++j) {
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
                    }
                    break;
                }
                case FROST: {
                    for (int j = 0; j < particleCount; ++j) {
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123803_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
                    }
                    break;
                }
                case LASER: {
                    for (int j = 0; j < particleCount; ++j) {
                        this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50330_.m_49966_()), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
                    }
                    break;
                }
                case SLIME: {
                    for (int j = 0; j < particleCount; ++j) {
                        this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50374_.m_49966_()), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
                    }
                    break;
                }
                case WARP: {
                    for (int j = 0; j < particleCount; ++j) {
                        this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123789_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
                    }
                    break;
                }
            }
        }
    }

    private boolean isArrowType(ArrowType arrowType) {
        return ArrowType.byName((String)this.m_20088_().m_135370_(ARROW_TYPE)) == arrowType;
    }

    public double m_36789_() {
        return this.baDamage;
    }

    public void m_36781_(double damageIn) {
        this.baDamage = damageIn;
    }

    @Nonnull
    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)ArrowType.getModItemFor(this.getArrowType()));
    }

    @Nonnull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

