/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile;

import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;

public class BulletEntity
extends AbstractArrow {
    private int hitPerTick;

    public BulletEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public BulletEntity(LivingEntity livingEntity, Level level) {
        super((EntityType)BrassArmoryEntityTypes.BULLET.get(), livingEntity, level);
    }

    public void m_8119_() {
        this.m_6901_();
        this.hitPerTick = 0;
        boolean wasInGround = this.f_36703_;
        super.m_8119_();
        if (!(this.m_20068_() || this.f_36703_ || this.m_36797_())) {
            this.m_20256_(this.m_20184_().m_82520_(0.0, 0.025, 0.0));
        }
        if (wasInGround && !this.f_36703_) {
            this.m_146870_();
        }
    }

    @ParametersAreNonnullByDefault
    protected void m_6532_(HitResult hitResult) {
        if (++this.hitPerTick > 8) {
            this.m_146870_();
            return;
        }
        HitResult.Type resultType = hitResult.m_6662_();
        if (resultType == HitResult.Type.ENTITY) {
            this.m_5790_((EntityHitResult)hitResult);
            if (((EntityHitResult)hitResult).m_82443_() instanceof LivingEntity) {
                this.m_146852_(GameEvent.f_157777_, this.m_37282_());
            }
        } else if (resultType == HitResult.Type.BLOCK) {
            this.m_8060_((BlockHitResult)hitResult);
            this.m_146852_(GameEvent.f_157777_, this.m_37282_());
        }
    }

    @ParametersAreNonnullByDefault
    protected void m_8060_(BlockHitResult blockHitResult) {
        BlockPos pos = blockHitResult.m_82425_();
        BlockState blockState = this.f_19853_.m_8055_(pos);
        if (blockState.m_60734_() instanceof IronBarsBlock && blockState.m_60767_().equals(Material.f_76275_)) {
            this.f_19853_.m_46953_(pos, true, this.m_37282_());
            this.m_20256_(this.m_20184_().m_82490_(0.8));
        } else {
            double hardness = blockState.m_204336_(BlockTags.f_144282_) ? 0.85 : (blockState.m_204336_(BlockTags.f_144280_) ? 0.5 : 0.0);
            if (hardness > 0.0 && this.m_20184_().m_82553_() > 0.55) {
                if (blockState.m_204336_(Tags.Blocks.STORAGE_BLOCKS)) {
                    hardness += 0.1;
                }
                this.m_20256_(BulletEntity.ricochet(this.m_20184_(), blockHitResult.m_82434_().m_122434_(), this.f_19796_, hardness));
                HitResult newHitResult = ProjectileUtil.m_37294_((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
                if (newHitResult.m_6662_() == HitResult.Type.BLOCK) {
                    this.m_6532_(newHitResult);
                }
            } else {
                super.m_8060_(blockHitResult);
            }
        }
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static Vec3 ricochet(Vec3 deltaMovement, Direction.Axis axis, Random random, double hardness) {
        double newX = deltaMovement.f_82479_ * (axis.equals((Object)Direction.Axis.X) ? -hardness : hardness);
        double newY = deltaMovement.f_82480_ * (axis.equals((Object)Direction.Axis.Y) ? -hardness : hardness);
        double newZ = deltaMovement.f_82481_ * (axis.equals((Object)Direction.Axis.Z) ? -hardness : hardness);
        return new Vec3(newX, newY, newZ).m_82520_(random.nextGaussian() * 0.005, random.nextGaussian() * 0.005, random.nextGaussian() * 0.005);
    }

    @ParametersAreNonnullByDefault
    protected void m_5790_(EntityHitResult entityHitResult) {
        Entity target = entityHitResult.m_82443_();
        int invulnerableTime = target.f_19802_;
        target.f_19802_ = 0;
        super.m_5790_(entityHitResult);
        target.f_19802_ = invulnerableTime;
        this.m_146870_();
    }

    @ParametersAreNonnullByDefault
    protected boolean m_142470_(Player player) {
        return false;
    }

    @Nonnull
    protected ItemStack m_7941_() {
        return ItemStack.f_41583_;
    }
}

