/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile;

import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractThrownWeaponEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.item.FireRodItem;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class FireRodEntity
extends AbstractThrownWeaponEntity {
    public FireRodEntity(EntityType<FireRodEntity> entityType, Level level) {
        super(entityType, level);
    }

    public FireRodEntity(Level level, LivingEntity livingEntity, ItemStack spearStack) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.FIRE_ROD.get()), livingEntity, level, spearStack);
        this.m_7311_(Integer.MAX_VALUE);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.m_20291_(0) && (this.f_36703_ || this.f_19853_.m_5822_().nextInt(2) == 1)) {
            SimpleParticleType simpleParticleType;
            Vec3 smokeVec = this.m_20182_();
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, smokeVec.f_82479_, smokeVec.f_82480_, smokeVec.f_82481_, 0.0, 0.0, 0.0);
            Item item = this.m_7846_().m_41720_();
            if (item instanceof FireRodItem) {
                FireRodItem fireRod = (FireRodItem)item;
                simpleParticleType = fireRod.flameParticle;
            } else {
                simpleParticleType = ParticleTypes.f_123744_;
            }
            this.f_19853_.m_7106_((ParticleOptions)simpleParticleType, smokeVec.f_82479_, smokeVec.f_82480_, smokeVec.f_82481_, 0.0, 0.0, 0.0);
        }
    }

    @ParametersAreNonnullByDefault
    protected void m_8060_(BlockHitResult blockHitResult) {
        super.m_8060_(blockHitResult);
        BlockPos pos = blockHitResult.m_82425_();
        BlockState state = this.f_19853_.m_8055_(pos);
        Entity owner = this.m_37282_();
        if (CampfireBlock.m_51321_((BlockState)state) || CandleBlock.m_152845_((BlockState)state) || CandleCakeBlock.m_152910_((BlockState)state)) {
            this.f_19853_.m_7731_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.TRUE), 11);
            this.f_19853_.m_142346_(owner, GameEvent.f_157797_, pos);
        } else {
            BlockPos relativePos = pos.m_142300_(blockHitResult.m_82434_());
            if (BaseFireBlock.m_49255_((Level)this.f_19853_, (BlockPos)relativePos, (Direction)blockHitResult.m_82434_())) {
                BlockState relativeState = BaseFireBlock.m_49245_((BlockGetter)this.f_19853_, (BlockPos)relativePos);
                this.f_19853_.m_7731_(relativePos, relativeState, 11);
                this.f_19853_.m_142346_(owner, GameEvent.f_157797_, pos);
            }
        }
    }

    public boolean m_6060_() {
        return !this.f_19853_.f_46443_ && super.m_6060_();
    }

    public boolean hasBeenExtinguished() {
        return !this.m_20291_(0);
    }

    @Override
    protected String onHitDamageSource() {
        return "BAFireRod";
    }

    @Override
    protected SoundEvent onHitSoundEvent() {
        return SoundEvents.f_12514_;
    }

    @Override
    @NotNull
    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    @Override
    protected Item getDefaultItem() {
        return (Item)BrassArmoryItems.FIRE_ROD.get();
    }
}

