/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile;

import com.milamber_brass.brass_armory.ArmoryUtil;
import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractThrownWeaponEntity;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.item.SpearItem;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import org.jetbrains.annotations.NotNull;

public class SpearEntity
extends AbstractThrownWeaponEntity {
    public SpearEntity(EntityType<SpearEntity> entityType, Level level) {
        super(entityType, level);
    }

    public SpearEntity(Level level, LivingEntity livingEntity, ItemStack spearStack) {
        super((EntityType<? extends AbstractArrow>)((EntityType)BrassArmoryEntityTypes.SPEAR.get()), livingEntity, level, spearStack);
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void m_5790_(EntityHitResult entityHitResult) {
        LivingEntity living;
        Entity entity = entityHitResult.m_82443_();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_6095_() != EntityType.f_20566_ && this.m_7846_().m_41720_() instanceof SpearItem) {
            ArmoryUtil.impaleLivingEntity(living, ((Float)this.f_19804_.m_135370_(DATA_DAMAGE_VALUE)).floatValue(), this.f_19853_.f_46441_);
        }
        super.m_5790_(entityHitResult);
    }

    @Override
    protected String onHitDamageSource() {
        return "BASpear";
    }

    @Override
    protected SoundEvent onHitSoundEvent() {
        return SoundEvents.f_12514_;
    }

    @Override
    @NotNull
    protected SoundEvent m_7239_() {
        return SoundEvents.f_12515_;
    }

    @Override
    protected Item getDefaultItem() {
        return (Item)BrassArmoryItems.WOODEN_SPEAR.get();
    }
}

