/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile.abstracts;

import com.milamber_brass.brass_armory.item.abstracts.AbstractThrownWeaponItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.IndirectEntityDamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractThrownWeaponEntity
extends AbstractArrow
implements ItemSupplier {
    protected static final EntityDataAccessor<ItemStack> DATA_ITEM_STACK = SynchedEntityData.m_135353_(AbstractThrownWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected static final EntityDataAccessor<Integer> DATA_LOYALTY_LEVEL = SynchedEntityData.m_135353_(AbstractThrownWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected static final EntityDataAccessor<Float> DATA_DAMAGE_VALUE = SynchedEntityData.m_135353_(AbstractThrownWeaponEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    protected float power;
    protected boolean dealtDamage;

    public AbstractThrownWeaponEntity(EntityType<? extends AbstractArrow> entityType, Level level) {
        super(entityType, level);
    }

    public AbstractThrownWeaponEntity(EntityType<? extends AbstractArrow> entityType, double x, double y, double z, Level level, ItemStack weaponStack) {
        super(entityType, x, y, z, level);
        this.setItem(weaponStack);
        double damage = 0.0;
        for (AttributeModifier attributeModifier : weaponStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_)) {
            damage += attributeModifier.m_22218_();
        }
        this.f_19804_.m_135381_(DATA_DAMAGE_VALUE, (Object)Float.valueOf((float)damage));
    }

    public AbstractThrownWeaponEntity(EntityType<? extends AbstractArrow> entityType, LivingEntity living, Level level, ItemStack weaponStack) {
        super(entityType, living, level);
        this.setItem(weaponStack);
        double damage = living.m_21133_(Attributes.f_22281_);
        ItemStack mainHandItem = living.m_21205_();
        if (mainHandItem != weaponStack) {
            if (!mainHandItem.m_41619_()) {
                for (AttributeModifier attributeModifier : mainHandItem.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_)) {
                    damage -= attributeModifier.m_22218_();
                }
            }
            for (AttributeModifier attributeModifier : weaponStack.m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_)) {
                damage += attributeModifier.m_22218_();
            }
        }
        this.f_19804_.m_135381_(DATA_DAMAGE_VALUE, (Object)Float.valueOf((float)damage));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ITEM_STACK, (Object)ItemStack.f_41583_);
        this.f_19804_.m_135372_(DATA_LOYALTY_LEVEL, (Object)0);
        this.f_19804_.m_135372_(DATA_DAMAGE_VALUE, (Object)Float.valueOf(1.0f));
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        this.loyaltyTick();
        super.m_8119_();
    }

    protected void loyaltyTick() {
        Entity entity = this.m_37282_();
        double loyaltyLevel = ((Integer)this.f_19804_.m_135370_(DATA_LOYALTY_LEVEL)).intValue();
        if (loyaltyLevel > 0.0 && (this.dealtDamage || this.m_36797_()) && entity != null) {
            if (!(!entity.m_6084_() || entity instanceof ServerPlayer && entity.m_5833_())) {
                this.m_36790_(true);
                this.f_19854_ = this.m_20185_();
                this.f_19855_ = this.m_20186_();
                this.f_19856_ = this.m_20189_();
                Vec3 deltaDifference = entity.m_146892_().m_82546_(this.m_20182_());
                this.m_20256_(this.m_20184_().m_82490_(Math.max(0.0, 1.0 - loyaltyLevel / 10.0)).m_82549_(deltaDifference.m_82541_().m_82490_(loyaltyLevel / 10.0)));
            } else {
                if (!this.f_19853_.f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            }
        }
    }

    public void m_20093_() {
        ItemStack stack = this.m_7846_();
        Item item = stack.m_41720_();
        if (item instanceof TieredItem) {
            Entity entity;
            TieredItem tieredItem = (TieredItem)item;
            Tier tier = tieredItem.m_43314_();
            if (tier != Tiers.NETHERITE && (entity = this.m_37282_()) instanceof LivingEntity) {
                LivingEntity livingOwner = (LivingEntity)entity;
                stack.m_41622_(tier != Tiers.WOOD ? 1 : 2, livingOwner, living -> living.m_21166_(EquipmentSlot.MAINHAND));
            }
            if (stack.m_41773_() == stack.m_41776_()) {
                this.m_6074_();
            }
        }
        super.m_20093_();
    }

    @Nullable
    @ParametersAreNonnullByDefault
    protected EntityHitResult m_6351_(Vec3 pointOne, Vec3 pointTwo) {
        Entity entity;
        EntityHitResult result = super.m_6351_(pointOne, pointTwo);
        if (result != null && (entity = result.m_82443_()) instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            return living.f_20916_ > 0 ? null : super.m_6351_(pointOne, pointTwo);
        }
        return super.m_6351_(pointOne, pointTwo);
    }

    @ParametersAreNonnullByDefault
    protected void m_5790_(EntityHitResult entityHitResult) {
        Item item;
        LivingEntity livingVictim;
        Entity victimEntity = entityHitResult.m_82443_();
        Entity ownerEntity = this.m_37282_();
        float damage = ((Float)this.f_19804_.m_135370_(DATA_DAMAGE_VALUE)).floatValue();
        if (victimEntity instanceof LivingEntity) {
            livingVictim = (LivingEntity)victimEntity;
            damage += EnchantmentHelper.m_44833_((ItemStack)this.m_7846_(), (MobType)livingVictim.m_6336_());
        } else {
            damage += EnchantmentHelper.m_44833_((ItemStack)this.m_7846_(), (MobType)MobType.f_21640_);
        }
        if (this.m_36792_()) {
            damage *= 1.5f;
        }
        if ((item = this.m_7846_().m_41720_()) instanceof AbstractThrownWeaponItem) {
            AbstractThrownWeaponItem item2 = (AbstractThrownWeaponItem)item;
            damage = (float)((double)damage * (this.m_20184_().m_82553_() / (double)item2.getThrowMultiplier()));
        }
        if (victimEntity.m_6469_(new IndirectEntityDamageSource(this.onHitDamageSource(), (Entity)this, (Entity)(ownerEntity == null ? this : ownerEntity)).m_19366_(), damage)) {
            if (victimEntity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (this.m_6060_()) {
                victimEntity.m_20254_(40);
            }
            if (victimEntity instanceof LivingEntity) {
                livingVictim = (LivingEntity)victimEntity;
                if (ownerEntity instanceof LivingEntity) {
                    LivingEntity livingOwner = (LivingEntity)ownerEntity;
                    EnchantmentHelper.m_44823_((LivingEntity)livingVictim, (Entity)livingOwner);
                    EnchantmentHelper.m_44896_((LivingEntity)livingOwner, (Entity)livingVictim);
                }
                this.m_7761_(livingVictim);
            }
        }
        this.dealtDamage = true;
        this.m_20256_(this.onHitDeltaMovement());
        this.m_5496_(this.onHitSoundEvent(), 1.0f, 1.0f);
    }

    protected abstract String onHitDamageSource();

    protected Vec3 onHitDeltaMovement() {
        return this.m_20184_().m_82542_(0.95, 0.95, 0.95);
    }

    protected abstract SoundEvent onHitSoundEvent();

    @ParametersAreNonnullByDefault
    protected boolean m_142470_(Player player) {
        return super.m_142470_(player) || this.m_36797_() && this.m_150171_((Entity)player) && player.m_150109_().m_36054_(this.m_7941_());
    }

    @Nonnull
    protected abstract SoundEvent m_7239_();

    @ParametersAreNonnullByDefault
    public void m_6123_(Player player) {
        if (this.m_150171_((Entity)player) || this.m_37282_() == null) {
            super.m_6123_(player);
        }
    }

    protected abstract Item getDefaultItem();

    protected ItemStack getItemRaw() {
        return (ItemStack)this.f_19804_.m_135370_(DATA_ITEM_STACK);
    }

    @Nonnull
    protected ItemStack m_7941_() {
        return this.m_7846_();
    }

    @ParametersAreNonnullByDefault
    public void setItem(ItemStack weaponStack) {
        weaponStack.m_41636_((Entity)this);
        this.f_19804_.m_135381_(DATA_LOYALTY_LEVEL, (Object)EnchantmentHelper.m_44928_((ItemStack)weaponStack));
        if (!weaponStack.m_150930_(this.getDefaultItem()) || weaponStack.m_41782_()) {
            this.f_19804_.m_135381_(DATA_ITEM_STACK, (Object)((ItemStack)Util.m_137469_((Object)weaponStack.m_41777_(), itemStack -> itemStack.m_41764_(1))));
        }
    }

    @Nonnull
    public ItemStack m_7846_() {
        ItemStack itemstack = this.getItemRaw();
        itemstack.m_41636_((Entity)this);
        return itemstack.m_41619_() ? new ItemStack((ItemLike)this.getDefaultItem()) : itemstack;
    }

    public void setPower(float power) {
        this.power = power;
    }

    public float getPower() {
        return this.power;
    }

    public boolean isInGround() {
        return this.f_36703_;
    }

    @ParametersAreNonnullByDefault
    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        ItemStack weaponStack = this.getItemRaw();
        if (!weaponStack.m_41619_()) {
            compoundTag.m_128365_("WeaponStack", (Tag)weaponStack.m_41739_(new CompoundTag()));
        }
        compoundTag.m_128379_("DealtDamage", this.dealtDamage);
        compoundTag.m_128350_("ThrownWeaponDamage", ((Float)this.f_19804_.m_135370_(DATA_DAMAGE_VALUE)).floatValue());
        compoundTag.m_128405_("LoyaltyLevel", ((Integer)this.f_19804_.m_135370_(DATA_LOYALTY_LEVEL)).intValue());
        compoundTag.m_128350_("ThrownWeaponPower", this.getPower());
    }

    @ParametersAreNonnullByDefault
    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.setItem(ItemStack.m_41712_((CompoundTag)compoundTag.m_128469_("WeaponStack")));
        this.dealtDamage = compoundTag.m_128471_("DealtDamage");
        this.f_19804_.m_135381_(DATA_DAMAGE_VALUE, (Object)Float.valueOf(compoundTag.m_128457_("ThrownWeaponDamage")));
        this.f_19804_.m_135381_(DATA_LOYALTY_LEVEL, (Object)compoundTag.m_128451_("LoyaltyLevel"));
        this.setPower(compoundTag.m_128457_("ThrownWeaponPower"));
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

