/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile.bomb;

import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractRollableItemProjectile;
import com.milamber_brass.brass_armory.entity.projectile.bomb.BombType;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import com.milamber_brass.brass_armory.item.BombItem;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class BombEntity
extends AbstractRollableItemProjectile {
    private static final EntityDataAccessor<Integer> DATA_FUSE = SynchedEntityData.m_135353_(BombEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private boolean defused;

    public BombEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
        this.setFuse(60);
        this.m_6853_(false);
        this.defused = false;
    }

    public BombEntity(Level level, LivingEntity livingEntity, @Nullable HumanoidArm arm) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)BrassArmoryEntityTypes.BOMB.get()), livingEntity, level, arm);
        this.setFuse(60);
        this.m_6853_(false);
        this.defused = false;
    }

    public BombEntity(Level level, double x, double y, double z) {
        super((EntityType<? extends ThrowableItemProjectile>)((EntityType)BrassArmoryEntityTypes.BOMB.get()), x, y, z, level);
        this.setFuse(60);
        this.m_6853_(false);
        this.defused = false;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_FUSE, (Object)80);
    }

    protected BombType getBombType() {
        return BombType.NORMAL;
    }

    @NotNull
    protected Item m_7881_() {
        return BombType.getBombItem(this.getBombType());
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        int newFuse = this.getFuse() - (this.m_6060_() ? 2 : 1);
        this.setFuse(newFuse);
        if (newFuse <= 0) {
            this.m_146870_();
            if (!this.defused && !this.f_19853_.f_46443_) {
                BombEntity.explode(this.f_19853_, (Entity)this);
            }
        }
        if (!this.defused) {
            if (this.f_19853_.f_46443_ && this.f_19853_.m_5822_().nextInt(2) == 1) {
                Vec3 smokeVec = this.m_20182_().m_82549_(this.m_20184_().m_82542_(-1.5, -1.5, -1.5)).m_82520_(0.0, 0.125, 0.0);
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123762_, smokeVec.f_82479_, smokeVec.f_82480_, smokeVec.f_82481_, 0.0, 0.0, 0.0);
            }
            this.m_5496_((SoundEvent)BrassArmorySounds.BOMB_FUSE.get(), 0.03f, this.f_19853_.m_5822_().nextFloat() * 0.6f + 1.0f);
            if (this.m_20072_()) {
                this.setFuse(40);
                this.defused = true;
            }
        }
    }

    public void m_20093_() {
        this.explode(this.f_19853_);
    }

    @ParametersAreNonnullByDefault
    public void m_8038_(ServerLevel serverLevel, LightningBolt lightningBolt) {
        this.explode(this.f_19853_);
    }

    @Override
    @Nonnull
    @ParametersAreNonnullByDefault
    public InteractionResult m_6096_(Player player, InteractionHand hand) {
        return this.defused ? InteractionResult.PASS : super.m_6096_(player, hand);
    }

    @Nonnull
    public ItemStack m_7846_() {
        ItemStack bombStack = super.m_7846_();
        BombItem.setFuseLit(bombStack, true);
        BombItem.setFuseLength(bombStack, this.getFuse());
        bombStack.m_41636_((Entity)this);
        return bombStack;
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void m_8060_(BlockHitResult blockHitResult) {
        if (this.hitPerTick == 7) {
            this.explode(this.f_19853_);
            return;
        }
        super.m_8060_(blockHitResult);
    }

    @Override
    protected double getBounceMultiplier() {
        return this.getBombType().getBounceMultiplier();
    }

    @Override
    protected SoundEvent getSoundEvent() {
        return (SoundEvent)BrassArmorySounds.BOMB_HIT.get();
    }

    @Override
    protected float getVolumeMultiplier() {
        return this.getBombType().getVolumeMultiplier();
    }

    public double m_6049_() {
        return 0.25;
    }

    @ParametersAreNonnullByDefault
    private void explode(Level level) {
        this.m_146870_();
        if (!level.f_46443_) {
            BombEntity.explode(level, (Entity)this);
        }
    }

    public static void explode(Level level, Entity victim) {
        Entity bomb;
        Object object = bomb = victim instanceof BombEntity ? victim : null;
        if (bomb != null && bomb.m_20202_() != null) {
            victim = bomb.m_20202_();
        }
        level.m_46511_(bomb, victim.m_20185_(), victim.m_20186_() + (double)(victim.m_20192_() * 0.5f), victim.m_20189_(), 2.0f, Explosion.BlockInteraction.BREAK);
    }

    @ParametersAreNonnullByDefault
    public void m_7380_(CompoundTag compoundTag) {
        compoundTag.m_128376_("Fuse", (short)this.getFuse());
    }

    @ParametersAreNonnullByDefault
    public void m_7378_(CompoundTag compoundTag) {
        this.setFuse(compoundTag.m_128448_("Fuse"));
    }

    public void setFuse(int newFuse) {
        this.f_19804_.m_135381_(DATA_FUSE, (Object)newFuse);
    }

    public int getFuse() {
        return (Integer)this.f_19804_.m_135370_(DATA_FUSE);
    }

    public boolean getDefused() {
        return this.defused;
    }
}

