/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.entity.projectile.bomb;

import com.milamber_brass.brass_armory.entity.projectile.bomb.BombEntity;
import com.milamber_brass.brass_armory.entity.projectile.bomb.BombType;
import com.milamber_brass.brass_armory.init.BrassArmorySounds;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class StickyBombEntity
extends BombEntity {
    public StickyBombEntity(EntityType<? extends ThrowableItemProjectile> entityType, Level level) {
        super(entityType, level);
    }

    public StickyBombEntity(Level level, LivingEntity livingEntity, @Nullable HumanoidArm arm) {
        super(level, livingEntity, arm);
    }

    public StickyBombEntity(Level level, double x, double y, double z) {
        super(level, x, y, z);
    }

    @Override
    public BombType getBombType() {
        return BombType.STICKY;
    }

    public boolean m_20096_() {
        return this.m_20068_();
    }

    @Override
    protected void onGroundTick() {
        this.isStuck(null);
    }

    private boolean isStuck(@Nullable Vec3 vec) {
        AABB aabb = this.m_142469_().m_82400_(0.1);
        if (vec != null) {
            aabb = aabb.m_82383_(vec);
        }
        boolean flag = !this.f_19853_.m_45756_((Entity)this, aabb) || this.m_20202_() instanceof LivingEntity;
        this.m_20242_(flag);
        if (flag) {
            this.m_20334_(0.0, 0.0, 0.0);
        }
        return flag;
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void m_6532_(HitResult hitResult) {
        super.m_6532_(hitResult);
        this.m_20334_(0.0, 0.0, 0.0);
    }

    @ParametersAreNonnullByDefault
    protected void m_5790_(EntityHitResult entityHitResult) {
        if (!this.f_19853_.f_46443_) {
            Entity mount = entityHitResult.m_82443_();
            if (this.m_37282_() != mount && mount instanceof LivingEntity) {
                this.m_20329_(entityHitResult.m_82443_());
            }
        }
        super.m_5790_(entityHitResult);
    }

    @Override
    @ParametersAreNonnullByDefault
    protected void m_8060_(BlockHitResult blockHitResult) {
        Vec3 newMovement;
        Vec3 movement = this.m_20184_();
        double d = 0.0;
        while (true) {
            if (this.isStuck(newMovement = movement.m_82542_(d, d, d))) break;
            d += 0.025;
        }
        this.m_20219_(this.m_20182_().m_82549_(newMovement));
    }

    @Override
    protected SoundEvent getSoundEvent() {
        return (SoundEvent)BrassArmorySounds.STICKY_BOMB_HIT.get();
    }
}

