/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.event;

import com.milamber_brass.brass_armory.BrassArmory;
import com.milamber_brass.brass_armory.client.gui.GunScreen;
import com.milamber_brass.brass_armory.client.render.BAArrowRenderer;
import com.milamber_brass.brass_armory.client.render.BoomerangEntityRenderer;
import com.milamber_brass.brass_armory.client.render.BulletRenderer;
import com.milamber_brass.brass_armory.client.render.FlailHeadEntityRenderer;
import com.milamber_brass.brass_armory.client.render.RollingItemEntityRenderer;
import com.milamber_brass.brass_armory.client.render.SpearEntityRenderer;
import com.milamber_brass.brass_armory.client.render.ThrownWeaponEntityRenderer;
import com.milamber_brass.brass_armory.container.GunContainer;
import com.milamber_brass.brass_armory.entity.projectile.FireRodEntity;
import com.milamber_brass.brass_armory.entity.projectile.bomb.BombEntity;
import com.milamber_brass.brass_armory.entity.projectile.bomb.BombType;
import com.milamber_brass.brass_armory.init.BrassArmoryBlocks;
import com.milamber_brass.brass_armory.init.BrassArmoryEntityTypes;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.init.BrassArmoryMenus;
import com.milamber_brass.brass_armory.init.BrassArmoryModels;
import com.milamber_brass.brass_armory.item.BombItem;
import com.milamber_brass.brass_armory.item.FlailItem;
import com.milamber_brass.brass_armory.item.HalberdItem;
import com.milamber_brass.brass_armory.item.abstracts.AbstractGunItem;
import com.milamber_brass.brass_armory.item.abstracts.AbstractThrownWeaponItem;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.client.renderer.item.ItemProperties;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;

@Mod.EventBusSubscriber(modid="brass_armory", bus=Mod.EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ClientEventBusSubscriber {
    @SubscribeEvent
    @ParametersAreNonnullByDefault
    public static void clientSetup(FMLClientSetupEvent event) {
        BrassArmory.LOGGER.debug("Running client setup.");
        EntityRenderers.m_174036_((EntityType)((EntityType)BrassArmoryEntityTypes.BA_ARROW.get()), BAArrowRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BrassArmoryEntityTypes.BULLET.get()), BulletRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BrassArmoryEntityTypes.BOMB.get()), RollingItemEntityRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BrassArmoryEntityTypes.BOUNCY_BOMB.get()), RollingItemEntityRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BrassArmoryEntityTypes.STICKY_BOMB.get()), RollingItemEntityRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BrassArmoryEntityTypes.SPIKY_BALL.get()), RollingItemEntityRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BrassArmoryEntityTypes.FLAIL_HEAD.get()), FlailHeadEntityRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BrassArmoryEntityTypes.BOOMERANG.get()), BoomerangEntityRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BrassArmoryEntityTypes.SPEAR.get()), SpearEntityRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BrassArmoryEntityTypes.FIRE_ROD.get()), SpearEntityRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BrassArmoryEntityTypes.DAGGER.get()), ThrownWeaponEntityRenderer::new);
        EntityRenderers.m_174036_((EntityType)((EntityType)BrassArmoryEntityTypes.BATTLEAXE.get()), ThrownWeaponEntityRenderer::new);
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BrassArmoryBlocks.EXPLORERS_ROPE_BLOCK.get()), (RenderType)RenderType.m_110463_());
        event.enqueueWork(() -> {
            MenuScreens.m_96206_((MenuType)((MenuType)BrassArmoryMenus.GUN_MENU.get()), GunScreen::new);
            for (BombType bombType : BombType.values()) {
                ItemProperties.register((Item)BombType.getBombItem(bombType), (ResourceLocation)new ResourceLocation("bomb_fuse"), (bombStack, clientLevel, living, k) -> {
                    LivingEntity entity;
                    Object object = entity = living != null ? living : bombStack.m_41609_();
                    if (!BombItem.getFuseLit(bombStack) || entity == null) {
                        return 1.0f;
                    }
                    if (clientLevel == null && entity.f_19853_ instanceof ClientLevel) {
                        clientLevel = (ClientLevel)entity.f_19853_;
                    }
                    if (clientLevel == null || !(bombStack.m_41720_() instanceof BombItem)) {
                        return 1.0f;
                    }
                    return (float)BombItem.getFuseLength(bombStack) / 60.0f;
                });
                ItemProperties.register((Item)BombType.getBombItem(bombType), (ResourceLocation)new ResourceLocation("defused"), (bombStack, clientLevel, living, k) -> {
                    BombEntity bomb;
                    LivingEntity entity = living != null ? living : bombStack.m_41609_();
                    return entity instanceof BombEntity && (bomb = (BombEntity)entity).getDefused() ? 1.0f : 0.0f;
                });
            }
            for (HalberdItem halberdItem : new HalberdItem[]{(HalberdItem)BrassArmoryItems.WOODEN_HALBERD.get(), (HalberdItem)BrassArmoryItems.STONE_HALBERD.get(), (HalberdItem)BrassArmoryItems.IRON_HALBERD.get(), (HalberdItem)BrassArmoryItems.GOLDEN_HALBERD.get(), (HalberdItem)BrassArmoryItems.DIAMOND_HALBERD.get(), (HalberdItem)BrassArmoryItems.NETHERITE_HALBERD.get()}) {
                ItemProperties.register((Item)halberdItem, (ResourceLocation)new ResourceLocation("stance"), (halberdStack, clientLevel, living, k) -> HalberdItem.getStance(halberdStack) ? 1.0f : 0.0f);
            }
            for (AbstractThrownWeaponItem abstractThrownWeaponItem : new AbstractThrownWeaponItem[]{(AbstractThrownWeaponItem)BrassArmoryItems.WOODEN_SPEAR.get(), (AbstractThrownWeaponItem)BrassArmoryItems.STONE_SPEAR.get(), (AbstractThrownWeaponItem)BrassArmoryItems.IRON_SPEAR.get(), (AbstractThrownWeaponItem)BrassArmoryItems.GOLDEN_SPEAR.get(), (AbstractThrownWeaponItem)BrassArmoryItems.DIAMOND_SPEAR.get(), (AbstractThrownWeaponItem)BrassArmoryItems.NETHERITE_SPEAR.get(), (AbstractThrownWeaponItem)BrassArmoryItems.FIRE_ROD.get(), (AbstractThrownWeaponItem)BrassArmoryItems.WOODEN_FLAIL.get(), (AbstractThrownWeaponItem)BrassArmoryItems.STONE_FLAIL.get(), (AbstractThrownWeaponItem)BrassArmoryItems.IRON_FLAIL.get(), (AbstractThrownWeaponItem)BrassArmoryItems.GOLDEN_FLAIL.get(), (AbstractThrownWeaponItem)BrassArmoryItems.DIAMOND_FLAIL.get(), (AbstractThrownWeaponItem)BrassArmoryItems.NETHERITE_FLAIL.get()}) {
                ItemProperties.register((Item)abstractThrownWeaponItem, (ResourceLocation)new ResourceLocation("throwing"), (spearStack, clientLevel, living, k) -> living != null && living.m_6117_() && living.m_21211_() == spearStack ? 1.0f : 0.0f);
            }
            ItemProperties.register((Item)((Item)BrassArmoryItems.FIRE_ROD.get()), (ResourceLocation)new ResourceLocation("extinguished"), (fireRodStack, clientLevel, living, k) -> {
                FireRodEntity fireRodEntity;
                Entity patt6883$temp = fireRodStack.m_41609_();
                return patt6883$temp instanceof FireRodEntity && (fireRodEntity = (FireRodEntity)patt6883$temp).hasBeenExtinguished() ? 1.0f : 0.0f;
            });
            ItemProperties.register((Item)((Item)BrassArmoryItems.FIRE_ROD.get()), (ResourceLocation)new ResourceLocation("gui"), (fireRodStack, clientLevel, living, k) -> living == null || living.m_21055_((Item)BrassArmoryItems.FIRE_ROD.get()) ? 0.0f : 1.0f);
            for (FlailItem flailItem : new FlailItem[]{(FlailItem)BrassArmoryItems.WOODEN_FLAIL.get(), (FlailItem)BrassArmoryItems.STONE_FLAIL.get(), (FlailItem)BrassArmoryItems.IRON_FLAIL.get(), (FlailItem)BrassArmoryItems.GOLDEN_FLAIL.get(), (FlailItem)BrassArmoryItems.DIAMOND_FLAIL.get(), (FlailItem)BrassArmoryItems.NETHERITE_FLAIL.get()}) {
                ItemProperties.register((Item)flailItem, (ResourceLocation)new ResourceLocation("no_head"), (stack, clientLevel, living, k) -> living != null && flailItem.isExtended(living, stack) ? 1.0f : 0.0f);
            }
            for (AbstractGunItem abstractGunItem : new AbstractGunItem[]{(AbstractGunItem)BrassArmoryItems.FLINTLOCK_PISTOL.get(), (AbstractGunItem)BrassArmoryItems.MUSKET.get(), (AbstractGunItem)BrassArmoryItems.BLUNDERBUSS.get()}) {
                ItemProperties.register((Item)abstractGunItem, (ResourceLocation)new ResourceLocation("loading"), (stack, clientLevel, living, k) -> living != null && living.m_6117_() && AbstractGunItem.getLoad(stack) == 1 ? 1.0f : 0.0f);
                ItemProperties.register((Item)abstractGunItem, (ResourceLocation)new ResourceLocation("status"), (stack, clientLevel, living, k) -> living != null && living.m_6117_() ? AbstractGunItem.getLoadProgress(stack) / 20.0f : 0.0f);
                ItemProperties.register((Item)abstractGunItem, (ResourceLocation)new ResourceLocation("loaded"), (stack, clientLevel, living, k) -> AbstractGunItem.getLoad(stack) == 2 ? 1.0f : 0.0f);
                ItemProperties.register((Item)abstractGunItem, (ResourceLocation)new ResourceLocation("menu"), (stack, clientLevel, living, k) -> {
                    if (!(living instanceof Player)) return 0.0f;
                    Player player = (Player)living;
                    if (!(player.f_36096_ instanceof GunContainer)) return 0.0f;
                    if (!stack.m_41782_()) return 0.0f;
                    if (!stack.m_41784_().m_128471_("InGunContainerMenu")) return 0.0f;
                    return 1.0f;
                });
            }
            ItemProperties.register((Item)((Item)BrassArmoryItems.LONGBOW.get()), (ResourceLocation)new ResourceLocation("pull"), (stack, clientLevel, living, k) -> living == null ? 0.0f : (living.m_21211_() != stack ? 0.0f : (float)(stack.m_41779_() - living.m_21212_()) / 30.0f));
            ItemProperties.register((Item)((Item)BrassArmoryItems.LONGBOW.get()), (ResourceLocation)new ResourceLocation("pulling"), (stack, clientLevel, living, k) -> living != null && living.m_6117_() && living.m_21211_() == stack ? 1.0f : 0.0f);
        });
    }

    @SubscribeEvent
    public static void layerDefinitions(EntityRenderersEvent.RegisterLayerDefinitions event) {
        BrassArmoryModels.register(event);
    }

    @SubscribeEvent
    @ParametersAreNonnullByDefault
    public static void TextureStitchEvent(TextureStitchEvent.Pre event) {
        if (event.getAtlas().m_118330_().equals((Object)InventoryMenu.f_39692_)) {
            event.addSprite(GunContainer.EMPTY_POWDER_SLOT);
            event.addSprite(GunContainer.EMPTY_AMMO_SLOT);
        }
    }
}

