/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.event;

import com.milamber_brass.brass_armory.init.BrassArmoryBlocks;
import com.milamber_brass.brass_armory.item.LongBowItem;
import com.milamber_brass.brass_armory.item.MaceItem;
import com.milamber_brass.brass_armory.item.abstracts.AbstractGunItem;
import com.milamber_brass.brass_armory.item.abstracts.AbstractThrownWeaponItem;
import com.milamber_brass.brass_armory.item.interfaces.ICustomAnimationItem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="brass_armory", value={Dist.CLIENT})
public class ClientEventSubscriber {
    @SubscribeEvent
    @ParametersAreNonnullByDefault
    public static void RenderHandEvent(RenderHandEvent event) {
        ItemStack eventItem;
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player != null && player.m_6117_() && ((eventItem = event.getItemStack()).m_41720_() instanceof ICustomAnimationItem || eventItem.m_41720_() instanceof LongBowItem || eventItem.m_41720_() instanceof AbstractThrownWeaponItem && eventItem.m_41720_().m_6164_(player.m_21211_()) == UseAnim.SPEAR)) {
            boolean doubleMace;
            event.setCanceled(true);
            boolean bl = doubleMace = player.m_21205_().m_41720_() instanceof MaceItem && player.m_21206_().m_41720_() instanceof MaceItem;
            if (player.m_7655_() == event.getHand() || doubleMace) {
                boolean mainHandFlag = event.getHand() == InteractionHand.MAIN_HAND;
                HumanoidArm humanoidarm = mainHandFlag ? player.m_5737_() : player.m_5737_().m_20828_();
                boolean rightHandFlag = humanoidarm == HumanoidArm.RIGHT;
                float k = rightHandFlag ? 1.0f : -1.0f;
                ItemTransforms.TransformType transformType = rightHandFlag ? ItemTransforms.TransformType.FIRST_PERSON_RIGHT_HAND : ItemTransforms.TransformType.FIRST_PERSON_LEFT_HAND;
                PoseStack poseStack = event.getPoseStack();
                ItemStack itemStack = event.getItemStack();
                if (doubleMace) {
                    poseStack.m_85836_();
                }
                float f8 = (float)itemStack.m_41779_() - (float)player.m_21212_();
                poseStack.m_85837_((double)(k * 0.56f), (double)-0.52f, (double)-0.72f);
                Item item = itemStack.m_41720_();
                if (item instanceof ICustomAnimationItem) {
                    ICustomAnimationItem animationItem = (ICustomAnimationItem)item;
                    float maxCharge = animationItem.getChargeDuration(itemStack);
                    float v = Math.min(f8, maxCharge);
                    event.setCanceled(true);
                    float m = v / (maxCharge * 10.0f);
                    double sineWave = Math.sin((double)f8 * 200.0) * 0.002;
                    poseStack.m_85837_(0.0, sineWave + (double)m, (double)m);
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-13.935f + m * 200.0f));
                    poseStack.m_85845_(Vector3f.f_122224_.m_122240_(k * 9.7f));
                    poseStack.m_85845_(Vector3f.f_122227_.m_122240_(k * -9.785f));
                    poseStack.m_85841_(1.0f + (float)sineWave, 1.0f + (float)sineWave, 1.0f + (float)sineWave);
                } else if (itemStack.m_41720_() instanceof LongBowItem) {
                    poseStack.m_85837_((double)(k * -0.2785682f), 0.18344387412071228, 0.15731531381607056);
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-13.935f));
                    poseStack.m_85845_(Vector3f.f_122225_.m_122240_(k * 35.3f));
                    poseStack.m_85845_(Vector3f.f_122227_.m_122240_(k * -9.785f));
                    float f12 = f8 / 30.0f;
                    f12 = (f12 * f12 + f12 * 2.0f) / 3.0f;
                    if (f12 > 1.0f) {
                        f12 = 1.0f;
                    }
                    if (f12 > 0.1f) {
                        float f15 = Mth.m_14031_((float)((f8 - 0.1f) * 1.3f));
                        float f18 = f12 - 0.1f;
                        float f20 = f15 * f18;
                        poseStack.m_85837_((double)(f20 * 0.0f), (double)(f20 * 0.004f), (double)(f20 * 0.0f));
                    }
                    poseStack.m_85837_((double)(f12 * 0.0f), (double)(f12 * 0.0f), (double)(f12 * 0.04f));
                    poseStack.m_85841_(1.0f, 1.0f, 1.0f + f12 * 0.2f);
                    poseStack.m_85845_(Vector3f.f_122224_.m_122240_(k * 45.0f));
                } else {
                    float f;
                    poseStack.m_85837_((double)(k * -0.5f), (double)0.7f, (double)0.1f);
                    poseStack.m_85845_(Vector3f.f_122223_.m_122240_(-55.0f));
                    poseStack.m_85845_(Vector3f.f_122225_.m_122240_(k * 35.3f));
                    poseStack.m_85845_(Vector3f.f_122227_.m_122240_(k * -9.785f));
                    Item f18 = eventItem.m_41720_();
                    if (f18 instanceof AbstractThrownWeaponItem) {
                        AbstractThrownWeaponItem item2 = (AbstractThrownWeaponItem)f18;
                        f = item2.chargeDuration;
                    } else {
                        f = 10.0f;
                    }
                    float f11 = f8 / f;
                    if (f11 > 1.0f) {
                        f11 = 1.0f;
                    }
                    if (f11 > 0.1f) {
                        float f14 = Mth.m_14031_((float)((f8 - 0.1f) * 1.3f));
                        float f17 = f11 - 0.1f;
                        float f19 = f14 * f17;
                        poseStack.m_85837_((double)(f19 * 0.0f), (double)(f19 * 0.004f), (double)(f19 * 0.0f));
                    }
                    poseStack.m_85837_(0.0, 0.0, (double)(f11 * 0.2f));
                    poseStack.m_85841_(1.0f, 1.0f, 1.0f + f11 * 0.2f);
                    poseStack.m_85845_(Vector3f.f_122224_.m_122240_(k * 45.0f));
                }
                new ItemInHandRenderer(mc).m_109322_((LivingEntity)player, itemStack, transformType, !rightHandFlag, poseStack, event.getMultiBufferSource(), event.getPackedLight());
                if (doubleMace) {
                    poseStack.m_85849_();
                }
            }
        }
    }

    @SubscribeEvent
    @ParametersAreNonnullByDefault
    public static void RenderPlayerEvent(RenderPlayerEvent.Pre event) {
        Player player = event.getPlayer();
        if (player.m_21205_().m_41720_() instanceof AbstractGunItem && AbstractGunItem.getLoad(player.m_21205_()) == 2) {
            if (player.m_5737_() == HumanoidArm.RIGHT) {
                ((PlayerModel)event.getRenderer().m_7200_()).f_102816_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                ((PlayerModel)event.getRenderer().m_7200_()).f_102815_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        } else if (player.m_21206_().m_41720_() instanceof AbstractGunItem && AbstractGunItem.getLoad(player.m_21206_()) == 2) {
            if (player.m_5737_() == HumanoidArm.LEFT) {
                ((PlayerModel)event.getRenderer().m_7200_()).f_102816_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
            } else {
                ((PlayerModel)event.getRenderer().m_7200_()).f_102815_ = HumanoidModel.ArmPose.BOW_AND_ARROW;
            }
        }
    }

    @SubscribeEvent
    @ParametersAreNonnullByDefault
    public static void FOVUpdate(EntityViewRenderEvent.FieldOfView event) {
        ItemStack useStack;
        Item useItem;
        LivingEntity living;
        Entity entity = event.getCamera().m_90592_();
        if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_6117_() && ((useItem = (useStack = living.m_21211_()).m_41720_()) instanceof LongBowItem || useItem instanceof ICustomAnimationItem || useItem instanceof AbstractThrownWeaponItem)) {
            float f9;
            float i = (float)living.m_21252_() + (float)event.getPartialTicks();
            if (useItem instanceof AbstractThrownWeaponItem) {
                AbstractThrownWeaponItem thrownWeaponItem = (AbstractThrownWeaponItem)useItem;
                f9 = thrownWeaponItem.chargeDuration;
            } else if (useItem instanceof ICustomAnimationItem) {
                ICustomAnimationItem customAnimationItem = (ICustomAnimationItem)useItem;
                f9 = customAnimationItem.getChargeDuration(useStack);
            } else {
                f9 = 30.0f;
            }
            float f1 = i / f9;
            f1 = f1 > 1.0f ? 1.0f : f1 * f1;
            event.setFOV(event.getFOV() * (double)(1.0f - f1 * (useItem instanceof LongBowItem ? 0.15f : 0.075f)));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void onRegisterBlocks(RegistryEvent.Register<Block> event) {
        RenderType cutoutRenderType = RenderType.m_110463_();
        ItemBlockRenderTypes.setRenderLayer((Block)((Block)BrassArmoryBlocks.EXPLORERS_ROPE_BLOCK.get()), (RenderType)cutoutRenderType);
    }
}

