/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.event;

import com.milamber_brass.brass_armory.entity.projectile.bomb.BombEntity;
import com.milamber_brass.brass_armory.entity.projectile.bomb.BombType;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.item.BombItem;
import com.milamber_brass.brass_armory.item.LongBowItem;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.BasicItemListing;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="brass_armory")
public class ServerEventSubscriber {
    @SubscribeEvent
    @ParametersAreNonnullByDefault
    public static void PlayerContainerEvent(PlayerContainerEvent.Open event) {
        Player player = event.getPlayer();
        for (ItemStack stack : player.m_150109_().f_35974_) {
            Item item = stack.m_41720_();
            if (!(item instanceof BombItem)) continue;
            BombItem bombItem = (BombItem)item;
            if (!BombItem.getFuseLit(stack)) continue;
            BombEntity bomb = BombType.playerBombEntityFromType(bombItem.getBombType(), player.f_19853_, player, null);
            bomb.setFuse(BombItem.getFuseLength(stack));
            bomb.m_37446_(stack);
            BombItem.setFuseLength(stack, 60);
            BombItem.setFuseLit(stack, false);
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            player.f_19853_.m_7967_((Entity)bomb);
        }
    }

    @SubscribeEvent
    @ParametersAreNonnullByDefault
    public static void WandererTradesEvent(WandererTradesEvent event) {
        event.getRareTrades().add(new BasicItemListing(8, ((BombItem)BrassArmoryItems.BOMB.get()).m_7968_(), 8, 4, 4.0f));
        event.getRareTrades().add(new BasicItemListing(10, ((LongBowItem)BrassArmoryItems.LONGBOW.get()).m_7968_(), 3, 6, 1.0f));
    }
}

