/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.init;

import com.milamber_brass.brass_armory.BrassArmory;
import com.milamber_brass.brass_armory.init.BrassArmoryItems;
import com.milamber_brass.brass_armory.item.BABaseArrowItem;
import com.milamber_brass.brass_armory.item.BombItem;
import com.milamber_brass.brass_armory.item.abstracts.AbstractGunItem;
import com.milamber_brass.brass_armory.item.ammo_behaviour.AbstractAmmoBehaviour;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;

public class BrassArmoryItemGroups {
    public static final CreativeModeTab BRASS_ARMORY = new CreativeModeTab("brass_armory"){

        @Nonnull
        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)BrassArmoryItems.GOLDEN_BATTLEAXE.get());
        }

        public boolean hasSearchBar() {
            return true;
        }

        public int getSearchbarWidth() {
            return 79;
        }

        @Nonnull
        public ResourceLocation getBackgroundImage() {
            return BrassArmory.locate("textures/gui/creative_tab.png");
        }

        public int getLabelColor() {
            return 0xFFAA00;
        }

        @ParametersAreNonnullByDefault
        public void m_6151_(NonNullList<ItemStack> itemStacks) {
            ArrayList tieredItems = new ArrayList();
            ArrayList bowItems = new ArrayList();
            ArrayList gunItems = new ArrayList();
            ArrayList ammoItems = new ArrayList();
            ArrayList bombItems = new ArrayList();
            ArrayList arrowItems = new ArrayList();
            ArrayList blockItems = new ArrayList();
            List<Item> allItems = ForgeRegistries.ITEMS.getValues().stream().filter(item -> item.getCreativeTabs().contains((Object)this)).filter(item -> {
                if (item instanceof TieredItem) {
                    TieredItem tieredItem = (TieredItem)item;
                    tieredItems.add(tieredItem);
                    return false;
                }
                if (item instanceof BowItem) {
                    BowItem bowItem = (BowItem)item;
                    bowItems.add(bowItem);
                    return false;
                }
                if (item instanceof AbstractGunItem) {
                    AbstractGunItem gunItem = (AbstractGunItem)((Object)item);
                    gunItems.add(gunItem);
                    return false;
                }
                if (item instanceof BombItem) {
                    BombItem bombItem = (BombItem)((Object)item);
                    bombItems.add(bombItem);
                    return false;
                }
                if (item instanceof BABaseArrowItem) {
                    BABaseArrowItem arrowItem = (BABaseArrowItem)((Object)item);
                    arrowItems.add(arrowItem);
                    return false;
                }
                if (item instanceof BlockItem) {
                    BlockItem blockItem = (BlockItem)item;
                    blockItems.add(blockItem);
                    return false;
                }
                if (AbstractAmmoBehaviour.itemHasAmmoBehaviour(item)) {
                    ammoItems.add(item);
                    return false;
                }
                return true;
            }).toList();
            tieredItems.stream().sorted(Comparator.comparingDouble(tieredItem -> {
                Tier tier = tieredItem.m_43314_();
                if (tier == Tiers.WOOD) {
                    return 0.1;
                }
                if (tier == Tiers.STONE) {
                    return 0.2;
                }
                if (tier == Tiers.GOLD) {
                    return 0.3;
                }
                if (tier == Tiers.IRON) {
                    return 0.4;
                }
                if (tier == Tiers.DIAMOND) {
                    return 0.5;
                }
                if (tier == Tiers.NETHERITE) {
                    return 0.6;
                }
                return tieredItem.m_43314_().m_6631_();
            })).forEach(item -> item.m_6787_((CreativeModeTab)this, itemStacks));
            gunItems.stream().sorted(Comparator.comparingDouble(AbstractGunItem::getDamageMultiplier)).forEach(item -> item.m_6787_(this, itemStacks));
            ammoItems.forEach(item -> item.m_6787_((CreativeModeTab)this, itemStacks));
            bombItems.forEach(item -> item.m_6787_(this, itemStacks));
            allItems.forEach(item -> item.m_6787_((CreativeModeTab)this, itemStacks));
            bowItems.forEach(item -> item.m_6787_((CreativeModeTab)this, itemStacks));
            arrowItems.forEach(item -> item.m_6787_(this, itemStacks));
            blockItems.forEach(item -> item.m_6787_((CreativeModeTab)this, itemStacks));
        }
    };
}

