/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.item;

import com.google.common.collect.ImmutableSet;
import com.milamber_brass.brass_armory.entity.projectile.BoomerangEntity;
import com.milamber_brass.brass_armory.entity.projectile.abstracts.AbstractThrownWeaponEntity;
import com.milamber_brass.brass_armory.item.abstracts.AbstractThrownWeaponItem;
import com.milamber_brass.brass_armory.item.interfaces.ICustomAnimationItem;
import java.lang.reflect.Field;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class BoomerangItem
extends AbstractThrownWeaponItem
implements ICustomAnimationItem {
    private final ImmutableSet<Enchantment> properEnchantments = ImmutableSet.of((Object)Enchantments.f_44990_, (Object)Enchantments.f_44960_);
    public static final String critTag = "BABoomerangCrit";
    public static final String timeTag = "BABoomerangTime";
    private static Field toolHighlightTimerField = null;

    public BoomerangItem(Tier tier, int attackDamage, float attackSpeed, Item.Properties properties) {
        super(tier, attackDamage, attackSpeed, 18.0f, 1.25f, properties);
    }

    @Override
    @Nonnull
    protected AbstractThrownWeaponEntity getEntity(Level level, LivingEntity living, ItemStack boomerangStack) {
        BoomerangEntity boomerangEntity = new BoomerangEntity(level, living, boomerangStack);
        boomerangEntity.m_36762_(level.f_46441_.nextFloat(100.0f) <= BoomerangItem.getCrit(boomerangStack));
        return boomerangEntity;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public Component m_7626_(ItemStack boomerangStack) {
        int crit = (int)BoomerangItem.getCrit(boomerangStack);
        if (crit <= 0) {
            return super.m_7626_(boomerangStack);
        }
        return new TextComponent("Critical Strike: " + crit + "%").m_130948_(Style.f_131099_.m_131136_(Boolean.valueOf(true)).m_178520_(0xC80000 + (5 - crit / 20) * 10000));
    }

    @ParametersAreNonnullByDefault
    public void m_6883_(ItemStack boomerangStack, Level level, Entity entity, int i, boolean b) {
        float crit = BoomerangItem.getCrit(boomerangStack);
        if (crit > 0.0f && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            int drain = (int)Math.min(level.m_46467_() - BoomerangItem.getTime(boomerangStack), 1000L) / 20;
            if (!level.f_46443_ && drain > 0 && !living.m_6117_()) {
                boomerangStack.m_41784_().m_128350_(critTag, Math.max(crit - (float)drain, 0.0f));
            }
            if (level.f_46443_ && living.m_21205_() == boomerangStack) {
                if (toolHighlightTimerField == null) {
                    toolHighlightTimerField = ObfuscationReflectionHelper.findField(Gui.class, (String)"f_92993_");
                    toolHighlightTimerField.setAccessible(true);
                }
                try {
                    toolHighlightTimerField.set(Minecraft.m_91087_().f_91065_, 40);
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
        super.m_6883_(boomerangStack, level, entity, i, b);
    }

    @Override
    @ParametersAreNonnullByDefault
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) || this.properEnchantments.contains((Object)enchantment);
    }

    @Override
    public float getChargeDuration(ItemStack boomerangStack) {
        int quickCharge = Math.min(EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)boomerangStack), 4);
        return quickCharge == 0 ? this.chargeDuration : this.chargeDuration - (float)(3 * quickCharge);
    }

    @ParametersAreNonnullByDefault
    public static void setCrit(ItemStack boomerangStack, float crit, long time) {
        boomerangStack.m_41784_().m_128350_(critTag, Math.min(crit, 100.0f));
        boomerangStack.m_41784_().m_128356_(timeTag, time);
    }

    @ParametersAreNonnullByDefault
    public static float getCrit(ItemStack boomerangStack) {
        if (boomerangStack.m_41783_() != null && boomerangStack.m_41783_().m_128441_(critTag)) {
            return boomerangStack.m_41784_().m_128457_(critTag);
        }
        return 0.0f;
    }

    @ParametersAreNonnullByDefault
    public static long getTime(ItemStack boomerangStack) {
        if (boomerangStack.m_41783_() != null && boomerangStack.m_41783_().m_128441_(timeTag)) {
            return boomerangStack.m_41784_().m_128454_(timeTag);
        }
        return 0L;
    }
}

