/*
 * Decompiled with CFR 0.152.
 */
package com.milamber_brass.brass_armory.item.abstracts;

import com.google.common.collect.Lists;
import com.milamber_brass.brass_armory.container.GunContainer;
import com.milamber_brass.brass_armory.item.ammo_behaviour.AbstractAmmoBehaviour;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;

public abstract class AbstractGunItem
extends ProjectileWeaponItem
implements Vanishable {
    protected final boolean oneHanded;
    protected final int maxAmmoItems;
    public final double damageMultiplier;
    protected final float loadSpeed;
    protected final float accuracy;
    protected final double recoil;

    public AbstractGunItem(Item.Properties properties, boolean oneHanded, int maxAmmo, double damageMultiplier, float loadSpeed, float accuracy, double recoil) {
        super(properties);
        this.oneHanded = oneHanded;
        this.maxAmmoItems = maxAmmo;
        this.damageMultiplier = damageMultiplier;
        this.loadSpeed = loadSpeed;
        this.accuracy = accuracy;
        this.recoil = recoil;
    }

    public double getDamageMultiplier() {
        return this.damageMultiplier;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public UseAnim m_6164_(ItemStack gunStack) {
        return UseAnim.NONE;
    }

    @ParametersAreNonnullByDefault
    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand interactionHand) {
        ItemStack stack = player.m_21120_(interactionHand);
        block0 : switch (AbstractGunItem.getLoad(stack)) {
            case 0: {
                if (level.f_46443_) break;
                SimpleMenuProvider container = new SimpleMenuProvider(GunContainer.getServerContainer(stack), TextComponent.f_131282_);
                NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)container);
                break;
            }
            case 1: {
                player.m_6672_(interactionHand);
                break;
            }
            default: {
                Vec3 view = player.m_20252_(level.f_46443_ ? Minecraft.m_91087_().m_91296_() : 0.0f).m_82490_(-this.recoil);
                player.m_5997_(view.f_82479_, view.f_82480_, view.f_82481_);
                if (!level.f_46443_) {
                    for (ItemStack ammoStack : AbstractGunItem.loadStack(stack, "BAAmmo")) {
                        AbstractAmmoBehaviour.getStackBehaviour(ammoStack).ifPresent(ammoBehaviour -> {
                            if (ammoBehaviour.onShoot(level, (LivingEntity)player, stack, ammoStack, this.damageMultiplier, this.accuracy, 5.0f)) {
                                stack.m_41622_(1, (LivingEntity)player, living -> player.m_21190_(player.m_7655_()));
                            }
                        });
                    }
                    level.m_6269_(null, (Entity)player, SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    AbstractGunItem.setLoad(stack, 0);
                    AbstractGunItem.clearStack(stack, "BAAmmo");
                    AbstractGunItem.clearStack(stack, "BAPowder");
                    AbstractGunItem.setLoadProgress(stack, 0.0f);
                    player.m_36335_().m_41524_(stack.m_41720_(), 10);
                    player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    break;
                }
                float partialTicks = Minecraft.m_91087_().m_91296_();
                double d = 0.0;
                while (true) {
                    int n = this.oneHanded ? 3 : 5;
                    if (!(d < (double)n)) break block0;
                    for (int i = 0; i < (this.oneHanded ? 5 : 8); ++i) {
                        for (double o = 0.0; o < 1.0; o += 0.1) {
                            Vec3 vec3 = player.m_20299_(partialTicks);
                            Vec3 vec31 = player.m_20252_(partialTicks);
                            Vec3 vec32 = vec3.m_82520_(vec31.f_82479_ * d + level.f_46441_.nextGaussian() * o, vec31.f_82480_ * d + level.f_46441_.nextGaussian() * o, vec31.f_82481_ * d + level.f_46441_.nextGaussian() * o);
                            Vec3 particlePos = level.m_45547_(new ClipContext(vec3, vec32, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)).m_82450_();
                            level.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(new Vec3(0.98, 0.94, 0.9)), 0.8f), particlePos.f_82479_, particlePos.f_82480_, particlePos.f_82481_, 0.0, 0.0, 0.0);
                        }
                    }
                    d += 1.0;
                }
            }
        }
        return InteractionResultHolder.m_19096_((Object)player.m_21120_(interactionHand));
    }

    public void onUsingTick(ItemStack stack, LivingEntity entityLiving, int count) {
        AbstractGunItem.setLoadProgress(stack, AbstractGunItem.getLoadProgress(stack) + this.loadSpeed);
    }

    @ParametersAreNonnullByDefault
    public void m_5551_(ItemStack stack, Level level, LivingEntity entityLiving, int timeLeft) {
        if (entityLiving instanceof Player) {
            Player player = (Player)entityLiving;
            if (AbstractGunItem.getLoadProgress(stack) < 20.0f) {
                AbstractGunItem.setLoadProgress(stack, 0.0f);
            } else {
                AbstractGunItem.setLoad(stack, 2);
                player.m_36335_().m_41524_(stack.m_41720_(), 5);
                player.f_19853_.m_6269_(player, (Entity)player, SoundEvents.f_11796_, SoundSource.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public boolean isOneHanded() {
        return this.oneHanded;
    }

    public int getMaxAmmoItems() {
        return this.maxAmmoItems;
    }

    @ParametersAreNonnullByDefault
    public boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_41720_().equals(newStack.m_41720_()) || slotChanged;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public static void setLoadProgress(ItemStack gunStack, float progress) {
        if (gunStack.m_41783_() != null) {
            CompoundTag compoundtag = gunStack.m_41783_().m_6426_();
            compoundtag.m_128350_("LoadProgress", Math.min(progress, 20.0f));
            gunStack.m_41751_(compoundtag);
        }
    }

    @ParametersAreNonnullByDefault
    public static float getLoadProgress(ItemStack gunStack) {
        if (gunStack.m_41782_() && gunStack.m_41783_() != null) {
            return gunStack.m_41783_().m_128457_("LoadProgress");
        }
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128350_("LoadProgress", 0.0f);
        gunStack.m_41751_(new CompoundTag());
        return 0.0f;
    }

    @ParametersAreNonnullByDefault
    public static void setLoad(ItemStack gunStack, int load) {
        CompoundTag tag = gunStack.m_41783_() != null ? gunStack.m_41783_().m_6426_() : new CompoundTag();
        tag.m_128405_("BAGunLoaded", load);
        gunStack.m_41751_(tag);
    }

    @ParametersAreNonnullByDefault
    public static int getLoad(ItemStack gunStack) {
        if (gunStack.m_41782_() && gunStack.m_41783_() != null) {
            return gunStack.m_41783_().m_128451_("BAGunLoaded");
        }
        CompoundTag compoundtag = new CompoundTag();
        compoundtag.m_128405_("BAGunLoaded", 0);
        gunStack.m_41751_(new CompoundTag());
        return 0;
    }

    @ParametersAreNonnullByDefault
    public static void addStack(ItemStack weaponStack, ItemStack itemStack, String name) {
        CompoundTag weaponCompoundTag = weaponStack.m_41784_();
        ListTag listtag = weaponCompoundTag.m_128425_(name, 9) ? weaponCompoundTag.m_128437_(name, 10) : new ListTag();
        CompoundTag ammoCompoundTag = new CompoundTag();
        itemStack.m_41739_(ammoCompoundTag);
        listtag.add((Object)ammoCompoundTag);
        weaponCompoundTag.m_128365_(name, (Tag)listtag);
    }

    @Nonnull
    @ParametersAreNonnullByDefault
    public static List<ItemStack> loadStack(ItemStack weaponStack, String name) {
        ArrayList list = Lists.newArrayList();
        CompoundTag compoundtag = weaponStack.m_41783_();
        if (compoundtag != null && compoundtag.m_128425_(name, 9)) {
            ListTag listtag = compoundtag.m_128437_(name, 10);
            for (int i = 0; i < listtag.size(); ++i) {
                CompoundTag ammoCompoundTag = listtag.m_128728_(i);
                list.add(ItemStack.m_41712_((CompoundTag)ammoCompoundTag));
            }
        }
        return list;
    }

    @ParametersAreNonnullByDefault
    private static void clearStack(ItemStack weaponStack, String name) {
        CompoundTag compoundtag = weaponStack.m_41783_();
        if (compoundtag != null) {
            ListTag listtag = compoundtag.m_128437_(name, 9);
            listtag.clear();
            compoundtag.m_128365_(name, (Tag)listtag);
        }
    }

    @ParametersAreNonnullByDefault
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        stack.m_41622_(1, attacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    @ParametersAreNonnullByDefault
    public boolean m_6813_(ItemStack stack, Level worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if ((double)state.m_60800_((BlockGetter)worldIn, pos) != 0.0) {
            stack.m_41622_(2, entityLiving, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    @Nonnull
    public Predicate<ItemStack> m_6437_() {
        return Optional.ofNullable(this.getAmmoType()).map(itemTag -> stack -> stack.m_204117_(itemTag)).orElseGet(() -> stack -> false);
    }

    @Nullable
    protected abstract TagKey<Item> getAmmoType();

    public int m_6615_() {
        return 0;
    }
}

